/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.action;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.action.MethodDescriptorLexer;
import weblogic.diagnostics.instrumentation.action.MethodDescriptorParser;
import weblogic.utils.time.Timer;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class MethodInvocationStatisticsAction
extends AbstractDiagnosticAction
implements AroundDiagnosticAction {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticInstrumentationActions");
    static final long serialVersionUID = -4957607339728632810L;
    private static final String COUNT = "count";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String AVG = "avg";
    private static final String SUM = "sum";
    private static final String SUM_OF_SQUARES = "sum_of_squares";
    private static final String STD_DEVIATION = "std_deviation";
    private Map parsedMethodDescriptorCache = new ConcurrentHashMap();

    public MethodInvocationStatisticsAction() {
        this.setType("MethodInvocationStatisticsAction");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public DiagnosticActionState createState() {
        return new MethodInvocationStatisticsActionState();
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        MethodInvocationStatisticsActionState methodInvocationStatisticsActionState = (MethodInvocationStatisticsActionState)diagnosticActionState;
        methodInvocationStatisticsActionState.initBeginTimestamp();
    }

    public void postProcess(final JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        DiagnosticMonitor diagnosticMonitor = this.getDiagnosticMonitor();
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Monitor class = " + diagnosticMonitor.getClass().getName());
        }
        if (diagnosticMonitor instanceof DiagnosticMonitorControl) {
            DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
            InstrumentationScope instrumentationScope = diagnosticMonitorControl.getInstrumentationScope();
            final Map map = instrumentationScope.getInstrumentationStatistics().getMethodInvocationStatistics();
            MethodInvocationStatisticsActionState methodInvocationStatisticsActionState = (MethodInvocationStatisticsActionState)diagnosticActionState;
            methodInvocationStatisticsActionState.initEndTimestamp();
            final long l = methodInvocationStatisticsActionState.computeElaspedTime();
            WORKMANAGER_GETTER.workManager.schedule(new Runnable(){

                public void run() {
                    MethodInvocationStatisticsAction.this.updateMethodInvocationStatistics(joinPoint, map, l);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMethodInvocationStatistics(JoinPoint joinPoint, Map map, long l) {
        CharSequence charSequence;
        long l2 = System.nanoTime();
        String string = joinPoint.getClassName();
        String string2 = joinPoint.getMethodName();
        String string3 = joinPoint.getMethodDescriptor();
        if (DEBUG.isDebugEnabled()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Class=");
            ((StringBuilder)charSequence).append(string);
            ((StringBuilder)charSequence).append(";");
            ((StringBuilder)charSequence).append("Method=");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(";");
            ((StringBuilder)charSequence).append("MethodDescriptor=");
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append(";");
            DEBUG.debug(((StringBuilder)charSequence).toString());
        }
        if ((charSequence = (String)this.parsedMethodDescriptorCache.get(string3)) == null) {
            charSequence = this.parseMethodDescriptor(string3);
            this.parsedMethodDescriptorCache.put(string3, charSequence);
        } else if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Got md from cache " + string3 + "=" + (String)charSequence);
        }
        if (charSequence != null) {
            ConcurrentHashMap concurrentHashMap;
            ConcurrentHashMap concurrentHashMap2 = (ConcurrentHashMap)map;
            concurrentHashMap2.putIfAbsent(string, new ConcurrentHashMap());
            ConcurrentHashMap concurrentHashMap3 = (ConcurrentHashMap)concurrentHashMap2.get(string);
            concurrentHashMap3.putIfAbsent(string2, new ConcurrentHashMap());
            ConcurrentHashMap concurrentHashMap4 = (ConcurrentHashMap)concurrentHashMap3.get(string2);
            concurrentHashMap4.putIfAbsent(charSequence, new ConcurrentHashMap());
            ConcurrentHashMap concurrentHashMap5 = concurrentHashMap = (ConcurrentHashMap)concurrentHashMap4.get(charSequence);
            synchronized (concurrentHashMap5) {
                Number number = null;
                long l3 = 0L;
                long l4 = -1L;
                long l5 = -1L;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                number = (Number)concurrentHashMap.get(COUNT);
                if (number != null) {
                    l3 = number.longValue();
                }
                if ((number = (Number)concurrentHashMap.get(MIN)) != null) {
                    l4 = number.longValue();
                }
                if ((number = (Number)concurrentHashMap.get(MAX)) != null) {
                    l5 = number.longValue();
                }
                if ((number = (Number)concurrentHashMap.get(SUM)) != null) {
                    d = number.doubleValue();
                }
                if ((number = (Number)concurrentHashMap.get(AVG)) != null) {
                    d2 = number.doubleValue();
                }
                if ((number = (Number)concurrentHashMap.get(SUM_OF_SQUARES)) != null) {
                    d3 = number.doubleValue();
                }
                if ((number = (Number)concurrentHashMap.get(STD_DEVIATION)) != null) {
                    d4 = number.doubleValue();
                }
                ++l3;
                if (l4 == -1L) {
                    l4 = l;
                } else {
                    long l6 = l4 = l < l4 ? l : l4;
                }
                l5 = l5 == -1L ? l : (l > l5 ? l : l5);
                long l7 = System.nanoTime();
                d2 = (d += (double)l) / (double)l3;
                long l8 = System.nanoTime();
                double d5 = l;
                long l9 = System.nanoTime();
                double d6 = (d3 += d5 * d5) / (double)l3 - d2 * d2;
                d4 = Math.sqrt(d6);
                long l10 = System.nanoTime();
                if (DEBUG.isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Count=");
                    stringBuilder.append(l3);
                    stringBuilder.append(";");
                    stringBuilder.append("Min=");
                    stringBuilder.append(l4);
                    stringBuilder.append(";");
                    stringBuilder.append("Max=");
                    stringBuilder.append(l5);
                    stringBuilder.append(";");
                    stringBuilder.append("Avg=");
                    stringBuilder.append(d2);
                    stringBuilder.append(";");
                    stringBuilder.append("Sum=");
                    stringBuilder.append(d);
                    stringBuilder.append(";");
                    stringBuilder.append("Sum of squares=");
                    stringBuilder.append(d3);
                    stringBuilder.append(";");
                    stringBuilder.append("Std Deviation=");
                    stringBuilder.append(d4);
                    stringBuilder.append(";");
                    DEBUG.debug(stringBuilder.toString());
                }
                concurrentHashMap.put(COUNT, new Long(l3));
                concurrentHashMap.put(MIN, new Long(l4));
                concurrentHashMap.put(MAX, new Long(l5));
                concurrentHashMap.put(AVG, new Double(d2));
                concurrentHashMap.put(SUM, new Double(d));
                concurrentHashMap.put(SUM_OF_SQUARES, new Double(d3));
                concurrentHashMap.put(STD_DEVIATION, new Double(d4));
                long l11 = System.nanoTime();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Stats overhead:" + l + "," + (l8 - l7) + "," + (l9 - l8) + "," + (l10 - l9) + "," + (l11 - l2));
                }
            }
        }
    }

    private String parseMethodDescriptor(String string) {
        StringReader stringReader = new StringReader(string);
        MethodDescriptorLexer methodDescriptorLexer = new MethodDescriptorLexer(stringReader);
        MethodDescriptorParser methodDescriptorParser = new MethodDescriptorParser(methodDescriptorLexer);
        try {
            methodDescriptorParser.methodDescriptor();
            List list = methodDescriptorParser.getInputParameters();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Input params = " + list);
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            if (n > 0) {
                for (int i = 0; i < n - 1; ++i) {
                    stringBuilder.append(list.get(i));
                    stringBuilder.append(',');
                }
                stringBuilder.append(list.get(n - 1));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Exception parsing", (Throwable)exception);
            }
            return null;
        }
    }

    private static class MethodInvocationStatisticsActionState
    implements DiagnosticActionState {
        private static Timer timer = Timer.createTimer();
        private long beginTimestamp;
        private long endTimestamp;

        private MethodInvocationStatisticsActionState() {
        }

        void initBeginTimestamp() {
            this.beginTimestamp = timer.timestamp();
        }

        void initEndTimestamp() {
            this.endTimestamp = timer.timestamp();
        }

        long computeElaspedTime() {
            return this.endTimestamp - this.beginTimestamp;
        }
    }

    static class WORKMANAGER_GETTER {
        static WorkManager workManager = WorkManagerFactory.getInstance().findOrCreate("weblogic.diagnostics.instrumentation.MethodInvocationStatisticsActionWorkManager", 1, -1);

        WORKMANAGER_GETTER() {
        }
    }
}

