/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.action;

import java.security.AccessController;
import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.StatelessDiagnosticAction;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JVMRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class ThreadDumpAction
extends AbstractDiagnosticAction
implements StatelessDiagnosticAction {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ServerRuntimeMBean serverRuntime;

    public ThreadDumpAction() {
        this.setType("ThreadDumpAction");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public void process(JoinPoint joinPoint) {
        InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, false);
        if (instrumentationEvent != null) {
            String string = null;
            try {
                if (this.serverRuntime == null) {
                    JVMRuntimeMBean jVMRuntimeMBean;
                    this.serverRuntime = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                    if (this.serverRuntime != null && (jVMRuntimeMBean = this.serverRuntime.getJVMRuntime()) != null) {
                        string = jVMRuntimeMBean.getThreadStackDump();
                    }
                }
                if (string == null) {
                    string = "UNAVAILABLE";
                }
                instrumentationEvent.setPayload(string);
                EventQueue.getInstance().enqueue(instrumentationEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

