/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.action;

import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.utils.time.Timer;

public final class TraceElapsedTimeAction
extends AbstractDiagnosticAction
implements AroundDiagnosticAction {
    public TraceElapsedTimeAction() {
        this.setType("TraceElapsedTimeAction");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public DiagnosticActionState createState() {
        return new TraceElapsedTimeActionState();
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        TraceElapsedTimeActionState traceElapsedTimeActionState = (TraceElapsedTimeActionState)diagnosticActionState;
        Timer timer = Timer.createTimer();
        traceElapsedTimeActionState.setValue(timer.timestamp());
        DiagnosticMonitor diagnosticMonitor = this.getDiagnosticMonitor();
        if (diagnosticMonitor != null) {
            InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, false);
            if (instrumentationEvent == null) {
                return;
            }
            instrumentationEvent.setEventType(this.getType() + "-Before-" + traceElapsedTimeActionState.getId());
            EventQueue.getInstance().enqueue(instrumentationEvent);
        }
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, false);
        if (instrumentationEvent == null) {
            return;
        }
        TraceElapsedTimeActionState traceElapsedTimeActionState = (TraceElapsedTimeActionState)diagnosticActionState;
        Timer timer = Timer.createTimer();
        instrumentationEvent.setPayload(new Long(timer.timestamp() - traceElapsedTimeActionState.getValue()));
        instrumentationEvent.setEventType(this.getType() + "-After-" + traceElapsedTimeActionState.getId());
        EventQueue.getInstance().enqueue(instrumentationEvent);
    }

    private static class TraceElapsedTimeActionState
    implements DiagnosticActionState {
        private static int seqNum;
        private int id = TraceElapsedTimeActionState.genId();
        private long value;

        TraceElapsedTimeActionState() {
        }

        int getId() {
            return this.id;
        }

        long getValue() {
            return this.value;
        }

        void setValue(long l) {
            this.value = l;
        }

        private static synchronized int genId() {
            return ++seqNum;
        }
    }
}

