/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;

public final class TraceMemoryAllocationAction
extends AbstractDiagnosticAction
implements AroundDiagnosticAction {
    private static final long serialVersionUID = 1L;
    private static Method getAllocatedBytesMethod = TraceMemoryAllocationAction.getAllocatedBytesMethod();

    public TraceMemoryAllocationAction() {
        this.setType("TraceMemoryAllocationAction");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public DiagnosticActionState createState() {
        if (getAllocatedBytesMethod == null) {
            return null;
        }
        return new TraceMemoryAllocationActionState();
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        if (diagnosticActionState == null) {
            return;
        }
        TraceMemoryAllocationActionState traceMemoryAllocationActionState = (TraceMemoryAllocationActionState)diagnosticActionState;
        long l = 0L;
        if (getAllocatedBytesMethod != null) {
            try {
                l = (Long)getAllocatedBytesMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        traceMemoryAllocationActionState.setValue(l);
        DiagnosticMonitor diagnosticMonitor = this.getDiagnosticMonitor();
        if (diagnosticMonitor != null) {
            InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, false);
            if (instrumentationEvent == null) {
                return;
            }
            instrumentationEvent.setEventType(this.getType() + "-Before-" + traceMemoryAllocationActionState.getId());
            EventQueue.getInstance().enqueue(instrumentationEvent);
        }
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        if (diagnosticActionState == null) {
            return;
        }
        InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, false);
        if (instrumentationEvent == null) {
            return;
        }
        TraceMemoryAllocationActionState traceMemoryAllocationActionState = (TraceMemoryAllocationActionState)diagnosticActionState;
        long l = 0L;
        if (getAllocatedBytesMethod != null) {
            try {
                l = (Long)getAllocatedBytesMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        instrumentationEvent.setPayload(new Long(l - traceMemoryAllocationActionState.getValue()));
        instrumentationEvent.setEventType(this.getType() + "-After-" + traceMemoryAllocationActionState.getId());
        EventQueue.getInstance().enqueue(instrumentationEvent);
    }

    private static Method getAllocatedBytesMethod() {
        try {
            Class<?> clazz = Class.forName("jrockit.ext.ThreadInfo");
            Method method = clazz.getMethod("getAllocatedBytes", null);
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static class TraceMemoryAllocationActionState
    implements DiagnosticActionState {
        private static int seqNum;
        private int id = TraceMemoryAllocationActionState.genId();
        private long value;

        TraceMemoryAllocationActionState() {
        }

        int getId() {
            return this.id;
        }

        long getValue() {
            return this.value;
        }

        void setValue(long l) {
            this.value = l;
        }

        private static synchronized int genId() {
            return ++seqNum;
        }
    }
}

