/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.gathering;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Handler;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringHandler;
import weblogic.logging.JDKLoggerFactory;
import weblogic.logging.LoggingHelper;

final class DataGatheringLogService {
    private static DebugLogger debugLog = DebugLogger.getDebugLogger((String)"DebugDiagnosticDataGathering");
    private static Object logHandler = null;

    DataGatheringLogService() {
    }

    static void registerToServerLogger(int n) {
        int n2 = Math.max(n, 64);
        if (JDKLoggerFactory.isLog4jEnabled()) {
            try {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug("DataGatheringLogService.registerToServerLogger(" + n + ") registering log4j appender with severity " + n2);
                }
                Class<?> clazz = Class.forName("weblogic.logging.log4j.Log4jLoggingHelper", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("getLog4jServerLogger", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("org.apache.log4j.Logger", true, Thread.currentThread().getContextClassLoader());
                Class<?> clazz3 = Class.forName("weblogic.diagnostics.instrumentation.gathering.DataGatheringAppender", true, Thread.currentThread().getContextClassLoader());
                Constructor<?> constructor = clazz3.getConstructor(clazz2, Integer.TYPE);
                Object obj = constructor.newInstance(object, new Integer(n2));
                Method method2 = clazz2.getMethod("addAppender", Class.forName("org.apache.log4j.Appender", true, Thread.currentThread().getContextClassLoader()));
                method2.invoke(object, obj);
                logHandler = obj;
                return;
            }
            catch (Exception exception) {
                DiagnosticsLogger.logErrorRegisteringLog4jDataGatheringAppender((Throwable)exception);
            }
        } else {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DataGatheringLogService.registerToServerLogger(" + n + ") registering log handler with severity " + n2);
            }
            logHandler = new DataGatheringHandler(n2);
            LoggingHelper.getServerLogger().addHandler((Handler)logHandler);
        }
    }

    static void deregisterFromServerLogger() {
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("DataGatheringLogService.deregisterFromServerLogger()");
        }
        if (logHandler == null) {
            return;
        }
        if (JDKLoggerFactory.isLog4jEnabled()) {
            try {
                Class<?> clazz = Class.forName("weblogic.logging.log4j.Log4jLoggingHelper", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("getLog4jServerLogger", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("org.apache.log4j.Logger", true, Thread.currentThread().getContextClassLoader());
                Method method2 = clazz2.getMethod("removeAppender", Class.forName("org.apache.log4j.Appender", true, Thread.currentThread().getContextClassLoader()));
                method2.invoke(object, logHandler);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logErrorRegisteringLog4jDataGatheringAppender((Throwable)exception);
            }
        } else {
            LoggingHelper.getServerLogger().removeHandler((Handler)logHandler);
        }
    }
}

