/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.gathering;

import com.bea.logging.BaseLogRecord;
import com.bea.logging.LogLevel;
import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Producer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.flightrecorder.FlightRecorderManager;
import weblogic.diagnostics.flightrecorder.event.BaseInstantEvent;
import weblogic.diagnostics.flightrecorder.event.BaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorActivateEndpointEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorBaseEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorDeactivateEndpointEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorEndpointBaseEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorInboundTransactionRollbackEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundConnectionErrorEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundDestroyConnectionEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundRegisterResourceEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundReleaseConnectionEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundReserveConnectionEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundTransactionRollbackEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorOutboundUnregisterResourceEvent;
import weblogic.diagnostics.flightrecorder.event.ConnectorTransactionBaseEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBaseInstantEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodInvokeEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPostInvokeCleanupEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPostInvokeEvent;
import weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPreInvokeEvent;
import weblogic.diagnostics.flightrecorder.event.EJBDatabaseAccessEvent;
import weblogic.diagnostics.flightrecorder.event.EJBHomeCreateEvent;
import weblogic.diagnostics.flightrecorder.event.EJBHomeRemoveEvent;
import weblogic.diagnostics.flightrecorder.event.EJBPoolManagerCreateEvent;
import weblogic.diagnostics.flightrecorder.event.EJBPoolManagerPostInvokeEvent;
import weblogic.diagnostics.flightrecorder.event.EJBPoolManagerPreInvokeEvent;
import weblogic.diagnostics.flightrecorder.event.EJBPoolManagerRemoveEvent;
import weblogic.diagnostics.flightrecorder.event.EJBReplicatedSessionManagerEvent;
import weblogic.diagnostics.flightrecorder.event.EJBTimerManagerEvent;
import weblogic.diagnostics.flightrecorder.event.GlobalInformationEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCBaseInstantEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionCloseEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionCommitEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionCreateStatementEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionGetVendorConnectionEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionPrepareEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionReleaseEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionReserveEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCConnectionRollbackEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCDataSourceGetConnectionEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCDriverConnectEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCStatementCreationEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCStatementExecuteEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionBaseEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionCommitEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionEndEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionGetXAResourceEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionIsSameRMEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionPrepareEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionRollbackEvent;
import weblogic.diagnostics.flightrecorder.event.JDBCTransactionStartEvent;
import weblogic.diagnostics.flightrecorder.event.JMSBEConsumerLogEvent;
import weblogic.diagnostics.flightrecorder.event.JTABaseInstantEvent;
import weblogic.diagnostics.flightrecorder.event.JTATransactionCommitEvent;
import weblogic.diagnostics.flightrecorder.event.JTATransactionEndEvent;
import weblogic.diagnostics.flightrecorder.event.JTATransactionPrepareEvent;
import weblogic.diagnostics.flightrecorder.event.JTATransactionPreparedEvent;
import weblogic.diagnostics.flightrecorder.event.JTATransactionStartEvent;
import weblogic.diagnostics.flightrecorder.event.LogRecordEvent;
import weblogic.diagnostics.flightrecorder.event.LoggingEvent;
import weblogic.diagnostics.flightrecorder.event.ServletAsyncActionEvent;
import weblogic.diagnostics.flightrecorder.event.ServletBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.ServletCheckAccessEvent;
import weblogic.diagnostics.flightrecorder.event.ServletContextExecuteEvent;
import weblogic.diagnostics.flightrecorder.event.ServletContextHandleThrowableEvent;
import weblogic.diagnostics.flightrecorder.event.ServletExecuteEvent;
import weblogic.diagnostics.flightrecorder.event.ServletFilterEvent;
import weblogic.diagnostics.flightrecorder.event.ServletInvocationEvent;
import weblogic.diagnostics.flightrecorder.event.ServletRequestActionEvent;
import weblogic.diagnostics.flightrecorder.event.ServletRequestCancelEvent;
import weblogic.diagnostics.flightrecorder.event.ServletRequestDispatchEvent;
import weblogic.diagnostics.flightrecorder.event.ServletRequestOverloadEvent;
import weblogic.diagnostics.flightrecorder.event.ServletRequestRunEvent;
import weblogic.diagnostics.flightrecorder.event.ServletResponseSendEvent;
import weblogic.diagnostics.flightrecorder.event.ServletResponseWriteHeadersEvent;
import weblogic.diagnostics.flightrecorder.event.ServletStaleResourceEvent;
import weblogic.diagnostics.flightrecorder.event.ThrottleInformationEvent;
import weblogic.diagnostics.flightrecorder.event.WLLogRecordEvent;
import weblogic.diagnostics.flightrecorder.event.WebApplicationBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.WebApplicationLoadEvent;
import weblogic.diagnostics.flightrecorder.event.WebApplicationUnloadEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCClientRequestActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCClientResponseActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCDispatchActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCRequestActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCResponseActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSBaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSEndPointEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSRequestActionEvent;
import weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSResourceEvent;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringLogService;
import weblogic.diagnostics.instrumentation.gathering.FlightRecorderEventHelper;
import weblogic.diagnostics.instrumentation.gathering.WLLog4jLogEventClassHelper;
import weblogic.logging.WLLogRecord;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataGatheringManager
implements PropertyChangeListener {
    private static DebugLogger debugLog = DebugLogger.getDebugLogger((String)"DebugDiagnosticDataGathering");
    private static boolean initialized = false;
    private static boolean gatheringEnabledDetermined = false;
    private static boolean gatheringEnabled = true;
    public static final int OFF = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int[] MAX_CHUNK_SIZE_MULTIPLE = new int[]{3, 3, 4, 5};
    public static boolean[] ENABLE_STACK_TRACES = new boolean[]{false, false, false, true};
    public static boolean jfrActionsDisabled = false;
    private static boolean constantPoolsEnabled = true;
    private static int diagnosticVolume = 0;
    private static int severity = 64;
    private static WLDFServerDiagnosticMBean wldfConfig;
    private static LogFilterMBean serverLogFileFilterConfig;
    private static final AuthenticatedSubject KERNEL_ID;
    private static RuntimeAccess runtimeAccess;
    private static DataGatheringManager SINGLETON;
    private static Producer baseProducer;
    private static Producer lowProducer;
    private static Producer mediumProducer;
    private static Producer highProducer;
    private Method isGatheringExtended = null;
    private Method updateServerManagedMonitors = null;
    private Object instrumentationManager = null;
    private static final Class[] updateArgs;
    private static WLLog4jLogEventClassHelper wlLog4jLogEventHelper;
    private static List<String> eventClassNamesInUse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RuntimeAccess getRuntimeAccess() {
        if (runtimeAccess != null) return runtimeAccess;
        Class<DataGatheringManager> clazz = DataGatheringManager.class;
        synchronized (DataGatheringManager.class) {
            if (runtimeAccess != null) return runtimeAccess;
            runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            // ** MonitorExit[var0] (shouldn't be in output)
            return runtimeAccess;
        }
    }

    public static void gatherLoggingEvent(Object object, int n) {
        int n2;
        if (diagnosticVolume == 0) {
            return;
        }
        if (DataGatheringManager.recordBasedOnSeverity(n)) {
            Helper.recordLoggingEvent(object);
        }
        if (!wlLog4jLogEventHelper.isAvailable(object)) {
            return;
        }
        if (wlLog4jLogEventHelper.isInstance(object.getClass()) && wlLog4jLogEventHelper.isGatherable(object) && diagnosticVolume >= (n2 = DataGatheringManager.convertVolume(wlLog4jLogEventHelper.getDiagnosticVolume(object)))) {
            Helper.recordLoggingEvent(object);
        }
    }

    public static void gatherLogRecord(LogRecord logRecord) {
        if (diagnosticVolume == 0) {
            return;
        }
        int n = LogLevel.getSeverity((Level)logRecord.getLevel());
        if (DataGatheringManager.recordBasedOnSeverity(LogLevel.getSeverity((Level)logRecord.getLevel()))) {
            if (logRecord instanceof WLLogRecord) {
                Helper.recordWLLogRecord(logRecord);
            } else {
                Helper.recordLogRecord(logRecord);
            }
            return;
        }
        if (!(logRecord instanceof BaseLogRecord)) {
            return;
        }
        BaseLogRecord baseLogRecord = (BaseLogRecord)logRecord;
        if (!baseLogRecord.isGatherable()) {
            return;
        }
        int n2 = DataGatheringManager.convertVolume(baseLogRecord.getDiagnosticVolume());
        if (diagnosticVolume >= n2) {
            if (logRecord instanceof WLLogRecord) {
                Helper.recordWLLogRecord(logRecord);
            } else {
                Helper.recordLogRecord(logRecord);
            }
        }
    }

    private static boolean recordBasedOnSeverity(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
            case 8: {
                if (diagnosticVolume == 1) break;
                return true;
            }
        }
        return false;
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        try {
            int n;
            String string = System.getProperty("weblogic.diagnostics.instrumentation.gathering.JFRConstantPoolsEnabled", "true");
            if (!string.equalsIgnoreCase("true")) {
                constantPoolsEnabled = false;
            }
            DataGatheringManager.ENABLE_STACK_TRACES[1] = (n = DataGatheringManager.convertVolume(System.getProperty("weblogic.diagnostics.flightrecorder.StackTracesEnabled", "high"))) != 0 && n == 1;
            DataGatheringManager.ENABLE_STACK_TRACES[2] = n != 0 && n != 3;
            DataGatheringManager.ENABLE_STACK_TRACES[3] = n != 0;
            jfrActionsDisabled = Boolean.getBoolean("weblogic.diagnostics.instrumentation.gathering.JFRActionsDisabled");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        wldfConfig = DataGatheringManager.getRuntimeAccess().getServer().getServerDiagnosticConfig();
        diagnosticVolume = DataGatheringManager.convertVolume(wldfConfig.getWLDFDiagnosticVolume());
        if (FlightRecorderManager.isRecordingPossible()) {
            FlightRecorderManager.setDefaultSettings((int)MAX_CHUNK_SIZE_MULTIPLE[diagnosticVolume], (boolean)ENABLE_STACK_TRACES[diagnosticVolume]);
            DataGatheringManager.initializeProducers();
        }
        SINGLETON = new DataGatheringManager();
        wldfConfig.addPropertyChangeListener(SINGLETON);
        initialized = true;
    }

    public static synchronized void setEventClassNamesInUse(List<String> list) {
        if (eventClassNamesInUse == null) {
            eventClassNamesInUse = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGatheringEnabled() {
        if (gatheringEnabledDetermined) {
            return gatheringEnabled;
        }
        Class<DataGatheringManager> clazz = DataGatheringManager.class;
        synchronized (DataGatheringManager.class) {
            if (FlightRecorderManager.isRecordingPossible()) {
                gatheringEnabled = true;
                gatheringEnabledDetermined = true;
            } else {
                if (SINGLETON == null) {
                    DataGatheringManager.initialize();
                }
                gatheringEnabled = SINGLETON.invokeIsGatheringExtended();
                gatheringEnabledDetermined = true;
                if (gatheringEnabled) {
                    jfrActionsDisabled = true;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gatheringEnabled;
        }
    }

    public static boolean jfrActionsDisabled() {
        return jfrActionsDisabled;
    }

    public static synchronized void initializeLogging() {
        if (!initialized) {
            DataGatheringManager.initialize();
        }
        if (!DataGatheringManager.isGatheringEnabled()) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Data Gathering is not enabled, no logger handling is registered for it");
            }
            return;
        }
        wlLog4jLogEventHelper = WLLog4jLogEventClassHelper.getInstance();
        serverLogFileFilterConfig = DataGatheringManager.getRuntimeAccess().getServer().getLog().getLogFileFilter();
        if (serverLogFileFilterConfig != null) {
            severity = serverLogFileFilterConfig.getSeverityLevel();
        }
        DataGatheringManager.registerLogger();
        if (serverLogFileFilterConfig != null) {
            serverLogFileFilterConfig.addPropertyChangeListener(SINGLETON);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Class<DataGatheringManager> clazz = DataGatheringManager.class;
        synchronized (DataGatheringManager.class) {
            int n;
            int n2 = DataGatheringManager.convertVolume(wldfConfig.getWLDFDiagnosticVolume());
            if (n2 != diagnosticVolume) {
                if (n2 == 0) {
                    if (lowProducer != null) {
                        lowProducer.disable();
                    }
                    if (mediumProducer != null) {
                        mediumProducer.disable();
                    }
                    if (highProducer != null) {
                        highProducer.disable();
                    }
                    FlightRecorderManager.disableJVMEventsInRecording();
                } else if (n2 == 1) {
                    if (lowProducer != null) {
                        lowProducer.enable();
                    }
                    if (mediumProducer != null) {
                        mediumProducer.disable();
                    }
                    if (highProducer != null) {
                        highProducer.disable();
                    }
                    if (FlightRecorderManager.areJVMEventsExpensive()) {
                        FlightRecorderManager.disableJVMEventsInRecording();
                    } else {
                        FlightRecorderManager.enableJVMEventsInRecording();
                    }
                } else if (n2 == 2) {
                    if (lowProducer != null) {
                        lowProducer.enable();
                    }
                    if (mediumProducer != null) {
                        mediumProducer.enable();
                    }
                    if (highProducer != null) {
                        highProducer.disable();
                    }
                    FlightRecorderManager.enableJVMEventsInRecording();
                } else if (n2 == 3) {
                    if (lowProducer != null) {
                        lowProducer.enable();
                    }
                    if (mediumProducer != null) {
                        mediumProducer.enable();
                    }
                    if (highProducer != null) {
                        highProducer.enable();
                    }
                    FlightRecorderManager.enableJVMEventsInRecording();
                }
                diagnosticVolume = n2;
                FlightRecorderManager.enableImageRecordingClientEvents((String)"WLDF ", (int)MAX_CHUNK_SIZE_MULTIPLE[diagnosticVolume], (boolean)ENABLE_STACK_TRACES[diagnosticVolume]);
                this.invokeUpdateServerManagedMonitors();
            }
            if (serverLogFileFilterConfig != null && severity != (n = serverLogFileFilterConfig.getSeverityLevel())) {
                severity = n;
                DataGatheringManager.registerLogger();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void invokeUpdateServerManagedMonitors() {
        Object[] objectArray;
        if (this.updateServerManagedMonitors == null) {
            try {
                objectArray = Class.forName("weblogic.diagnostics.instrumentation.InstrumentationManager");
                Method method = objectArray.getDeclaredMethod("getInstrumentationManager", null);
                this.instrumentationManager = method.invoke(null, (Object[])null);
                this.updateServerManagedMonitors = objectArray.getDeclaredMethod("updateServerManagedMonitors", updateArgs);
            }
            catch (Exception exception) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug("Failed to get InstrumentationManager instance", (Throwable)exception);
                }
                return;
            }
        }
        objectArray = new Object[]{new Integer(diagnosticVolume)};
        try {
            if (debugLog.isDebugEnabled() && !DataGatheringManager.isGatheringEnabled() && diagnosticVolume != 0) {
                debugLog.debug("The diagnostic volume is not off but the server managed monitors will be disabled as gathering is not enabled");
            }
            this.updateServerManagedMonitors.invoke(this.instrumentationManager, objectArray);
        }
        catch (Exception exception) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to get InstrumentationManager instance", (Throwable)exception);
            }
            return;
        }
    }

    private boolean invokeIsGatheringExtended() {
        if (this.isGatheringExtended == null) {
            try {
                Class<?> clazz = Class.forName("weblogic.diagnostics.instrumentation.InstrumentationManager");
                Method method = clazz.getDeclaredMethod("getInstrumentationManager", null);
                this.instrumentationManager = method.invoke(null, (Object[])null);
                this.isGatheringExtended = clazz.getDeclaredMethod("isGatheringExtended", null);
            }
            catch (Exception exception) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug("Failed to get InstrumentationManager instance", (Throwable)exception);
                }
                return true;
            }
        }
        try {
            return (Boolean)this.isGatheringExtended.invoke(this.instrumentationManager, (Object[])null);
        }
        catch (Exception exception) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to determine if gathering is extended, assume it is just in case", (Throwable)exception);
            }
            return true;
        }
    }

    public static int convertVolume(String string) {
        if (string == null || string.equalsIgnoreCase("Off")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Low")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Medium")) {
            return 2;
        }
        if (string.equalsIgnoreCase("High")) {
            return 3;
        }
        return 0;
    }

    public static int getDiagnosticVolume() {
        return diagnosticVolume;
    }

    private static void registerLogger() {
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("registerLogger() called, volume = " + diagnosticVolume + " severity = " + severity);
        }
        DataGatheringLogService.deregisterFromServerLogger();
        if (diagnosticVolume != 0) {
            DataGatheringLogService.registerToServerLogger(severity);
        }
    }

    private static void initializeProducers() {
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("initializeProducers() WLDF Diagnostic volume = " + diagnosticVolume);
        }
        try {
            baseProducer = new Producer("WLDF Base Producer", "WLDF Base Producer", "http://www.oracle.com/wls/flightrecorder/base");
        }
        catch (URISyntaxException uRISyntaxException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to create base producer", (Throwable)uRISyntaxException);
            }
            return;
        }
        if (constantPoolsEnabled) {
            baseProducer.createConstantPool(String.class, "GlobalPool", 20480, 0xA00000, true);
        }
        DataGatheringManager.addEvent(baseProducer, "weblogic.diagnostics.flightrecorder.event.GlobalInformationEvent", GlobalInformationEvent.class);
        baseProducer.register();
        try {
            lowProducer = new Producer("WLDF Low Diagnostic Volume Producer", "WLDF Low Diagnostic Volume Producer", "http://www.oracle.com/wls/flightrecorder/low");
        }
        catch (URISyntaxException uRISyntaxException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to create low producer", (Throwable)uRISyntaxException);
            }
            return;
        }
        if (constantPoolsEnabled) {
            lowProducer.createConstantPool(String.class, "GlobalPool", 20480, 0xA00000, true);
            lowProducer.createConstantPool(String.class, "LocalPool", 20480, 0x100000, true);
        }
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ThrottleInformationEvent", ThrottleInformationEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.BaseInstantEvent", BaseInstantEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorBaseEvent", ConnectorBaseEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorEndpointBaseEvent", ConnectorEndpointBaseEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorTransactionBaseEvent", ConnectorTransactionBaseEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.EJBBaseInstantEvent", EJBBaseInstantEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.JDBCBaseInstantEvent", JDBCBaseInstantEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.BaseTimedEvent", BaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.EJBBaseTimedEvent", EJBBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.JDBCBaseTimedEvent", JDBCBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ServletBaseTimedEvent", ServletBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebApplicationBaseTimedEvent", WebApplicationBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.LoggingEvent", LoggingEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.LogRecordEvent", LogRecordEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WLLogRecordEvent", WLLogRecordEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorActivateEndpointEvent", ConnectorActivateEndpointEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorDeactivateEndpointEvent", ConnectorDeactivateEndpointEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorInboundTransactionRollbackEvent", ConnectorInboundTransactionRollbackEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundConnectionErrorEvent", ConnectorOutboundConnectionErrorEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundDestroyConnectionEvent", ConnectorOutboundDestroyConnectionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundRegisterResourceEvent", ConnectorOutboundRegisterResourceEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundReleaseConnectionEvent", ConnectorOutboundReleaseConnectionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundReserveConnectionEvent", ConnectorOutboundReserveConnectionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundTransactionRollbackEvent", ConnectorOutboundTransactionRollbackEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ConnectorOutboundUnregisterResourceEvent", ConnectorOutboundUnregisterResourceEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodInvokeEvent", EJBBusinessMethodInvokeEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPostInvokeEvent", EJBBusinessMethodPostInvokeEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPreInvokeEvent", EJBBusinessMethodPreInvokeEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionRollbackEvent", JDBCConnectionRollbackEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.JDBCStatementExecuteEvent", JDBCStatementExecuteEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionRollbackEvent", JDBCTransactionRollbackEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.ServletInvocationEvent", ServletInvocationEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebApplicationLoadEvent", WebApplicationLoadEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebApplicationUnloadEvent", WebApplicationUnloadEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCBaseTimedEvent", WebservicesJAXRPCBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCClientRequestActionEvent", WebservicesJAXRPCClientRequestActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCClientResponseActionEvent", WebservicesJAXRPCClientResponseActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCDispatchActionEvent", WebservicesJAXRPCDispatchActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCRequestActionEvent", WebservicesJAXRPCRequestActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXRPCResponseActionEvent", WebservicesJAXRPCResponseActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSBaseTimedEvent", WebservicesJAXWSBaseTimedEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSEndPointEvent", WebservicesJAXWSEndPointEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSRequestActionEvent", WebservicesJAXWSRequestActionEvent.class);
        DataGatheringManager.addEvent(lowProducer, "weblogic.diagnostics.flightrecorder.event.WebservicesJAXWSResourceEvent", WebservicesJAXWSResourceEvent.class);
        lowProducer.register();
        if (diagnosticVolume < 1) {
            lowProducer.disable();
        }
        try {
            mediumProducer = new Producer("WLDF Medium Diagnostic Volume Producer", "WLDF Medium Diagnostic Volume Producer", "http://www.oracle.com/wls/flightrecorder/medium");
        }
        catch (URISyntaxException uRISyntaxException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to create medium producer", (Throwable)uRISyntaxException);
            }
            return;
        }
        if (constantPoolsEnabled) {
            mediumProducer.createConstantPool(String.class, "GlobalPool", 20480, 0xA00000, true);
            mediumProducer.createConstantPool(String.class, "LocalPool", 20480, 0x100000, true);
        }
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.EJBHomeCreateEvent", EJBHomeCreateEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.EJBHomeRemoveEvent", EJBHomeRemoveEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.EJBPoolManagerCreateEvent", EJBPoolManagerCreateEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.EJBPoolManagerPostInvokeEvent", EJBPoolManagerPostInvokeEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.EJBPoolManagerPreInvokeEvent", EJBPoolManagerPreInvokeEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionCloseEvent", JDBCConnectionCloseEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionCommitEvent", JDBCConnectionCommitEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionCreateStatementEvent", JDBCConnectionCreateStatementEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionGetVendorConnectionEvent", JDBCConnectionGetVendorConnectionEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionPrepareEvent", JDBCConnectionPrepareEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionReleaseEvent", JDBCConnectionReleaseEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCConnectionReserveEvent", JDBCConnectionReserveEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCDataSourceGetConnectionEvent", JDBCDataSourceGetConnectionEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCDriverConnectEvent", JDBCDriverConnectEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JDBCStatementCreationEvent", JDBCStatementCreationEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletExecuteEvent", ServletExecuteEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletRequestRunEvent", ServletRequestRunEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletRequestDispatchEvent", ServletRequestDispatchEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletRequestActionEvent", ServletRequestActionEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletFilterEvent", ServletFilterEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletAsyncActionEvent", ServletAsyncActionEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletContextExecuteEvent", ServletContextExecuteEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletResponseWriteHeadersEvent", ServletResponseWriteHeadersEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletResponseSendEvent", ServletResponseSendEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletStaleResourceEvent", ServletStaleResourceEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.ServletCheckAccessEvent", ServletCheckAccessEvent.class);
        DataGatheringManager.addEvent(mediumProducer, "weblogic.diagnostics.flightrecorder.event.JMSBEConsumerLogEvent", JMSBEConsumerLogEvent.class);
        mediumProducer.register();
        if (diagnosticVolume < 2) {
            mediumProducer.disable();
        }
        try {
            highProducer = new Producer("WLDF High Diagnostic Volume Producer", "WLDF High Diagnostic Volume Producer", "http://www.oracle.com/wls/flightrecorder/high");
        }
        catch (URISyntaxException uRISyntaxException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to create high producer", (Throwable)uRISyntaxException);
            }
            return;
        }
        if (constantPoolsEnabled) {
            highProducer.createConstantPool(String.class, "GlobalPool", 20480, 0xA00000, true);
            highProducer.createConstantPool(String.class, "LocalPool", 20480, 0x100000, true);
        }
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.EJBDatabaseAccessEvent", EJBDatabaseAccessEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.EJBBusinessMethodPostInvokeCleanupEvent", EJBBusinessMethodPostInvokeCleanupEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.EJBPoolManagerRemoveEvent", EJBPoolManagerRemoveEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.EJBReplicatedSessionManagerEvent", EJBReplicatedSessionManagerEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.EJBTimerManagerEvent", EJBTimerManagerEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionBaseEvent", JDBCTransactionBaseEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionCommitEvent", JDBCTransactionCommitEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionEndEvent", JDBCTransactionEndEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionGetXAResourceEvent", JDBCTransactionGetXAResourceEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionIsSameRMEvent", JDBCTransactionIsSameRMEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionPrepareEvent", JDBCTransactionPrepareEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JDBCTransactionStartEvent", JDBCTransactionStartEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTABaseInstantEvent", JTABaseInstantEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTATransactionCommitEvent", JTATransactionCommitEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTATransactionEndEvent", JTATransactionEndEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTATransactionPreparedEvent", JTATransactionPreparedEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTATransactionPrepareEvent", JTATransactionPrepareEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.JTATransactionStartEvent", JTATransactionStartEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.ServletRequestOverloadEvent", ServletRequestOverloadEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.ServletRequestCancelEvent", ServletRequestCancelEvent.class);
        DataGatheringManager.addEvent(highProducer, "weblogic.diagnostics.flightrecorder.event.ServletContextHandleThrowableEvent", ServletContextHandleThrowableEvent.class);
        highProducer.register();
        if (diagnosticVolume != 3) {
            highProducer.disable();
        }
    }

    private static void addEvent(Producer producer, String string, Class clazz) {
        try {
            if (eventClassNamesInUse != null && eventClassNamesInUse.contains(string)) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug("Adding " + string + " to " + producer.getName());
                }
                EventToken eventToken = producer.addEvent(clazz);
                FlightRecorderManager.addEvent((EventToken)eventToken, (Class)clazz);
            } else if (debugLog.isDebugEnabled()) {
                debugLog.debug(string + " not used by instrumentation config, not registering it");
            }
        }
        catch (InvalidEventDefinitionException invalidEventDefinitionException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to add " + string + " to " + producer.getName(), (Throwable)invalidEventDefinitionException);
            }
            return;
        }
        catch (InvalidValueException invalidValueException) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Failed to add " + string + " to " + producer.getName(), (Throwable)invalidValueException);
            }
            return;
        }
        FlightRecorderEventHelper.getInstance().registerEventClass(string, clazz);
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        updateArgs = new Class[]{Integer.TYPE};
        eventClassNamesInUse = null;
    }

    static class Helper {
        static final long serialVersionUID = -106921881993537274L;
        public static final String _WLDF$INST_VERSION = "9.0.0";
        static /* synthetic */ Class _WLDF$INST_FLD_class;
        public static final DelegatingMonitor _WLDF$INST_FLD_Log_Record_Diagnostic_Volume_Before_Low;
        public static final DelegatingMonitor _WLDF$INST_FLD_Logging_Event_Diagnostic_Volume_Before_Low;
        public static final DelegatingMonitor _WLDF$INST_FLD_WLLog_Record_Diagnostic_Volume_Before_Low;
        public static final JoinPoint _WLDF$INST_JPFLD_0;
        public static final JoinPoint _WLDF$INST_JPFLD_1;
        public static final JoinPoint _WLDF$INST_JPFLD_2;

        Helper() {
        }

        public static void recordLoggingEvent(Object object) {
            if (_WLDF$INST_FLD_Logging_Event_Diagnostic_Volume_Before_Low.isEnabledAndNotDyeFiltered()) {
                Object[] objectArray = null;
                if (_WLDF$INST_FLD_Logging_Event_Diagnostic_Volume_Before_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{object};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Logging_Event_Diagnostic_Volume_Before_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
        }

        public static void recordLogRecord(LogRecord logRecord) {
            if (_WLDF$INST_FLD_Log_Record_Diagnostic_Volume_Before_Low.isEnabledAndNotDyeFiltered()) {
                Object[] objectArray = null;
                if (_WLDF$INST_FLD_Log_Record_Diagnostic_Volume_Before_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{logRecord};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Log_Record_Diagnostic_Volume_Before_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
        }

        public static void recordWLLogRecord(LogRecord logRecord) {
            if (_WLDF$INST_FLD_WLLog_Record_Diagnostic_Volume_Before_Low.isEnabledAndNotDyeFiltered()) {
                Object[] objectArray = null;
                if (_WLDF$INST_FLD_WLLog_Record_Diagnostic_Volume_Before_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{logRecord};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_WLLog_Record_Diagnostic_Volume_Before_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
        }

        static {
            _WLDF$INST_FLD_class = Class.forName("weblogic.diagnostics.instrumentation.gathering.DataGatheringManager$Helper");
            _WLDF$INST_FLD_Log_Record_Diagnostic_Volume_Before_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Log_Record_Diagnostic_Volume_Before_Low");
            _WLDF$INST_FLD_Logging_Event_Diagnostic_Volume_Before_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Logging_Event_Diagnostic_Volume_Before_Low");
            _WLDF$INST_FLD_WLLog_Record_Diagnostic_Volume_Before_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"WLLog_Record_Diagnostic_Volume_Before_Low");
            _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DataGatheringManager.java", (String)"weblogic.diagnostics.instrumentation.gathering.DataGatheringManager$Helper", (String)"recordLoggingEvent", (String)"(Ljava/lang/Object;)V", (int)537, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Logging_Event_Diagnostic_Volume_Before_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo(null, null, (boolean)false, (boolean)false)})}), (boolean)true);
            _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DataGatheringManager.java", (String)"weblogic.diagnostics.instrumentation.gathering.DataGatheringManager$Helper", (String)"recordLogRecord", (String)"(Ljava/util/logging/LogRecord;)V", (int)538, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Log_Record_Diagnostic_Volume_Before_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo(null, null, (boolean)false, (boolean)false)})}), (boolean)true);
            _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DataGatheringManager.java", (String)"weblogic.diagnostics.instrumentation.gathering.DataGatheringManager$Helper", (String)"recordWLLogRecord", (String)"(Ljava/util/logging/LogRecord;)V", (int)539, (Map)InstrumentationSupport.makeMap((String[])new String[]{"WLLog_Record_Diagnostic_Volume_Before_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo(null, null, (boolean)false, (boolean)false)})}), (boolean)true);
        }
    }
}

