/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.gathering;

import com.bea.logging.BaseLogRecord;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.TimedEvent;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.security.auth.Subject;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.flightrecorder.event.BaseInstantEvent;
import weblogic.diagnostics.flightrecorder.event.BaseTimedEvent;
import weblogic.diagnostics.flightrecorder.event.GlobalInformationEvent;
import weblogic.diagnostics.flightrecorder.event.GlobalInformationEventInfo;
import weblogic.diagnostics.flightrecorder.event.GlobalInformationEventInfoHelper;
import weblogic.diagnostics.flightrecorder.event.LogRecordEvent;
import weblogic.diagnostics.flightrecorder.event.LoggingEvent;
import weblogic.diagnostics.flightrecorder.event.ThrottleInformationEvent;
import weblogic.diagnostics.flightrecorder.event.ThrottleInformationEventInfo;
import weblogic.diagnostics.flightrecorder.event.ThrottleInformationEventInfoHelper;
import weblogic.diagnostics.flightrecorder.event.WLLogRecordEvent;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.GatheredArgument;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringManager;
import weblogic.diagnostics.instrumentation.gathering.WLLog4jLogEventClassHelper;
import weblogic.kernel.Kernel;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.spi.WLSUser;
import weblogic.transaction.TxHelper;

public class FlightRecorderEventHelper {
    private static DebugLogger debugLog = DebugLogger.getDebugLogger((String)"DebugDiagnosticDataGathering");
    private static final DebugLogger diagnosticContextDebugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticContext");
    private static FlightRecorderEventHelper SINGLETON = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Map<String, Class> eventClassMap = new HashMap<String, Class>();
    private WLLog4jLogEventClassHelper wlLog4jLogEventClassHelper;

    private FlightRecorderEventHelper() {
        this.initialize();
    }

    private void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FlightRecorderEventHelper getInstance() {
        if (SINGLETON != null) return SINGLETON;
        Class<FlightRecorderEventHelper> clazz = FlightRecorderEventHelper.class;
        synchronized (FlightRecorderEventHelper.class) {
            if (SINGLETON != null) return SINGLETON;
            SINGLETON = new FlightRecorderEventHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLETON;
        }
    }

    public void recordStatelessEvent(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint) {
        int n = DataGatheringManager.getDiagnosticVolume();
        InstantEvent instantEvent = this.getInstantEventInstance(n, diagnosticMonitor);
        if (instantEvent == null) {
            return;
        }
        boolean bl = false;
        if (instantEvent instanceof BaseInstantEvent) {
            bl = true;
            this.populateBaseInstantEvent(diagnosticMonitor, joinPoint, (BaseInstantEvent)instantEvent);
            if (((BaseInstantEvent)instantEvent).getThrottled()) {
                return;
            }
            DiagnosticContextManager.incrementJFREventCounter();
            instantEvent.commit();
            return;
        }
        if (instantEvent instanceof ThrottleInformationEvent) {
            DynamicJoinPoint dynamicJoinPoint;
            Object object;
            if (joinPoint instanceof DynamicJoinPoint && (object = (dynamicJoinPoint = (DynamicJoinPoint)joinPoint).getReturnValue()) != null) {
                ThrottleInformationEventInfoHelper.populateExtensions((Object)object, (ThrottleInformationEventInfo)((ThrottleInformationEvent)instantEvent));
                DiagnosticContextManager.incrementJFREventCounter();
                instantEvent.commit();
            }
            return;
        }
        if (instantEvent instanceof WLLogRecordEvent) {
            WLLogRecordEvent wLLogRecordEvent = (WLLogRecordEvent)instantEvent;
            wLLogRecordEvent.initialize((BaseLogRecord)this.getStaticFirstArg(joinPoint));
            DiagnosticContextManager.incrementJFREventCounter();
            instantEvent.commit();
            return;
        }
        if (instantEvent instanceof LogRecordEvent) {
            LogRecordEvent logRecordEvent = (LogRecordEvent)instantEvent;
            logRecordEvent.initialize((LogRecord)this.getStaticFirstArg(joinPoint));
            DiagnosticContextManager.incrementJFREventCounter();
            instantEvent.commit();
            return;
        }
        if (instantEvent instanceof LoggingEvent) {
            Object object;
            if (this.wlLog4jLogEventClassHelper == null) {
                this.wlLog4jLogEventClassHelper = WLLog4jLogEventClassHelper.getInstance();
            }
            if ((object = this.getStaticFirstArg(joinPoint)) != null && this.wlLog4jLogEventClassHelper.isAvailable(object) && this.wlLog4jLogEventClassHelper.isInstance(object.getClass())) {
                WLLogRecordEvent wLLogRecordEvent = this.wlLog4jLogEventClassHelper.populateWLLogRecordEvent(object);
                DiagnosticContextManager.incrementJFREventCounter();
                wLLogRecordEvent.commit();
                return;
            }
            LoggingEvent loggingEvent = (LoggingEvent)instantEvent;
            loggingEvent.initialize(this.getStaticFirstArg(joinPoint));
            DiagnosticContextManager.incrementJFREventCounter();
            instantEvent.commit();
            return;
        }
        if (instantEvent instanceof GlobalInformationEvent) {
            DynamicJoinPoint dynamicJoinPoint;
            Object object;
            if (joinPoint instanceof DynamicJoinPoint && (object = (dynamicJoinPoint = (DynamicJoinPoint)joinPoint).getReturnValue()) != null) {
                GlobalInformationEventInfoHelper.populateExtensions((Object)object, (GlobalInformationEventInfo)((GlobalInformationEvent)instantEvent));
                DiagnosticContextManager.incrementJFREventCounter();
                instantEvent.commit();
            }
            return;
        }
    }

    private InstantEvent getInstantEventInstance(int n, DiagnosticMonitor diagnosticMonitor) {
        InstantEvent instantEvent = (InstantEvent)this.getEventClassInstance(diagnosticMonitor, InstantEvent.class);
        if (instantEvent == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("No event class found for monitor: " + diagnosticMonitor.getName());
            }
            return instantEvent;
        }
        if (!instantEvent.shouldWrite()) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("Event should not be written: " + instantEvent);
            }
            instantEvent = null;
        }
        return instantEvent;
    }

    private void populateBaseInstantEvent(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint, BaseInstantEvent baseInstantEvent) {
        GatheredArgument[] gatheredArgumentArray;
        Object object;
        baseInstantEvent.className = joinPoint.getClassName();
        baseInstantEvent.methodName = joinPoint.getMethodName();
        if (baseInstantEvent.isECIDEnabled() && (object = DiagnosticContextFactory.findOrCreateDiagnosticContext(true)) != null) {
            baseInstantEvent.ECID = object.getContextId();
        }
        if (diagnosticContextDebugLogger.isDebugEnabled() && !DiagnosticContextManager.isJFRThrottled()) {
            diagnosticContextDebugLogger.debug("Event generated for a throttled request", (Throwable)new Exception());
        }
        if (Kernel.isInitialized()) {
            baseInstantEvent.transactionID = TxHelper.getTransactionId();
            if (DataGatheringManager.getDiagnosticVolume() >= 2) {
                object = Security.getCurrentSubject();
                baseInstantEvent.userID = this.extractCurrentWLSSubject((Subject)object);
                if (baseInstantEvent.userID == null) {
                    baseInstantEvent.userID = SubjectUtils.getUsername((Subject)object);
                }
            }
        }
        object = null;
        if (joinPoint instanceof DynamicJoinPoint) {
            object = (DynamicJoinPoint)joinPoint;
        }
        Object object2 = null;
        if (object != null && object.isReturnGathered()) {
            object2 = object.getReturnValue();
            baseInstantEvent.returnValue = object2 == null ? null : object2.toString();
        }
        GatheredArgument[] gatheredArgumentArray2 = gatheredArgumentArray = object == null ? null : object.getGatheredArguments();
        if (object2 != null || gatheredArgumentArray != null) {
            baseInstantEvent.populateExtensions(object2, gatheredArgumentArray == null ? null : object.getArguments(), (DynamicJoinPoint)object, true);
        }
    }

    public TimedEvent getTimedEvent(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint) {
        int n = DataGatheringManager.getDiagnosticVolume();
        if (n == 0) {
            return null;
        }
        TimedEvent timedEvent = this.getTimedEventInstance(n, diagnosticMonitor);
        if (timedEvent == null) {
            return null;
        }
        if (timedEvent instanceof BaseTimedEvent) {
            this.populateBaseTimedEventBefore(diagnosticMonitor, joinPoint, (BaseTimedEvent)timedEvent);
        }
        return timedEvent;
    }

    private TimedEvent getTimedEventInstance(int n, DiagnosticMonitor diagnosticMonitor) {
        TimedEvent timedEvent = (TimedEvent)this.getEventClassInstance(diagnosticMonitor, TimedEvent.class);
        if (timedEvent == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("No event class found for monitor: " + diagnosticMonitor.getName());
            }
            return timedEvent;
        }
        if (timedEvent != null && !timedEvent.getEventInfo().isEnabled()) {
            timedEvent = null;
        }
        return timedEvent;
    }

    public void recordTimedEvent(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint, TimedEvent timedEvent) {
        BaseTimedEvent baseTimedEvent = (BaseTimedEvent)timedEvent;
        if (joinPoint instanceof DynamicJoinPoint) {
            DynamicJoinPoint dynamicJoinPoint = (DynamicJoinPoint)joinPoint;
            if (baseTimedEvent.getThrottled()) {
                return;
            }
            if (dynamicJoinPoint.isReturnGathered()) {
                Object object = dynamicJoinPoint.getReturnValue();
                String string = baseTimedEvent.returnValue = object == null ? null : object.toString();
                if (object == null) {
                    baseTimedEvent.returnValue = null;
                } else {
                    baseTimedEvent.returnValue = object.toString();
                    baseTimedEvent.populateExtensions(object, null, dynamicJoinPoint, true);
                }
            } else if (baseTimedEvent.requiresProcessingArgsAfter()) {
                baseTimedEvent.populateExtensions(null, null, dynamicJoinPoint, true);
            }
        }
        if (baseTimedEvent.getThrottled()) {
            return;
        }
        DiagnosticContextManager.incrementJFREventCounter();
        timedEvent.commit();
    }

    private void populateBaseTimedEventBefore(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint, BaseTimedEvent baseTimedEvent) {
        Object object;
        baseTimedEvent.className = joinPoint.getClassName();
        baseTimedEvent.methodName = joinPoint.getMethodName();
        if (baseTimedEvent.isECIDEnabled() && (object = DiagnosticContextFactory.findOrCreateDiagnosticContext(true)) != null) {
            baseTimedEvent.ECID = object.getContextId();
        }
        if (diagnosticContextDebugLogger.isDebugEnabled() && !DiagnosticContextManager.isJFRThrottled()) {
            diagnosticContextDebugLogger.debug("Event generated for a throttled request", (Throwable)new Exception());
        }
        if (Kernel.isInitialized()) {
            baseTimedEvent.transactionID = TxHelper.getTransactionId();
            if (DataGatheringManager.getDiagnosticVolume() >= 2) {
                object = Security.getCurrentSubject();
                baseTimedEvent.userID = this.extractCurrentWLSSubject((Subject)object);
                if (baseTimedEvent.userID == null) {
                    baseTimedEvent.userID = SubjectUtils.getUsername((Subject)object);
                }
            }
        }
        if (!(joinPoint instanceof DynamicJoinPoint)) {
            return;
        }
        object = (DynamicJoinPoint)joinPoint;
        GatheredArgument[] gatheredArgumentArray = object.getGatheredArguments();
        if (gatheredArgumentArray == null) {
            return;
        }
        baseTimedEvent.populateExtensions(null, object.getArguments(), (DynamicJoinPoint)object, false);
    }

    private Object getEventClassInstance(DiagnosticMonitor diagnosticMonitor, Class clazz) {
        Object var3_3;
        block3: {
            var3_3 = null;
            Class clazz2 = diagnosticMonitor.getEventClass();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
                return null;
            }
            try {
                var3_3 = clazz.cast(clazz2.newInstance());
            }
            catch (Exception exception) {
                if (!debugLog.isDebugEnabled()) break block3;
                debugLog.debug("getEventClassInstance failed to get instance of " + clazz2, (Throwable)exception);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventClass(String string, Class clazz) {
        if (string == null || clazz == null) {
            return;
        }
        if (this.eventClassMap.containsKey(string)) {
            return;
        }
        Map<String, Class> map = this.eventClassMap;
        synchronized (map) {
            if (!this.eventClassMap.containsKey(string)) {
                this.eventClassMap.put(string, clazz);
            }
        }
    }

    private Object getStaticFirstArg(JoinPoint joinPoint) {
        if (!(joinPoint instanceof DynamicJoinPoint)) {
            return null;
        }
        DynamicJoinPoint dynamicJoinPoint = (DynamicJoinPoint)joinPoint;
        Object[] objectArray = dynamicJoinPoint.getArguments();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0];
    }

    private String extractCurrentWLSSubject(Subject subject) {
        String string = null;
        int n = subject.getPrincipals().size();
        if (n > 0) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof WLSUser)) continue;
                string = principal.getName();
                break;
            }
        } else {
            string = WLSPrincipals.getAnonymousUsername();
        }
        return string;
    }
}

