/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.rtsupport;

import java.util.Map;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DelegatingMonitorControl;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.DynamicJoinPointImpl;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.JoinPointImpl;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfoImpl;
import weblogic.diagnostics.instrumentation.StatelessDiagnosticAction;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfoImpl;
import weblogic.diagnostics.instrumentation.support.DyeInjectionMonitorSupport;
import weblogic.kernel.Kernel;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstrumentationSupportImpl
implements InstrumentationSupport.InstrumentationSupportInterface {
    private static final boolean noSupport1 = Boolean.getBoolean("weblogic.diagnostics.internal.noSupport1");
    private static final boolean noSupport2 = Boolean.getBoolean("weblogic.diagnostics.internal.noSupport2");

    public InstrumentationSupportImpl() throws Exception {
        if (!Kernel.isServer()) {
            throw new Exception("Not running in server, this will cause InstrumentationSupport to be used instead");
        }
    }

    public DiagnosticMonitor getMonitor(Class clazz, String string) {
        DiagnosticMonitorControl diagnosticMonitorControl;
        Object object;
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("InstrumentationSupport.getMonitor: " + string + " for class " + clazz.getName());
            object = new StringBuffer();
            InstrumentationSupportImpl.DisplayClassLoaderAnnotations(clazz.getClassLoader(), (StringBuffer)object);
            InstrumentationDebug.DEBUG_ACTIONS.debug("InstrumentationSupport.getMonitor: classloaders: " + ((StringBuffer)object).toString());
        }
        if ((diagnosticMonitorControl = ((InstrumentationManager)(object = InstrumentationManager.getInstrumentationManager())).getServerManagedMonitorControl(string)) != null) {
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("Returning monitor of type " + string + " monitor=" + diagnosticMonitorControl);
            }
            return diagnosticMonitorControl;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        InstrumentationScope instrumentationScope = ((InstrumentationManager)object).getAssociatedScope(classLoader);
        if (instrumentationScope == null) {
            String string2 = null;
            for (ClassLoader classLoader2 = classLoader; classLoader2 != null && string2 == null; classLoader2 = classLoader2.getParent()) {
                string2 = InstrumentationSupportImpl.getInstrumentationScopeName(classLoader2);
            }
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("InstrumentationSupport.getMonitor: appName=" + string2);
            }
            if (string2 == null) {
                string2 = "_WL_INTERNAL_SERVER_SCOPE";
            }
            if (string2 != null && (instrumentationScope = ((InstrumentationManager)object).findInstrumentationScope(string2)) != null) {
                ((InstrumentationManager)object).associateClassloaderWithScope(classLoader, instrumentationScope);
            }
        }
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("InstrumentationSupport.getMonitor: scope=" + (instrumentationScope != null ? instrumentationScope.getName() : "null"));
        }
        if (instrumentationScope != null) {
            diagnosticMonitorControl = instrumentationScope.findDiagnosticMonitorControl(string);
        }
        if (diagnosticMonitorControl == null) {
            diagnosticMonitorControl = ((InstrumentationManager)object).getServerMonitor(string);
        }
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("InstrumentationSupport.getMonitor: monitor=" + diagnosticMonitorControl);
        }
        if (diagnosticMonitorControl == null) {
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("Returning orphan monitor of type " + string);
            }
            diagnosticMonitorControl = new DelegatingMonitorControl(string, string);
        }
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("Returning monitor of type " + string + " monitor=" + diagnosticMonitorControl);
        }
        return diagnosticMonitorControl;
    }

    public static void DisplayClassLoaderAnnotations(ClassLoader classLoader, StringBuffer stringBuffer) {
        int n = 0;
        while (classLoader != null) {
            stringBuffer.append("\n    " + n + ": " + classLoader.getClass().getName() + "@" + classLoader.hashCode());
            if (classLoader instanceof GenericClassLoader) {
                GenericClassLoader genericClassLoader = (GenericClassLoader)classLoader;
                Annotation annotation = genericClassLoader.getAnnotation();
                stringBuffer.append(" annotation=");
                stringBuffer.append(annotation != null ? annotation.toString() : "null");
            }
            ++n;
            classLoader = classLoader.getParent();
        }
    }

    public static String getInstrumentationScopeName(ClassLoader classLoader) {
        String string = null;
        while (classLoader != null && string == null) {
            GenericClassLoader genericClassLoader;
            Annotation annotation;
            if (classLoader instanceof GenericClassLoader && (annotation = (genericClassLoader = (GenericClassLoader)classLoader).getAnnotation()) != null) {
                string = annotation.getApplicationName();
            }
            classLoader = classLoader.getParent();
        }
        return string;
    }

    public static boolean dyeMatches(DiagnosticMonitor diagnosticMonitor) {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return InstrumentationSupportImpl.dyeMatches(diagnosticMonitor, diagnosticContext);
    }

    public static boolean dyeMatches(DiagnosticMonitor diagnosticMonitor, DiagnosticContext diagnosticContext) {
        if (diagnosticContext == null) {
            return true;
        }
        if (diagnosticMonitor.isDyeFilteringEnabled()) {
            long l = diagnosticMonitor.getDyeMask();
            if (diagnosticContext != null && (l & diagnosticContext.getDyeVector()) != l) {
                return false;
            }
        } else if (DyeInjectionMonitorSupport.isThrottlingEnabled()) {
            return (diagnosticContext.getDyeVector() & 0x100000000L) != 0L;
        }
        return true;
    }

    public void process(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray) {
        int n;
        if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) {
            return;
        }
        DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
        int n2 = n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("Executing process() for " + diagnosticMonitorControl.getType() + " with " + n + " actions");
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        for (int i = 0; i < n; ++i) {
            try {
                StatelessDiagnosticAction statelessDiagnosticAction = (StatelessDiagnosticAction)diagnosticActionArray[i];
                statelessDiagnosticAction.process(joinPoint);
                continue;
            }
            catch (Throwable throwable) {
                if (!InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_ACTIONS.debug("Unexpected exception in process,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        int n;
        if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) {
            return;
        }
        DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
        int n2 = n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("Executing preProcess() for " + diagnosticMonitorControl.getType() + " with " + n + " actions");
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        for (int i = 0; i < n; ++i) {
            try {
                AroundDiagnosticAction aroundDiagnosticAction = (AroundDiagnosticAction)diagnosticActionArray[i];
                aroundDiagnosticAction.preProcess(joinPoint, diagnosticActionStateArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                if (!InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_ACTIONS.debug("Unexpected exception in preProcess,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        int n;
        if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) {
            return;
        }
        DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
        int n2 = n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("Executing postProcess() for " + diagnosticMonitorControl.getType() + " with " + n + " actions");
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        for (int i = 0; i < n; ++i) {
            try {
                AroundDiagnosticAction aroundDiagnosticAction = (AroundDiagnosticAction)diagnosticActionArray[i];
                aroundDiagnosticAction.postProcess(joinPoint, diagnosticActionStateArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                if (!InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_ACTIONS.debug("Unexpected exception in postProcess,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    public DynamicJoinPoint createDynamicJoinPoint(JoinPoint joinPoint, Object[] objectArray, Object object) {
        if (joinPoint instanceof DynamicJoinPointImpl) {
            DynamicJoinPointImpl dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            if (objectArray != null) {
                dynamicJoinPointImpl.setArguments(objectArray);
            }
            dynamicJoinPointImpl.setReturnValue(object);
            return dynamicJoinPointImpl;
        }
        return new DynamicJoinPointImpl(joinPoint, objectArray, object);
    }

    public JoinPoint createJoinPoint(Class clazz, String string, String string2, String string3, String string4, int n, Map<String, PointcutHandlingInfo> map, boolean bl) {
        return new JoinPointImpl(clazz, string, string2, string3, string4, n, map, bl);
    }

    public PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo valueHandlingInfo, ValueHandlingInfo valueHandlingInfo2, ValueHandlingInfo[] valueHandlingInfoArray) {
        return new PointcutHandlingInfoImpl(valueHandlingInfo, valueHandlingInfo2, valueHandlingInfoArray);
    }

    public ValueHandlingInfo createValueHandlingInfo(String string, String string2, boolean bl, boolean bl2) {
        return new ValueHandlingInfoImpl(string, string2, bl, bl2);
    }

    public Map<String, PointcutHandlingInfo> makeMap(String[] stringArray, PointcutHandlingInfo[] pointcutHandlingInfoArray) {
        return PointcutHandlingInfoImpl.makeMap((String[])stringArray, (PointcutHandlingInfo[])pointcutHandlingInfoArray);
    }
}

