/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.rtsupport;

import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.DynamicJoinPointImpl;
import weblogic.diagnostics.instrumentation.InstrumentationSupportBase;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.JoinPointImpl;
import weblogic.diagnostics.instrumentation.LocalHolder;
import weblogic.diagnostics.instrumentation.MonitorLocalHolder;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfoImpl;
import weblogic.diagnostics.instrumentation.StatelessDiagnosticAction;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfoImpl;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.spring.monitoring.actions.AbstractApplicationContextRefreshAction;
import weblogic.spring.monitoring.actions.AbstractBeanFactoryCreateBeanAction;
import weblogic.spring.monitoring.actions.AbstractBeanFactoryGetBeanAction;
import weblogic.spring.monitoring.actions.AbstractBeanFactoryRegisterScopeAction;
import weblogic.spring.monitoring.actions.AbstractPlatformTransactionManagerCommitAction;
import weblogic.spring.monitoring.actions.AbstractPlatformTransactionManagerResumeAction;
import weblogic.spring.monitoring.actions.AbstractPlatformTransactionManagerRollbackAction;
import weblogic.spring.monitoring.actions.AbstractPlatformTransactionManagerSuspendAction;
import weblogic.spring.monitoring.actions.ApplicationContextObtainFreshBeanFactoryAction;
import weblogic.spring.monitoring.actions.DefaultListableBeanFactoryGetBeanNamesForTypeAction;
import weblogic.spring.monitoring.actions.DefaultListableBeanFactoryGetBeansOfTypeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringInstSupportImpl
extends InstrumentationSupportBase {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugSpringStatistics");
    private static boolean legacyUnknownSpringMessageIssued = false;
    private static boolean legacySpringMessageIssued = false;
    private static final ValueHandlingInfo LEGACY_SPRING_INFO = new ValueHandlingInfoImpl(null, null, false, false);
    private static Map<String, SpringDelegatingMonitor> monitorMap = new HashMap<String, SpringDelegatingMonitor>();

    public static synchronized DiagnosticMonitor getMonitor(Class clazz, String string) {
        SpringDelegatingMonitor springDelegatingMonitor;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringInstSupportImpl.getMonitor: clz=" + clazz.getName() + " type=" + string);
        }
        if ((springDelegatingMonitor = monitorMap.get(string)) == null) {
            AbstractDiagnosticAction abstractDiagnosticAction;
            springDelegatingMonitor = new SpringDelegatingMonitor(string);
            if ("Spring_Around_Internal_Application_Context_Obtain_Fresh_Bean_Factory".equals(string)) {
                abstractDiagnosticAction = new ApplicationContextObtainFreshBeanFactoryAction();
            } else if ("Spring_Around_Internal_Abstract_Application_Context_Refresh".equals(string)) {
                abstractDiagnosticAction = new AbstractApplicationContextRefreshAction();
            } else if ("Spring_Around_Internal_Abstract_Bean_Factory_Create_Bean".equals(string)) {
                abstractDiagnosticAction = new AbstractBeanFactoryCreateBeanAction();
            } else if ("Spring_Around_Internal_Abstract_Bean_Factory_Get_Bean".equals(string)) {
                abstractDiagnosticAction = new AbstractBeanFactoryGetBeanAction();
            } else if ("Spring_Around_Internal_Abstract_Bean_Factory_Register_Scope".equals(string)) {
                abstractDiagnosticAction = new AbstractBeanFactoryRegisterScopeAction();
            } else if ("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Commit".equals(string)) {
                abstractDiagnosticAction = new AbstractPlatformTransactionManagerCommitAction();
            } else if ("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Resume".equals(string)) {
                abstractDiagnosticAction = new AbstractPlatformTransactionManagerResumeAction();
            } else if ("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Rollback".equals(string)) {
                abstractDiagnosticAction = new AbstractPlatformTransactionManagerRollbackAction();
            } else if ("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Suspend".equals(string)) {
                abstractDiagnosticAction = new AbstractPlatformTransactionManagerSuspendAction();
            } else if ("Spring_Around_Internal_Default_Listable_Bean_Factory_Get_Bean_Names_For_Type".equals(string)) {
                abstractDiagnosticAction = new DefaultListableBeanFactoryGetBeanNamesForTypeAction();
            } else if ("Spring_Around_Internal_Default_Listable_Bean_Factory_Get_Beans_Of_Type".equals(string)) {
                abstractDiagnosticAction = new DefaultListableBeanFactoryGetBeansOfTypeAction();
            } else {
                return null;
            }
            abstractDiagnosticAction.setDiagnosticMonitor((DiagnosticMonitor)springDelegatingMonitor);
            DiagnosticAction[] diagnosticActionArray = new DiagnosticAction[]{abstractDiagnosticAction};
            springDelegatingMonitor.setActions(diagnosticActionArray);
            monitorMap.put(string, springDelegatingMonitor);
        }
        return springDelegatingMonitor;
    }

    public static JoinPoint createJoinPoint(Class clazz, String string, String string2, String string3, String string4, int n) {
        Map<String, PointcutHandlingInfo> map = null;
        boolean bl = false;
        if (string3 != null) {
            if (string3.equals("obtainFreshBeanFactory")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Application_Context_Obtain_Fresh_Bean_Factory", true, true, 0);
            } else if (string3.equals("refresh")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Application_Context_Refresh", false, true, 0);
            } else if (string3.equals("createBean")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Bean_Factory_Create_Bean", false, true, 0);
            } else if (string3.equals("getBean")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Bean_Factory_Get_Bean", false, true, 0);
            } else if (string3.equals("registerScope")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Bean_Factory_Register_Scope", false, true, 2);
            } else if (string3.equals("commit")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Commit", false, true, 0);
            } else if (string3.equals("resume")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Resume", false, true, 0);
            } else if (string3.equals("rollback")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Rollback", false, true, 0);
            } else if (string3.equals("suspend")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Abstract_Platform_Transaction_Manager_Suspend", false, true, 0);
            } else if (string3.equals("getBeanNamesForType")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Default_Listable_Bean_Factory_Get_Bean_Names_For_Type", false, true, 0);
            } else if (string3.equals("getBeansOfType")) {
                map = SpringInstSupportImpl.createSpringLegacyMap("Spring_Around_Internal_Default_Listable_Bean_Factory_Get_Beans_Of_Type", false, true, 0);
            } else if (!legacyUnknownSpringMessageIssued) {
                DiagnosticsLogger.logLegacySpringInstrumentationUnknownMethod((String)string3);
                legacyUnknownSpringMessageIssued = true;
            }
        }
        if (map != null && !legacySpringMessageIssued) {
            DiagnosticsLogger.logLegacySpringInstrumentationCalled();
            legacySpringMessageIssued = true;
        }
        return new JoinPointImpl(clazz, string, string2, string3, string4, n, map, bl);
    }

    private static Map<String, PointcutHandlingInfo> createSpringLegacyMap(String string, boolean bl, boolean bl2, int n) {
        ValueHandlingInfo valueHandlingInfo = bl ? LEGACY_SPRING_INFO : null;
        ValueHandlingInfo valueHandlingInfo2 = bl2 ? LEGACY_SPRING_INFO : null;
        ValueHandlingInfo[] valueHandlingInfoArray = null;
        if (n > 0) {
            valueHandlingInfoArray = new ValueHandlingInfo[n];
            for (int i = 0; i < n; ++i) {
                valueHandlingInfoArray[i] = LEGACY_SPRING_INFO;
            }
        }
        PointcutHandlingInfoImpl pointcutHandlingInfoImpl = new PointcutHandlingInfoImpl(valueHandlingInfo2, valueHandlingInfo, valueHandlingInfoArray);
        HashMap<String, PointcutHandlingInfo> hashMap = new HashMap<String, PointcutHandlingInfo>();
        hashMap.put(string, (PointcutHandlingInfo)pointcutHandlingInfoImpl);
        return hashMap;
    }

    public static JoinPoint createJoinPoint(Class clazz, String string, String string2, String string3, String string4, int n, Map<String, PointcutHandlingInfo> map, boolean bl) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.createJoinPoint");
        }
        return new JoinPointImpl(clazz, string, string2, string3, string4, n, map, bl);
    }

    public static DynamicJoinPoint createDynamicJoinPoint(JoinPoint joinPoint, Object[] objectArray, Object object) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.createDynamicJoinPoint");
        }
        return new DynamicJoinPointImpl(joinPoint, objectArray, object);
    }

    public static void createDynamicJoinPoint(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        monitorLocalHolder.djp = SpringInstSupportImpl.createDynamicJoinPoint((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.captureArgs ? localHolder.args : null, localHolder.ret);
    }

    public static PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo valueHandlingInfo, ValueHandlingInfo valueHandlingInfo2, ValueHandlingInfo[] valueHandlingInfoArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.createPointcutHandlingInfo");
        }
        return new PointcutHandlingInfoImpl(valueHandlingInfo, valueHandlingInfo2, valueHandlingInfoArray);
    }

    public static ValueHandlingInfo createValueHandlingInfo(String string, String string2, boolean bl, boolean bl2) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.createValueHandlingInfo");
        }
        return new ValueHandlingInfoImpl(string, string2, bl, bl2);
    }

    public static Map<String, PointcutHandlingInfo> makeMap(String[] stringArray, PointcutHandlingInfo[] pointcutHandlingInfoArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.makeMap");
        }
        return PointcutHandlingInfoImpl.makeMap((String[])stringArray, (PointcutHandlingInfo[])pointcutHandlingInfoArray);
    }

    public static void preProcess(LocalHolder localHolder) {
        SpringInstSupportImpl.applyActionStates((LocalHolder)localHolder);
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        SpringInstSupportImpl.preProcess((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.monitor, monitorLocalHolder.actions, monitorLocalHolder.states);
    }

    public static void preProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.preProcess: mon=" + diagnosticMonitor.getName());
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        int n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        for (int i = 0; i < n; ++i) {
            try {
                AroundDiagnosticAction aroundDiagnosticAction = (AroundDiagnosticAction)diagnosticActionArray[i];
                aroundDiagnosticAction.preProcess(joinPoint, diagnosticActionStateArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                UnexpectedExceptionHandler.handle("Unexpected exception in preProcess,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    public static void postProcess(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        SpringInstSupportImpl.postProcess((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.monitor, monitorLocalHolder.actions, monitorLocalHolder.states);
    }

    public static void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray, Throwable throwable) {
        SpringInstSupportImpl.postProcess(joinPoint, diagnosticMonitor, diagnosticActionArray, diagnosticActionStateArray);
    }

    public static void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.postProcess: mon=" + diagnosticMonitor.getName());
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        int n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        for (int i = 0; i < n; ++i) {
            try {
                AroundDiagnosticAction aroundDiagnosticAction = (AroundDiagnosticAction)diagnosticActionArray[i];
                aroundDiagnosticAction.postProcess(joinPoint, diagnosticActionStateArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Unexpected exception in postProcess,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    public static void process(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, Throwable throwable) {
        SpringInstSupportImpl.process(joinPoint, diagnosticMonitor, diagnosticActionArray);
    }

    public static void process(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        SpringInstSupportImpl.process((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.monitor, monitorLocalHolder.actions);
    }

    public static void process(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Executing SpringInstSupportImpl.process: mon=" + diagnosticMonitor.getName());
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = null;
        if (joinPoint instanceof DynamicJoinPointImpl) {
            dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
            dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
        }
        int n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
        for (int i = 0; i < n; ++i) {
            try {
                StatelessDiagnosticAction statelessDiagnosticAction = (StatelessDiagnosticAction)diagnosticActionArray[i];
                statelessDiagnosticAction.process(joinPoint);
                continue;
            }
            catch (Throwable throwable) {
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Unexpected exception in process,  executing action " + i, throwable);
            }
        }
        if (dynamicJoinPointImpl != null) {
            dynamicJoinPointImpl.setMonitorType(null);
        }
    }

    private static class SpringDelegatingMonitor
    implements DelegatingMonitor {
        private String type;
        private DiagnosticAction[] actions;

        SpringDelegatingMonitor(String string) {
            this.type = string;
        }

        public String getAttribute(String string) {
            return null;
        }

        public String[] getAttributeNames() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public boolean isArgumentsCaptureNeeded() {
            return true;
        }

        public boolean isComponentScopeAllowed() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isEnabledAndNotDyeFiltered() {
            return true;
        }

        public boolean isServerScopeAllowed() {
            return true;
        }

        public void setAttribute(String string, String string2) {
        }

        public void setDescription(String string) {
        }

        public void setEnabled(boolean bl) {
        }

        public void setName(String string) {
        }

        public long getDyeMask() {
            return 0L;
        }

        public boolean isDyeFilteringEnabled() {
            return false;
        }

        public void setDyeFilteringEnabled(boolean bl) {
        }

        public void setDyeMask(long l) {
        }

        public void addAction(DiagnosticAction diagnosticAction) {
        }

        public void setActions(DiagnosticAction[] diagnosticActionArray) {
            this.actions = diagnosticActionArray;
        }

        public DiagnosticAction[] getActions() {
            return this.actions;
        }

        public String[] getCompatibleActionTypes() {
            return null;
        }

        public void removeAction(DiagnosticAction diagnosticAction) {
        }

        public String[] getIncludes() {
            return null;
        }

        public void setIncludes(String[] stringArray) {
        }

        public String[] getExcludes() {
            return null;
        }

        public void setExcludes(String[] stringArray) {
        }

        public String getDiagnosticVolume() {
            return "Off";
        }

        public boolean isServerManaged() {
            return false;
        }

        public void setDiagnosticVolume(String string) {
        }

        public void setServerManaged(boolean bl) {
        }

        public String getEventClassName() {
            return null;
        }

        public Class getEventClass() {
            return null;
        }

        public void setEventClassName(String string) {
        }
    }
}

