/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.support;

import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextConstants;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.InstrumentationConstants;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationLibrary;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.InboundRequest;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.ServletRequestImpl;

public final class DyeInjectionMonitorSupport
implements DiagnosticContextConstants,
InstrumentationConstants {
    private static DiagnosticMonitorControl dyeInjectionMonitor = null;
    private static boolean computeDyes;
    private static final long ADDR_USER_MASK = 255L;
    private static final String[] dyeInjectionPointcutClasses;
    private static final String ENABLE_WLDF_DYE_INJECTION_METHOD_NAME = "enableWLDFDyeInjection";
    private static final String ENABLE_DYE_INJECTION_METHOD_NAME = "enableDyeInjection";
    private static long throttleInterval;
    private static long throttleRate;
    private static long reqNumber;
    private static long lastReqTime;
    private static boolean throttlingEnabled;
    private static String propADDR1;
    private static String propADDR2;
    private static String propADDR3;
    private static String propADDR4;
    private static boolean checkADDR;
    private static String propUSER1;
    private static String propUSER2;
    private static String propUSER3;
    private static String propUSER4;
    private static boolean checkUSER;
    private static String propCOOKIE1;
    private static String propCOOKIE2;
    private static String propCOOKIE3;
    private static String propCOOKIE4;
    private static boolean checkCOOKIE;

    public static synchronized void setDyeInjectionMonitor(DiagnosticMonitorControl diagnosticMonitorControl) {
        dyeInjectionMonitor = diagnosticMonitorControl;
        DyeInjectionMonitorSupport.captureProperties(diagnosticMonitorControl);
        Class[] classArray = new Class[]{Boolean.class};
        Object[] objectArray = new Object[]{new Boolean(diagnosticMonitorControl != null)};
        for (int i = 0; i < dyeInjectionPointcutClasses.length; ++i) {
            try {
                Class<?> clazz = Class.forName(dyeInjectionPointcutClasses[i]);
                Method method = clazz.getMethod(ENABLE_WLDF_DYE_INJECTION_METHOD_NAME, classArray);
                method.invoke(null, objectArray);
                continue;
            }
            catch (Throwable throwable) {
                UnexpectedExceptionHandler.handle("Unexpected exception in setDyeInjectionMonitor", throwable);
            }
        }
        classArray[0] = DiagnosticMonitor.class;
        objectArray[0] = diagnosticMonitorControl;
        String[] stringArray = InstrumentationLibrary.getInstrumentationLibrary().getInstrumentationEngineConfiguration().getEntryClasses();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            try {
                Class<?> clazz = Class.forName(stringArray[i]);
                Method method = clazz.getMethod(ENABLE_DYE_INJECTION_METHOD_NAME, classArray);
                method.invoke(null, objectArray);
                continue;
            }
            catch (Throwable throwable) {
                UnexpectedExceptionHandler.handle("Unexpected exception in setDyeInjectionMonitor", throwable);
            }
        }
    }

    public static boolean isThrottlingEnabled() {
        return throttlingEnabled;
    }

    private static void captureProperties(DiagnosticMonitorControl diagnosticMonitorControl) {
        computeDyes = diagnosticMonitorControl != null ? diagnosticMonitorControl.isEnabled() : false;
        throttleInterval = DyeInjectionMonitorSupport.getLongAttribute(diagnosticMonitorControl, "THROTTLE_INTERVAL");
        throttleRate = DyeInjectionMonitorSupport.getLongAttribute(diagnosticMonitorControl, "THROTTLE_RATE");
        throttlingEnabled = throttleInterval > 0L || throttleRate > 0L;
        propADDR1 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "ADDR1");
        propADDR2 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "ADDR2");
        propADDR3 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "ADDR3");
        propADDR4 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "ADDR4");
        checkADDR = propADDR1 != null || propADDR2 != null || propADDR3 != null || propADDR4 != null;
        propUSER1 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "USER1");
        propUSER2 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "USER2");
        propUSER3 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "USER3");
        propUSER4 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "USER4");
        checkUSER = propUSER1 != null || propUSER2 != null || propUSER3 != null || propUSER4 != null;
        propCOOKIE1 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "COOKIE1");
        propCOOKIE2 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "COOKIE2");
        propCOOKIE3 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "COOKIE3");
        propCOOKIE4 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, "COOKIE4");
        checkCOOKIE = propCOOKIE1 != null || propCOOKIE2 != null || propCOOKIE3 != null || propCOOKIE4 != null;
    }

    private static long getLongAttribute(DiagnosticMonitorControl diagnosticMonitorControl, String string) {
        long l = -1L;
        try {
            String string2 = DyeInjectionMonitorSupport.getAttribute(diagnosticMonitorControl, string);
            l = Long.parseLong(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l <= 0L) {
            l = -1L;
        }
        return l;
    }

    private static String getAttribute(DiagnosticMonitorControl diagnosticMonitorControl, String string) {
        String string2;
        String string3 = string2 = diagnosticMonitorControl != null ? diagnosticMonitorControl.getAttribute(string) : null;
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private static long computeThrottleDye() {
        if (throttleInterval <= 0L && throttleRate <= 0L) {
            return 0x100000000L;
        }
        long l = System.currentTimeMillis();
        long l2 = 0L;
        if (throttleInterval > 0L && l - lastReqTime >= throttleInterval) {
            l2 = 0x100000000L;
        }
        if (throttleRate > 0L && reqNumber >= throttleRate) {
            l2 = 0x100000000L;
        }
        ++reqNumber;
        if (l2 != 0L) {
            reqNumber = 0L;
            lastReqTime = l;
        }
        return l2;
    }

    private static void dyeWebAppRequest(Object object, DiagnosticMonitorControl diagnosticMonitorControl) {
        try {
            Object object2;
            DiagnosticContext diagnosticContext = DyeInjectionMonitorSupport.getDiagnosticContext();
            if (diagnosticContext == null) {
                return;
            }
            if (!computeDyes) {
                return;
            }
            ServletRequestImpl servletRequestImpl = (ServletRequestImpl)((Object)object);
            long l = diagnosticContext.getDyeVector();
            l |= DyeInjectionMonitorSupport.computeThrottleDye();
            l |= 0x200000L;
            if (servletRequestImpl.isSecure()) {
                l |= 0x4000000L;
            }
            if (checkADDR) {
                object2 = servletRequestImpl.getRemoteAddr();
                l |= DyeInjectionMonitorSupport.computeAddressDye((String)object2);
            }
            if (checkUSER) {
                object2 = servletRequestImpl.getUserPrincipal();
                String string = object2 != null ? object2.getName() : null;
                l |= DyeInjectionMonitorSupport.computeUsernameDye(string);
            }
            if (checkCOOKIE) {
                l |= DyeInjectionMonitorSupport.computeCookiesDye(servletRequestImpl.getCookies());
            }
            DyeInjectionMonitorSupport.setDye(diagnosticContext, l);
        }
        catch (Throwable throwable) {
            UnexpectedExceptionHandler.handle("Unexpected exception in DyeInjectionMonitorSupport", throwable);
        }
    }

    public static void dyeWebAppRequest(Object object) {
        if (dyeInjectionMonitor != null) {
            DyeInjectionMonitorSupport.dyeWebAppRequest(object, dyeInjectionMonitor);
        }
    }

    private static void dyeRMIRequest(Object object, DiagnosticMonitorControl diagnosticMonitorControl) {
        try {
            String string;
            DiagnosticContext diagnosticContext = DyeInjectionMonitorSupport.getDiagnosticContext();
            if (diagnosticContext == null) {
                return;
            }
            if (!computeDyes) {
                return;
            }
            InboundRequest inboundRequest = (InboundRequest)object;
            long l = diagnosticContext.getDyeVector();
            l |= DyeInjectionMonitorSupport.computeThrottleDye();
            Channel channel = inboundRequest.getEndPoint().getRemoteChannel();
            if (checkADDR) {
                string = channel.getInetAddress().getHostAddress();
                l |= DyeInjectionMonitorSupport.computeAddressDye(string);
            }
            if (checkUSER && (string = (AuthenticatedSubject)inboundRequest.getSubject()) != null) {
                String string2 = SubjectUtils.getUsername((AuthenticatedSubject)string);
                l |= DyeInjectionMonitorSupport.computeUsernameDye(string2);
            }
            string = channel.getProtocolPrefix();
            l |= DyeInjectionMonitorSupport.computeProtocolDye(string);
            DyeInjectionMonitorSupport.setDye(diagnosticContext, l |= 0x400000L);
        }
        catch (Throwable throwable) {
            UnexpectedExceptionHandler.handle("Unexpected exception in DyeInjectionMonitorSupport", throwable);
        }
    }

    public static void dyeRMIRequest(Object object) {
        if (dyeInjectionMonitor != null) {
            DyeInjectionMonitorSupport.dyeRMIRequest(object, dyeInjectionMonitor);
        }
    }

    private static void setDye(DiagnosticContext diagnosticContext, long l) {
        diagnosticContext.setDyeVector(l |= diagnosticContext.getDyeVector());
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("dyeWebAppRequest: setting request dye to: " + l);
        }
    }

    private static long computeAddressDye(String string) {
        long l = 0L;
        if (string != null) {
            if (string.equals(propADDR1)) {
                l |= 1L;
            }
            if (string.equals(propADDR2)) {
                l |= 2L;
            }
            if (string.equals(propADDR3)) {
                l |= 4L;
            }
            if (string.equals(propADDR4)) {
                l |= 8L;
            }
        }
        return l;
    }

    private static long computeUsernameDye(String string) {
        long l = 0L;
        if (string != null) {
            if (string.equals(propUSER1)) {
                l |= 0x10L;
            }
            if (string.equals(propUSER2)) {
                l |= 0x20L;
            }
            if (string.equals(propUSER3)) {
                l |= 0x40L;
            }
            if (string.equals(propUSER4)) {
                l |= 0x80L;
            }
        }
        return l;
    }

    private static long computeCookiesDye(Cookie[] cookieArray) {
        int n = cookieArray != null ? cookieArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Cookie cookie = cookieArray[i];
            if (!cookie.getName().equals("weblogic.diagnostics.dye")) continue;
            String string = cookie.getValue();
            long l = 0L;
            if (string != null) {
                if (string.equals(propCOOKIE1)) {
                    l |= 0x100L;
                }
                if (string.equals(propCOOKIE2)) {
                    l |= 0x200L;
                }
                if (string.equals(propCOOKIE3)) {
                    l |= 0x400L;
                }
                if (string.equals(propCOOKIE4)) {
                    l |= 0x800L;
                }
            }
            return l;
        }
        return 0L;
    }

    private static long computeProtocolDye(String string) {
        if ((string = string.toLowerCase()).equals("t3")) {
            return 0x100000L;
        }
        if (string.equals("t3s")) {
            return 0x4100000L;
        }
        if (string.equals("http")) {
            return 0x200000L;
        }
        if (string.equals("https")) {
            return 0x4200000L;
        }
        if (string.equals("iiop")) {
            return 0x1000000L;
        }
        if (string.equals("iiops")) {
            return 0x5000000L;
        }
        if (string.equals("jrmp")) {
            return 0x2000000L;
        }
        return 0L;
    }

    private static DiagnosticContext getDiagnosticContext() {
        return DiagnosticContextFactory.findOrCreateDiagnosticContext(true);
    }

    public static void setDyes(long l, long l2, String string, String string2) {
        DiagnosticContext diagnosticContext = DyeInjectionMonitorSupport.getDiagnosticContext();
        l |= DyeInjectionMonitorSupport.computeUsernameDye(string2);
        l |= DyeInjectionMonitorSupport.computeAddressDye(string);
        long l3 = diagnosticContext.getDyeVector();
        l = l3 & ((l2 |= 0xFFL) ^ 0xFFFFFFFFFFFFFFFFL) | l & l2;
        diagnosticContext.setDyeVector(l);
    }

    static {
        dyeInjectionPointcutClasses = new String[]{"weblogic.rmi.internal.BasicServerRef", "weblogic.servlet.internal.WebAppServletContext"};
        throttleInterval = -1L;
        throttleRate = -1L;
    }
}

