/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.support;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpSession;
import weblogic.common.internal.PassivationUtils;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextConstants;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DynamicJoinPointImpl;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.InstrumentationConstants;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.LocalHolder;
import weblogic.diagnostics.instrumentation.MonitorLocalHolder;
import weblogic.diagnostics.instrumentation.rtsupport.InstrumentationSupportImpl;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;

public final class HttpSessionDebugMonitorSupport
implements DiagnosticContextConstants,
InstrumentationConstants {
    public static void preProcess(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        HttpSessionDebugMonitorSupport.preProcess((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.monitor);
    }

    public static void preProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor) {
        block8: {
            DiagnosticContext diagnosticContext;
            if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) {
                return;
            }
            DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("HttpSessionDebugMonitorSupport.preProcess for " + diagnosticMonitorControl.getType());
            }
            if (!InstrumentationSupportImpl.dyeMatches(diagnosticMonitorControl, diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext())) {
                return;
            }
            try {
                Object object;
                if (!(joinPoint instanceof DynamicJoinPointImpl)) break block8;
                DynamicJoinPointImpl dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
                dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
                Object[] objectArray = dynamicJoinPointImpl.getArguments();
                dynamicJoinPointImpl.setMonitorType(null);
                Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
                if (!(object instanceof HttpSession)) break block8;
                int n = -1;
                try {
                    if (object instanceof Serializable) {
                        n = PassivationUtils.sizeOf(object);
                    }
                }
                catch (IOException iOException) {
                    n = -2;
                }
                InstrumentationEvent instrumentationEvent = HttpSessionDebugMonitorSupport.createInstrumentationEvent(joinPoint, diagnosticMonitorControl, "SessionSize-Before", n);
                EventQueue.getInstance().enqueue(instrumentationEvent);
            }
            catch (Throwable throwable) {
                UnexpectedExceptionHandler.handle("Unexpected exception in HttpSessionDebugMonitorSupport.preProcess", throwable);
            }
        }
    }

    public static void postProcess(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        HttpSessionDebugMonitorSupport.postProcess((JoinPoint)(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp), monitorLocalHolder.monitor);
    }

    public static void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor) {
        block10: {
            DiagnosticContext diagnosticContext;
            if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) {
                return;
            }
            DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)diagnosticMonitor;
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("HttpSessionDebugMonitorSupport.postProcess for " + diagnosticMonitorControl.getType());
            }
            if (!InstrumentationSupportImpl.dyeMatches(diagnosticMonitorControl, diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext())) {
                return;
            }
            try {
                if (!(joinPoint instanceof DynamicJoinPointImpl)) break block10;
                DynamicJoinPointImpl dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
                dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
                Object[] objectArray = dynamicJoinPointImpl.getArguments();
                Object object = dynamicJoinPointImpl.getReturnValue();
                dynamicJoinPointImpl.setMonitorType(null);
                joinPoint = dynamicJoinPointImpl.getDelegate();
                if (!(object instanceof HttpSession)) {
                    if (objectArray == null && joinPoint instanceof DynamicJoinPointImpl) {
                        dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
                        dynamicJoinPointImpl.setMonitorType(diagnosticMonitor.getType());
                        objectArray = dynamicJoinPointImpl.getArguments();
                        dynamicJoinPointImpl.setMonitorType(null);
                    }
                    Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
                }
                if (!(object instanceof HttpSession)) break block10;
                int n = -1;
                try {
                    if (object instanceof Serializable) {
                        n = PassivationUtils.sizeOf(object);
                    }
                }
                catch (IOException iOException) {
                    n = -2;
                }
                InstrumentationEvent instrumentationEvent = HttpSessionDebugMonitorSupport.createInstrumentationEvent(joinPoint, diagnosticMonitorControl, "SessionSize-After", n);
                EventQueue.getInstance().enqueue(instrumentationEvent);
            }
            catch (Throwable throwable) {
                UnexpectedExceptionHandler.handle("Unexpected exception in HttpSessionDebugMonitorSupport.postProcess", throwable);
            }
        }
    }

    private static InstrumentationEvent createInstrumentationEvent(JoinPoint joinPoint, DiagnosticMonitorControl diagnosticMonitorControl, String string, int n) {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        InstrumentationEvent instrumentationEvent = new InstrumentationEvent(diagnosticMonitorControl, joinPoint);
        if (diagnosticContext != null) {
            instrumentationEvent.setContextId(diagnosticContext.getContextId());
        }
        instrumentationEvent.setEventType(string);
        instrumentationEvent.setPayload(new Integer(n));
        return instrumentationEvent;
    }
}

