/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.lang.reflect.Method;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;

public final class ComponentRegistry {
    private static DiagnosticComponentLifecycle[] allComponents = null;
    private static int[] foundationComponents = null;
    private static int[] nonFoundationComponents = null;
    private static final Boolean NOT_FOUNDATION = new Boolean(false);
    private static final Boolean IS_FOUNDATION = new Boolean(true);
    private static final Object[][] componentSpecs = new Object[][]{{"Diagnostic Image", "weblogic.diagnostics.lifecycle.DiagnosticImageLifecycleImpl", IS_FOUNDATION}, {"Server Logging", "weblogic.diagnostics.lifecycle.ServerLoggingLifecycleImpl", IS_FOUNDATION}, {"Debug", "weblogic.diagnostics.lifecycle.DebugLifecycleImpl", IS_FOUNDATION}, {"Diagnostic Context", "weblogic.diagnostics.lifecycle.DiagnosticContextLifecycleImpl", IS_FOUNDATION}, {"Manager", "weblogic.diagnostics.lifecycle.ManagerLifecycleImpl", IS_FOUNDATION}, {"Archive", "weblogic.diagnostics.lifecycle.ArchiveLifecycleImpl", IS_FOUNDATION}, {"Domain Logging", "weblogic.diagnostics.lifecycle.LoggingLifecycleImpl", NOT_FOUNDATION}, {"Harvester", "weblogic.diagnostics.harvester.internal.HarvesterLifecycleImpl", NOT_FOUNDATION}, {"Watches & Notifications", "weblogic.diagnostics.lifecycle.WatchLifecycleImpl", NOT_FOUNDATION}, {"Accessor", "weblogic.diagnostics.lifecycle.AccessorLifecycleImpl", NOT_FOUNDATION}, {"Instrumentation System", "weblogic.diagnostics.lifecycle.InstrumentationLifecycleImpl", NOT_FOUNDATION}, {"WLDF archive data retirement", "weblogic.diagnostics.lifecycle.DataRetirementLifecycleImpl", NOT_FOUNDATION}};

    public static String getWLDFComponentName(DiagnosticComponentLifecycle diagnosticComponentLifecycle) {
        if (allComponents == null) {
            return null;
        }
        for (int i = 0; i < allComponents.length; ++i) {
            DiagnosticComponentLifecycle diagnosticComponentLifecycle2 = allComponents[i];
            if (diagnosticComponentLifecycle != diagnosticComponentLifecycle2) continue;
            return (String)componentSpecs[i][0];
        }
        return null;
    }

    static DiagnosticComponentLifecycle[] getNonFoundationWLDFComponents() {
        try {
            if (nonFoundationComponents == null) {
                ComponentRegistry.initComponents();
            }
            return ComponentRegistry.getComponentArray(nonFoundationComponents);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static DiagnosticComponentLifecycle[] getFoundationWLDFComponents() {
        try {
            if (foundationComponents == null) {
                ComponentRegistry.initComponents();
            }
            return ComponentRegistry.getComponentArray(foundationComponents);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static DiagnosticComponentLifecycle[] getComponentArray(int[] nArray) {
        DiagnosticComponentLifecycle[] diagnosticComponentLifecycleArray = new DiagnosticComponentLifecycle[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            diagnosticComponentLifecycleArray[i] = allComponents[nArray[i]];
        }
        return diagnosticComponentLifecycleArray;
    }

    private static void initComponents() throws Exception {
        int[] nArray = new int[componentSpecs.length];
        int n = 0;
        int[] nArray2 = new int[componentSpecs.length];
        int n2 = 0;
        allComponents = new DiagnosticComponentLifecycle[componentSpecs.length];
        for (int i = 0; i < componentSpecs.length; ++i) {
            Object[] objectArray = componentSpecs[i];
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            Boolean bl = (Boolean)objectArray[2];
            boolean bl2 = bl;
            Class<?> clazz = null;
            try {
                DiagnosticComponentLifecycle diagnosticComponentLifecycle;
                clazz = Class.forName(string2);
                Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
                ComponentRegistry.allComponents[i] = diagnosticComponentLifecycle = (DiagnosticComponentLifecycle)method.invoke(null, new Object[0]);
                if (bl2) {
                    nArray[n] = i;
                    ++n;
                    continue;
                }
                nArray2[n2] = i;
                ++n2;
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        foundationComponents = new int[n];
        System.arraycopy(nArray, 0, foundationComponents, 0, n);
        nonFoundationComponents = new int[n2];
        System.arraycopy(nArray2, 0, nonFoundationComponents, 0, n2);
    }
}

