/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.lifecycle.ComponentRegistry;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;
import weblogic.diagnostics.lifecycle.DiagnosticLifecycleConstants;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

final class DebugLifecycleUtility {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticLifecycleHandlers");

    private DebugLifecycleUtility() {
    }

    static void debugHandlerStates(DiagnosticComponentLifecycle[] diagnosticComponentLifecycleArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Displaying server state and diagnostic component states:");
            debugLogger.debug("Server state: " + ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getState());
            for (int i = 0; i < diagnosticComponentLifecycleArray.length; ++i) {
                DiagnosticComponentLifecycle diagnosticComponentLifecycle = diagnosticComponentLifecycleArray[i];
                debugLogger.debug("Name: " + ComponentRegistry.getWLDFComponentName(diagnosticComponentLifecycle));
                debugLogger.debug("Status: " + DiagnosticLifecycleConstants.STATES[diagnosticComponentLifecycle.getStatus()]);
            }
        }
    }
}

