/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import weblogic.diagnostics.lifecycle.ComponentRegistry;
import weblogic.diagnostics.lifecycle.DebugLifecycleUtility;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycleException;
import weblogic.diagnostics.lifecycle.WLDFRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class DiagnosticFoundationService
extends AbstractServerService {
    private static final DiagnosticComponentLifecycle[] components = ComponentRegistry.getFoundationWLDFComponents();
    private static DiagnosticFoundationService diagnosticFoundationInstance;
    private boolean initialized;
    private WLDFRuntimeMBeanImpl wldfRuntime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticFoundationService() {
        Class<DiagnosticFoundationService> clazz = DiagnosticFoundationService.class;
        synchronized (DiagnosticFoundationService.class) {
            if (diagnosticFoundationInstance != null) {
                throw new IllegalStateException("Attempt to instantiate multiple instances.");
            }
            diagnosticFoundationInstance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized DiagnosticFoundationService getInstance() {
        if (diagnosticFoundationInstance == null) {
            diagnosticFoundationInstance = new DiagnosticFoundationService();
        }
        return diagnosticFoundationInstance;
    }

    public DiagnosticComponentLifecycle[] getComponents() {
        return components;
    }

    public synchronized void start() throws ServiceFailureException {
        if (this.initialized) {
            return;
        }
        try {
            this.wldfRuntime = new WLDFRuntimeMBeanImpl();
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
        for (int i = 0; i < components.length; ++i) {
            try {
                components[i].initialize();
                continue;
            }
            catch (DiagnosticComponentLifecycleException diagnosticComponentLifecycleException) {
                throw new ServiceFailureException((Throwable)((Object)diagnosticComponentLifecycleException));
            }
        }
        this.initialized = true;
        DebugLifecycleUtility.debugHandlerStates(components);
    }

    public void stop() throws ServiceFailureException {
        DebugLifecycleUtility.debugHandlerStates(components);
        if (!this.initialized) {
            return;
        }
        this.disableComponents();
        this.initialized = false;
    }

    public void halt() throws ServiceFailureException {
        if (!this.initialized) {
            return;
        }
        this.disableComponents();
        this.initialized = false;
        DebugLifecycleUtility.debugHandlerStates(components);
    }

    private void disableComponents() throws ServiceFailureException {
        for (int i = components.length - 1; i >= 0; --i) {
            try {
                components[i].disable();
                continue;
            }
            catch (DiagnosticComponentLifecycleException diagnosticComponentLifecycleException) {
                throw new ServiceFailureException((Throwable)((Object)diagnosticComponentLifecycleException));
            }
        }
    }
}

