/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.security.AccessController;
import java.util.HashMap;
import weblogic.diagnostics.accessor.AccessorUtils;
import weblogic.diagnostics.archive.DiagnosticStoreRepository;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.lifecycle.ComponentRegistry;
import weblogic.diagnostics.lifecycle.DebugLifecycleUtility;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycleException;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.store.PersistentStoreException;
import weblogic.store.RuntimeHandler;
import weblogic.store.admin.RuntimeHandlerImpl;

public final class DiagnosticSystemService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DiagnosticComponentLifecycle[] components = ComponentRegistry.getNonFoundationWLDFComponents();
    private static DiagnosticSystemService diagnosticSystemInstance;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticSystemService() {
        Class<DiagnosticSystemService> clazz = DiagnosticSystemService.class;
        synchronized (DiagnosticSystemService.class) {
            if (diagnosticSystemInstance != null) {
                throw new IllegalStateException("Attempt to instantiate multiple instances.");
            }
            diagnosticSystemInstance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized DiagnosticSystemService getInstance() {
        if (diagnosticSystemInstance == null) {
            diagnosticSystemInstance = new DiagnosticSystemService();
        }
        return diagnosticSystemInstance;
    }

    public DiagnosticComponentLifecycle[] getComponents() {
        return components;
    }

    public void start() throws ServiceFailureException {
        if (this.initialized) {
            return;
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        DiagnosticsLogger.logDiagnosticsInitializing((String)serverMBean.getName());
        String string = AccessorUtils.getDiagnosticStoreDirectory();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = serverMBean.getServerDiagnosticConfig();
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        hashMap.put("FileLockingEnabled", Boolean.valueOf(wLDFServerDiagnosticMBean.isDiagnosticStoreFileLockingEnabled()));
        hashMap.put("IoBufferSize", Integer.valueOf(wLDFServerDiagnosticMBean.getDiagnosticStoreIoBufferSize()));
        hashMap.put("BlockSize", Integer.valueOf(wLDFServerDiagnosticMBean.getDiagnosticStoreBlockSize()));
        hashMap.put("MaxFileSize", Long.valueOf(wLDFServerDiagnosticMBean.getDiagnosticStoreMaxFileSize()));
        hashMap.put("MinWindowBufferSize", Integer.valueOf(wLDFServerDiagnosticMBean.getDiagnosticStoreMinWindowBufferSize()));
        hashMap.put("MaxWindowBufferSize", Integer.valueOf(wLDFServerDiagnosticMBean.getDiagnosticStoreMaxWindowBufferSize()));
        try {
            DiagnosticStoreRepository.getInstance().getStore(string, hashMap, (RuntimeHandler)(KernelStatus.isServer() ? new RuntimeHandlerImpl() : null));
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new ServiceFailureException((Throwable)persistentStoreException);
        }
        for (int i = 0; i < components.length; ++i) {
            try {
                components[i].initialize();
                continue;
            }
            catch (DiagnosticComponentLifecycleException diagnosticComponentLifecycleException) {
                throw new ServiceFailureException((Throwable)((Object)diagnosticComponentLifecycleException));
            }
        }
        this.initialized = true;
        DebugLifecycleUtility.debugHandlerStates(components);
    }

    public void stop() throws ServiceFailureException {
        if (!this.initialized) {
            return;
        }
        DiagnosticsLogger.logDiagnosticsStopping((String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
        for (int i = components.length - 1; i >= 0; --i) {
            try {
                components[i].disable();
                continue;
            }
            catch (DiagnosticComponentLifecycleException diagnosticComponentLifecycleException) {
                throw new ServiceFailureException((Throwable)((Object)diagnosticComponentLifecycleException));
            }
        }
        this.initialized = false;
        DebugLifecycleUtility.debugHandlerStates(components);
    }

    public void halt() throws ServiceFailureException {
        if (!this.initialized) {
            return;
        }
        DiagnosticsLogger.logDiagnosticsStopping((String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
        for (int i = components.length - 1; i >= 0; --i) {
            try {
                components[i].disable();
                continue;
            }
            catch (DiagnosticComponentLifecycleException diagnosticComponentLifecycleException) {
                throw new ServiceFailureException((Throwable)((Object)diagnosticComponentLifecycleException));
            }
        }
        this.initialized = false;
        DebugLifecycleUtility.debugHandlerStates(components);
    }

    public static boolean isInitialized() {
        return diagnosticSystemInstance != null && DiagnosticSystemService.diagnosticSystemInstance.initialized;
    }
}

