/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.security.AccessController;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringManager;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycleException;
import weblogic.logging.DomainLogBroadcasterClient;
import weblogic.logging.LogEditObserver;
import weblogic.management.ManagementException;
import weblogic.management.configuration.LogMBean;
import weblogic.management.logging.DomainLogHandlerException;
import weblogic.management.logging.DomainLogHandlerImpl;
import weblogic.management.logging.LogBroadcaster;
import weblogic.management.logging.LogRuntime;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class LoggingLifecycleImpl
implements DiagnosticComponentLifecycle {
    private static LoggingLifecycleImpl singleton = new LoggingLifecycleImpl();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int status = 4;
    private DomainLogBroadcasterClient client = null;

    public static final DiagnosticComponentLifecycle getInstance() {
        return singleton;
    }

    public int getStatus() {
        return this.status;
    }

    public void initialize() throws DiagnosticComponentLifecycleException {
        try {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            runtimeAccess.addAccessCallbackClass(LogEditObserver.class.getName());
            if (runtimeAccess.isAdminServer()) {
                DomainLogHandlerImpl.getInstance();
                DomainRuntimeMBean domainRuntimeMBean = ManagementService.getDomainAccess(kernelId).getDomainRuntime();
                LogMBean logMBean = runtimeAccess.getDomain().getLog();
                LogRuntime logRuntime = new LogRuntime(logMBean, domainRuntimeMBean);
                domainRuntimeMBean.setLogRuntime(logRuntime);
            }
        }
        catch (DomainLogHandlerException domainLogHandlerException) {
            DiagnosticsLogger.logErrorCreatingDomainLogHandler((Throwable)domainLogHandlerException);
        }
        catch (ManagementException managementException) {
            throw new DiagnosticComponentLifecycleException(managementException.toString());
        }
        try {
            LogBroadcaster.getLogBroadcaster();
            this.client = DomainLogBroadcasterClient.getInstance();
            this.initDomainLogHandler(false);
            ConnectMonitorFactory.getConnectMonitor().addConnectListener(new ConnectListener(){

                public void onConnect(ConnectEvent connectEvent) {
                    if (!connectEvent.getServerName().equals(ManagementService.getRuntimeAccess(kernelId).getAdminServerName())) {
                        return;
                    }
                    if (LoggingLifecycleImpl.this.client == null) {
                        return;
                    }
                    LoggingLifecycleImpl.this.initDomainLogHandler(true);
                }
            });
        }
        catch (ManagementException managementException) {
            throw new DiagnosticComponentLifecycleException(managementException.toString());
        }
        DataGatheringManager.initializeLogging();
        this.status = 1;
    }

    private void initDomainLogHandler(boolean bl) {
        this.client.initDomainLogHandler(bl);
    }

    public void enable() throws DiagnosticComponentLifecycleException {
    }

    public void disable() throws DiagnosticComponentLifecycleException {
        DomainLogBroadcasterClient domainLogBroadcasterClient = DomainLogBroadcasterClient.getInstance();
        domainLogBroadcasterClient.flush();
        domainLogBroadcasterClient.close();
    }
}

