/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WLDFAccessRuntimeMBean;
import weblogic.management.runtime.WLDFArchiveRuntimeMBean;
import weblogic.management.runtime.WLDFHarvesterRuntimeMBean;
import weblogic.management.runtime.WLDFImageRuntimeMBean;
import weblogic.management.runtime.WLDFInstrumentationRuntimeMBean;
import weblogic.management.runtime.WLDFRuntimeMBean;
import weblogic.management.runtime.WLDFWatchNotificationRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WLDFRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFRuntimeMBean {
    private WLDFAccessRuntimeMBean accessRuntime;
    private WLDFArchiveRuntimeMBean archiveRuntime;
    private WLDFHarvesterRuntimeMBean harvesterRuntime;
    private WLDFImageRuntimeMBean imageRuntime;
    private WLDFWatchNotificationRuntimeMBean watchRuntime;
    private List archiveRuntimesList = new ArrayList();
    private List instRuntimesList = new ArrayList();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public WLDFRuntimeMBeanImpl() throws ManagementException {
        super("WLDFRuntime");
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        serverRuntimeMBean.setWLDFRuntime(this);
    }

    public WLDFAccessRuntimeMBean getWLDFAccessRuntime() {
        return this.accessRuntime;
    }

    public void setWLDFAccessRuntime(WLDFAccessRuntimeMBean wLDFAccessRuntimeMBean) {
        this.accessRuntime = wLDFAccessRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WLDFArchiveRuntimeMBean[] getWLDFArchiveRuntimes() {
        List list = this.archiveRuntimesList;
        synchronized (list) {
            WLDFArchiveRuntimeMBean[] wLDFArchiveRuntimeMBeanArray = new WLDFArchiveRuntimeMBean[this.archiveRuntimesList.size()];
            wLDFArchiveRuntimeMBeanArray = this.archiveRuntimesList.toArray(wLDFArchiveRuntimeMBeanArray);
            return wLDFArchiveRuntimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWLDFArchiveRuntime(WLDFArchiveRuntimeMBean wLDFArchiveRuntimeMBean) {
        List list = this.archiveRuntimesList;
        synchronized (list) {
            if (this.archiveRuntimesList.contains(wLDFArchiveRuntimeMBean)) {
                return false;
            }
            return this.archiveRuntimesList.add(wLDFArchiveRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWLDFArchiveRuntime(WLDFArchiveRuntimeMBean wLDFArchiveRuntimeMBean) {
        List list = this.archiveRuntimesList;
        synchronized (list) {
            return this.archiveRuntimesList.remove(wLDFArchiveRuntimeMBean);
        }
    }

    public WLDFHarvesterRuntimeMBean getWLDFHarvesterRuntime() {
        return this.harvesterRuntime;
    }

    public void setWLDFHarvesterRuntime(WLDFHarvesterRuntimeMBean wLDFHarvesterRuntimeMBean) {
        this.harvesterRuntime = wLDFHarvesterRuntimeMBean;
    }

    public WLDFImageRuntimeMBean getWLDFImageRuntime() {
        return this.imageRuntime;
    }

    public void setWLDFImageRuntime(WLDFImageRuntimeMBean wLDFImageRuntimeMBean) {
        this.imageRuntime = wLDFImageRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WLDFInstrumentationRuntimeMBean[] getWLDFInstrumentationRuntimes() {
        List list = this.instRuntimesList;
        synchronized (list) {
            WLDFInstrumentationRuntimeMBean[] wLDFInstrumentationRuntimeMBeanArray = new WLDFInstrumentationRuntimeMBean[this.instRuntimesList.size()];
            wLDFInstrumentationRuntimeMBeanArray = this.instRuntimesList.toArray(wLDFInstrumentationRuntimeMBeanArray);
            return wLDFInstrumentationRuntimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWLDFInstrumentationRuntime(WLDFInstrumentationRuntimeMBean wLDFInstrumentationRuntimeMBean) {
        List list = this.instRuntimesList;
        synchronized (list) {
            if (this.instRuntimesList.contains(wLDFInstrumentationRuntimeMBean)) {
                return false;
            }
            return this.instRuntimesList.add(wLDFInstrumentationRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWLDFInstrumentationRuntime(WLDFInstrumentationRuntimeMBean wLDFInstrumentationRuntimeMBean) {
        List list = this.instRuntimesList;
        synchronized (list) {
            return this.instRuntimesList.remove(wLDFInstrumentationRuntimeMBean);
        }
    }

    public WLDFWatchNotificationRuntimeMBean getWLDFWatchNotificationRuntime() {
        return this.watchRuntime;
    }

    public void setWLDFWatchNotificationRuntime(WLDFWatchNotificationRuntimeMBean wLDFWatchNotificationRuntimeMBean) {
        this.watchRuntime = wLDFWatchNotificationRuntimeMBean;
    }

    public WLDFInstrumentationRuntimeMBean lookupWLDFInstrumentationRuntime(String string) {
        for (WLDFInstrumentationRuntimeMBean wLDFInstrumentationRuntimeMBean : this.instRuntimesList) {
            if (!wLDFInstrumentationRuntimeMBean.getName().equals(string)) continue;
            return wLDFInstrumentationRuntimeMBean;
        }
        return null;
    }
}

