/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.lifecycle;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycle;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycleException;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WatchLifecycleImpl
implements DiagnosticComponentLifecycle {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticLifecycleHandlers");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static WatchLifecycleImpl singleton = new WatchLifecycleImpl();
    private static final long WAIT_INCREMENT = 1000L;
    long maxImageCaptureWait = 30000L;

    public static final DiagnosticComponentLifecycle getInstance() {
        return singleton;
    }

    public int getStatus() {
        return 4;
    }

    public void initialize() throws DiagnosticComponentLifecycleException {
        try {
            WatchManager.getInstance();
            if (ManagementService.isRuntimeAccessInitialized()) {
                this.maxImageCaptureWait = (long)((double)(ManagementService.getRuntimeAccess(kernelId).getServer().getServerLifeCycleTimeoutVal() * 1000) * 0.75);
            }
        }
        catch (ManagementException managementException) {
            throw new DiagnosticComponentLifecycleException(managementException);
        }
    }

    public void enable() throws DiagnosticComponentLifecycleException {
    }

    public void disable() throws DiagnosticComponentLifecycleException {
        this.waitForImageTasks();
    }

    private void waitForImageTasks() throws DiagnosticComponentLifecycleException {
        block9: {
            try {
                if (WatchManager.getInstance().getNumActiveImageNotifications() <= 0) break block9;
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Waiting for any active DIMG notifications to complete");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = 0L;
                while (ImageManager.getInstance().tasksInProgress() && l < this.maxImageCaptureWait) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Image capture in progress, waiting...");
                    }
                    try {
                        Thread.sleep(1000L);
                        l += 1000L;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (ManagementException managementException) {
                throw new DiagnosticComponentLifecycleException(managementException);
            }
        }
    }
}

