/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.module;

import java.lang.reflect.Method;
import weblogic.application.ApplicationContext;
import weblogic.descriptor.DescriptorDiff;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.module.WLDFSubModule;

public final class SubModuleRegistry {
    private static Method[] allModuleResolvers = null;
    private static int[] appScopedModules = null;
    private static int[] modules = null;
    private static final Boolean NOT_APP_SCOPED = new Boolean(false);
    private static final Boolean IS_APP_SCOPED = new Boolean(true);
    private static final Object[][] moduleSpecs = new Object[][]{{"Instrumentation System WLDF Submodule", "weblogic.diagnostics.instrumentation.InstrumentationSubmodule", IS_APP_SCOPED}, {"Harvester WLDF Submodule", "weblogic.diagnostics.harvester.internal.HarvesterSubModule", NOT_APP_SCOPED}, {"Watches & Notifications WLDF Submodule", "weblogic.diagnostics.watch.WatchSubModule", NOT_APP_SCOPED}};
    private static SubModuleRegistry self = new SubModuleRegistry();

    public static String getWLDFSubModuleName(WLDFSubModule wLDFSubModule) {
        return ((ModuleInstance)wLDFSubModule).name;
    }

    public static Class getWLDFSubModuleType(WLDFSubModule wLDFSubModule) {
        return ((ModuleInstance)wLDFSubModule).module.getClass();
    }

    public static WLDFSubModule[] getWLDFSubModules() {
        try {
            if (modules == null) {
                SubModuleRegistry.initSubModules();
            }
            return SubModuleRegistry.getSubModuleArray(modules);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static WLDFSubModule[] getAppScopedWLDFSubModules() {
        try {
            if (appScopedModules == null) {
                SubModuleRegistry.initSubModules();
            }
            return SubModuleRegistry.getSubModuleArray(appScopedModules);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static WLDFSubModule[] getSubModuleArray(int[] nArray) {
        try {
            WLDFSubModule[] wLDFSubModuleArray = new WLDFSubModule[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                String string = (String)moduleSpecs[n][0];
                Method method = allModuleResolvers[n];
                WLDFSubModule wLDFSubModule = (WLDFSubModule)method.invoke(null, new Object[0]);
                SubModuleRegistry subModuleRegistry = self;
                subModuleRegistry.getClass();
                wLDFSubModuleArray[i] = wLDFSubModule = subModuleRegistry.new ModuleInstance(string, wLDFSubModule);
            }
            return wLDFSubModuleArray;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void initSubModules() throws Exception {
        int[] nArray = new int[moduleSpecs.length];
        int n = 0;
        int[] nArray2 = new int[moduleSpecs.length];
        int n2 = 0;
        allModuleResolvers = new Method[moduleSpecs.length];
        for (int i = 0; i < moduleSpecs.length; ++i) {
            Object[] objectArray = moduleSpecs[i];
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            Boolean bl = (Boolean)objectArray[2];
            boolean bl2 = bl;
            Class<?> clazz = null;
            try {
                Method method;
                clazz = Class.forName(string2);
                SubModuleRegistry.allModuleResolvers[i] = method = clazz.getDeclaredMethod("createInstance", new Class[0]);
                nArray2[n2] = i;
                ++n2;
                if (!bl2) continue;
                nArray[n] = i;
                ++n;
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        appScopedModules = new int[n];
        System.arraycopy(nArray, 0, appScopedModules, 0, n);
        modules = new int[n2];
        System.arraycopy(nArray2, 0, modules, 0, n2);
    }

    private class ModuleInstance
    implements WLDFSubModule {
        String name;
        WLDFSubModule module;

        private ModuleInstance(String string, WLDFSubModule wLDFSubModule) {
            this.name = string;
            this.module = wLDFSubModule;
        }

        public void init(ApplicationContext applicationContext, WLDFResourceBean wLDFResourceBean) throws WLDFModuleException {
            this.module.init(applicationContext, wLDFResourceBean);
        }

        public void prepare() throws WLDFModuleException {
            this.module.prepare();
        }

        public void activate() throws WLDFModuleException {
            this.module.activate();
        }

        public void deactivate() throws WLDFModuleException {
            this.module.deactivate();
        }

        public void unprepare() throws WLDFModuleException {
            this.module.unprepare();
        }

        public void destroy() throws WLDFModuleException {
            this.module.destroy();
        }

        public void prepareUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
            this.module.prepareUpdate(wLDFResourceBean, descriptorDiff);
        }

        public void activateUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
            this.module.activateUpdate(wLDFResourceBean, descriptorDiff);
        }

        public void rollbackUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) {
            this.module.rollbackUpdate(wLDFResourceBean, descriptorDiff);
        }
    }
}

