/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.FatalModuleException;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.module.SubModuleRegistry;
import weblogic.diagnostics.module.WLDFDescriptorLoader;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.module.WLDFModuleStates;
import weblogic.diagnostics.module.WLDFSubModule;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public class WLDFModule
implements Module,
UpdateListener,
WLDFModuleStates {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugDiagnosticsModule");
    private String moduleURI = null;
    private WLDFResourceBean wldfResource = null;
    private WLDFSubModule[] subModules;
    private int moduleState = 0;
    private WLDFResourceBean proposedWLDFResource;
    private DescriptorDiff proposedUpdates = null;
    private ApplicationContextInternal appCtxInternal;
    public static final String UPDATE_SYNC = new String("");

    public WLDFModule(String string) {
        this.moduleURI = string;
    }

    public String getId() {
        return this.moduleURI;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_WLDF;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    public DescriptorBean[] getDescriptors() {
        if (this.wldfResource == null) {
            return new DescriptorBean[0];
        }
        return new DescriptorBean[]{(DescriptorBean)this.wldfResource};
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.initUsingLoader(applicationContext, genericClassLoader, registration);
        return genericClassLoader;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.initDescriptor(applicationContext, registration);
    }

    public void prepare() throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 1) {
            DEBUG_LOGGER.debug("WLDF Module not in INITIALIZED state during prepare() callback.  State was " + this.moduleState);
        }
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Inside prepare()");
        }
        try {
            for (int i = 0; i < this.subModules.length; ++i) {
                this.subModules[i].prepare();
            }
        }
        catch (ModuleException moduleException) {
            if (moduleException instanceof FatalModuleException) {
                throw moduleException;
            }
            throw new FatalModuleException((Throwable)((Object)moduleException));
        }
        this.moduleState = 2;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLDFModule PREPARED successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 2) {
            DEBUG_LOGGER.debug("WLDF Module not in PREPARED state during activate() callback.  State was " + this.moduleState);
        }
        String string = UPDATE_SYNC;
        synchronized (string) {
            try {
                for (int i = 0; i < this.subModules.length; ++i) {
                    this.subModules[i].activate();
                }
            }
            catch (ModuleException moduleException) {
                if (moduleException instanceof FatalModuleException) {
                    throw moduleException;
                }
                throw new FatalModuleException((Throwable)((Object)moduleException));
            }
        }
        this.moduleState = 3;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLDFModule ACTIVATED successfully");
        }
    }

    public void start() throws ModuleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 3) {
            DEBUG_LOGGER.debug("WLDF Module not in ACTIVATED state during deactivate() callback.  State was " + this.moduleState);
        }
        String string = UPDATE_SYNC;
        synchronized (string) {
            for (int i = 0; i < this.subModules.length; ++i) {
                this.subModules[i].deactivate();
            }
            this.moduleState = 2;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("WLDFModule deactivated successfully");
            }
        }
    }

    public void unprepare() throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 2) {
            DEBUG_LOGGER.debug("WLDF Module not in PREPARED state during unprepare() callback.  State was " + this.moduleState);
        }
        for (int i = 0; i < this.subModules.length; ++i) {
            this.subModules[i].unprepare();
        }
        this.moduleState = 1;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLDFModule unprepared successfully");
        }
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 1) {
            DEBUG_LOGGER.debug("WLDF Module not in INITIALIZED state during destroy() callback.  State was " + this.moduleState);
        }
        for (int i = 0; i < this.subModules.length; ++i) {
            this.subModules[i].destroy();
        }
        this.moduleState = 0;
        registration.removeUpdateListener(this);
    }

    public void remove() throws ModuleException {
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
    }

    public void forceProductionToAdmin() throws ModuleException {
    }

    public boolean acceptURI(String string) {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 3) {
            DEBUG_LOGGER.debug("WLDF Module not in ACTIVATED state during acceptURI() callback. State was " + this.moduleState);
        }
        return this.moduleURI.equals(string);
    }

    public void prepareUpdate(String string) throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 3) {
            DEBUG_LOGGER.debug("WLDF Module not in ACTIVATED state during prepareUpdate() callback.  State was " + this.moduleState);
        }
        try {
            if (this.appCtxInternal.getSystemResourceMBean() != null) {
                string = DomainDir.getPathRelativeConfigDir((String)string);
            }
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Preparing update from URI = " + string);
            }
            this.proposedWLDFResource = this.loadDescriptor(this.appCtxInternal, string, true);
            Descriptor descriptor = ((DescriptorBean)this.wldfResource).getDescriptor();
            Descriptor descriptor2 = ((DescriptorBean)this.proposedWLDFResource).getDescriptor();
            this.proposedUpdates = descriptor.computeDiff(descriptor2);
        }
        catch (Exception exception) {
            throw new WLDFModuleException(exception);
        }
        for (int i = 0; i < this.subModules.length; ++i) {
            this.subModules[i].prepareUpdate(this.proposedWLDFResource, this.proposedUpdates);
        }
        this.moduleState = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(String string) throws ModuleException {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 4) {
            DEBUG_LOGGER.debug("WLDF Module not in UPDATE_PENDING state during activateUpdate() callback.  State was " + this.moduleState);
        }
        String string2 = UPDATE_SYNC;
        synchronized (string2) {
            for (int i = 0; i < this.subModules.length; ++i) {
                this.subModules[i].activateUpdate(this.proposedWLDFResource, this.proposedUpdates);
            }
        }
        this.moduleState = 3;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Activated update from URI = " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackUpdate(String string) {
        if (DEBUG_LOGGER.isDebugEnabled() && this.moduleState != 4) {
            DEBUG_LOGGER.debug("WLDF Module not in UPDATE_PENDING state during rollbackUpdate() callback.  State was " + this.moduleState);
        }
        String string2 = UPDATE_SYNC;
        synchronized (string2) {
            for (int i = 0; i < this.subModules.length; ++i) {
                this.subModules[i].rollbackUpdate(this.proposedWLDFResource, this.proposedUpdates);
            }
        }
        this.moduleState = 3;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Rolled back update from URI = " + string);
        }
    }

    private void initDescriptor(ApplicationContext applicationContext, UpdateListener.Registration registration) throws ModuleException {
        try {
            ApplicationContextInternal applicationContextInternal;
            this.appCtxInternal = applicationContextInternal = (ApplicationContextInternal)applicationContext;
            WLDFSystemResourceMBean wLDFSystemResourceMBean = (WLDFSystemResourceMBean)applicationContextInternal.getSystemResourceMBean();
            this.wldfResource = wLDFSystemResourceMBean != null ? wLDFSystemResourceMBean.getWLDFResource() : this.loadDescriptor(applicationContextInternal, this.moduleURI, false);
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Initialized WLDFResource");
            }
            this.subModules = wLDFSystemResourceMBean != null ? SubModuleRegistry.getWLDFSubModules() : SubModuleRegistry.getAppScopedWLDFSubModules();
            for (int i = 0; i < this.subModules.length; ++i) {
                this.subModules[i].init(applicationContext, this.wldfResource);
            }
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Initialized WLDF Submodules");
            }
            registration.addUpdateListener(this);
            this.moduleState = 1;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Initialized WLDF Module successfully");
            }
        }
        catch (Exception exception) {
            throw new ModuleException("Error creating WLDF descriptor from " + this.moduleURI, exception);
        }
    }

    public static DescriptorBean getDescriptorBean(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        WLDFDescriptorLoader wLDFDescriptorLoader = new WLDFDescriptorLoader(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2);
        return wLDFDescriptorLoader.loadDescriptorBean();
    }

    public static DescriptorBean getDescriptorBean(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        WLDFDescriptorLoader wLDFDescriptorLoader = new WLDFDescriptorLoader(virtualJarFile, file, deploymentPlanBean, string, string2);
        return wLDFDescriptorLoader.loadDescriptorBean();
    }

    public static DescriptorBean getDescriptorBean(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        WLDFDescriptorLoader wLDFDescriptorLoader = new WLDFDescriptorLoader(file, file2, deploymentPlanBean, string, string2);
        return wLDFDescriptorLoader.loadDescriptorBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLDFResourceBean loadDescriptor(ApplicationContextInternal applicationContextInternal, String string, boolean bl) throws IOException, XMLStreamException {
        VirtualJarFile virtualJarFile;
        InputStream inputStream;
        block26: {
            File file;
            WLDFDescriptorLoader wLDFDescriptorLoader;
            WLDFResourceBean wLDFResourceBean;
            block23: {
                WLDFResourceBean wLDFResourceBean2;
                inputStream = null;
                virtualJarFile = null;
                try {
                    if (applicationContextInternal.getSystemResourceMBean() == null) break block23;
                    DescriptorManager descriptorManager = new DescriptorManager();
                    inputStream = new FileInputStream(string);
                    WLDFDescriptorLoader wLDFDescriptorLoader2 = new WLDFDescriptorLoader(inputStream, descriptorManager, new ArrayList());
                    wLDFResourceBean2 = (WLDFResourceBean)wLDFDescriptorLoader2.loadDescriptorBean();
                    Object var15_12 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (virtualJarFile != null) {
                            virtualJarFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (virtualJarFile != null) {
                        virtualJarFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return wLDFResourceBean2;
            }
            File file2 = null;
            DeploymentPlanBean deploymentPlanBean = null;
            String string2 = new File(applicationContextInternal.getAppDeploymentMBean().getAbsoluteSourcePath()).getName();
            virtualJarFile = applicationContextInternal.getApplicationFileManager().getVirtualJarFile();
            AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
            deploymentPlanBean = this.getDeploymentPlan(applicationContextInternal, bl);
            if (appDeploymentMBean.getPlanDir() != null) {
                file2 = new File(appDeploymentMBean.getLocalPlanDir());
            }
            if ((wLDFResourceBean = this.getWLDFResourceBean(wLDFDescriptorLoader = (file = this.getExternalDiagnosticDescriptorFile(deploymentPlanBean)) != null ? new WLDFDescriptorLoader(file, file2, deploymentPlanBean, string2, string) : new WLDFDescriptorLoader(virtualJarFile, file2, deploymentPlanBean, string2, string))) == null) break block26;
            WLDFResourceBean wLDFResourceBean3 = wLDFResourceBean;
            Object var15_13 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return wLDFResourceBean3;
        }
        WLDFResourceBean wLDFResourceBean = (WLDFResourceBean)new DescriptorManager().createDescriptorRoot(WLDFResourceBean.class).getRootBean();
        Object var15_14 = null;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (virtualJarFile != null) {
                virtualJarFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wLDFResourceBean;
    }

    private DeploymentPlanBean getDeploymentPlan(ApplicationContextInternal applicationContextInternal, boolean bl) {
        DomainMBean domainMBean;
        String string = applicationContextInternal.getApplicationId();
        AppDeploymentMBean appDeploymentMBean = null;
        if (bl && (domainMBean = applicationContextInternal.getProposedDomain()) != null) {
            appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        }
        if (appDeploymentMBean == null) {
            appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
        }
        return appDeploymentMBean.getDeploymentPlanDescriptor();
    }

    private WLDFResourceBean getWLDFResourceBean(WLDFDescriptorLoader wLDFDescriptorLoader) throws IOException {
        try {
            return (WLDFResourceBean)wLDFDescriptorLoader.loadDescriptorBean();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private File getExternalDiagnosticDescriptorFile(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean == null) {
            return null;
        }
        File file = null;
        ModuleOverrideBean moduleOverrideBean = deploymentPlanBean.findModuleOverride(this.appCtxInternal.getApplicationFileName());
        if (moduleOverrideBean != null) {
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
            for (int i = 0; i < moduleDescriptorBeanArray.length; ++i) {
                if (!moduleDescriptorBeanArray[i].isExternal() || !moduleDescriptorBeanArray[i].getRootElement().equals("wldf-resource")) continue;
                file = new File(deploymentPlanBean.getConfigRoot(), moduleDescriptorBeanArray[i].getUri());
                if (file.isFile() && file.exists()) break;
                file = null;
            }
        }
        return file;
    }
}

