/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkit;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPConstants;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;
import weblogic.diagnostics.snmp.agent.monfox.MonfoxV3Toolkit;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class SNMPV3Agent
extends SNMPAgent
implements SNMPConstants {
    private WorkManager snmpWorkManager;
    private String engineId;
    private int engineBoots;
    private boolean communityBasedAccessEnabled = true;
    private int securityLevel;
    private int authProtocol;
    private int privProtocol;
    private long localizedKeyCacheInvalidationInterval;
    private long snmpEngineBoots;
    private String snmpDataFileName;
    private String tcpListenAddress;
    private int tcpListenPort;
    private SNMPV3AgentToolkit snmpV3AgentToolkit = (SNMPV3AgentToolkit)this.snmpAgentToolkit;

    public SNMPV3Agent() {
        super((SNMPAgentToolkit)new MonfoxV3Toolkit());
    }

    public void initialize() throws SNMPAgentToolkitException {
        this.snmpWorkManager = WorkManagerFactory.getInstance().findOrCreate("SnmpWorkManager", 2, -1);
        this.snmpV3AgentToolkit.initializeSNMPAgentToolkit(this.mibBasePath, this.mibModules);
        this.snmpV3AgentToolkit.setMaxPortRetryCount(this.maxPortRetryCount);
        this.snmpV3AgentToolkit.startSNMPAgent(this.engineId, this.tcpListenAddress, this.tcpListenPort, this.udpListenAddress, this.udpListenPort, this.engineBoots);
        this.snmpV3AgentToolkit.createSNMPMibTables(this.mibModules);
        this.snmpV3AgentToolkit.setSNMPCommunity(this.community, this.rootOidNode);
        this.snmpV3AgentToolkit.setCommunityBasedAccessEnabled(this.communityBasedAccessEnabled);
        this.snmpV3AgentToolkit.setSecurityParams(this.securityLevel, this.authProtocol, this.privProtocol, this.localizedKeyCacheInvalidationInterval);
        this.initializeTrapDestinations();
        this.snmpEngineBoots = this.getCurrentEngineBootsValue();
        this.updateSNMPEngineBoots();
        if (this.automaticTrapsEnabled) {
            this.sendColdStartTrap();
        }
        this.snmpAgentInitialized = true;
    }

    public int getEngineBoots() {
        return this.engineBoots;
    }

    public void setEngineBoots(int n) {
        this.engineBoots = n;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String string) {
        this.engineId = string;
    }

    public boolean isCommunityBasedAccessEnabled() {
        return this.communityBasedAccessEnabled;
    }

    public void setCommunityBasedAccessEnabled(boolean bl) {
        this.communityBasedAccessEnabled = bl;
    }

    public int getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(int n) {
        this.authProtocol = n;
    }

    public int getPrivProtocol() {
        return this.privProtocol;
    }

    public void setPrivProtocol(int n) {
        this.privProtocol = n;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int n) {
        this.securityLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSNMPEngineBoots() {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Updating engine boots");
        }
        ++this.snmpEngineBoots;
        String string = this.getSNMPDataFileName();
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        SNMPData sNMPData = new SNMPData();
        sNMPData.setEngineBoots(this.snmpEngineBoots);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(sNMPData);
            fileOutputStream.flush();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Updated engine boots to " + this.snmpEngineBoots);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Error updating engine boots ", throwable);
            }
        }
        finally {
            block17: {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!DEBUG.isDebugEnabled()) break block17;
                        DEBUG.debug("Error closing file ", (Throwable)iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentEngineBootsValue() {
        long l = 0L;
        String string = this.getSNMPDataFileName();
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("SNMP data file = " + string);
        }
        File file = new File(string);
        FileInputStream fileInputStream = null;
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                SNMPData sNMPData = (SNMPData)objectInputStream.readObject();
                l = sNMPData.getEngineBoots();
            }
            catch (Throwable throwable) {
                long l2 = 0L;
                return l2;
            }
            finally {
                block15: {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!DEBUG.isDebugEnabled()) break block15;
                        DEBUG.debug("Error closing data file", (Throwable)iOException);
                    }
                }
            }
        }
        return l;
    }

    public String getSNMPDataFileName() {
        return this.snmpDataFileName;
    }

    public void setSNMPDataFileName(String string) {
        this.snmpDataFileName = string;
    }

    public long getLocalizedKeyCacheInvalidationInterval() {
        return this.localizedKeyCacheInvalidationInterval;
    }

    public void setLocalizedKeyCacheInvalidationInterval(long l) {
        this.localizedKeyCacheInvalidationInterval = l;
    }

    public WorkManager getSnmpWorkManagerInstance() {
        return this.snmpWorkManager;
    }

    public String getTcpListenAddress() {
        return this.tcpListenAddress;
    }

    public void setTcpListenAddress(String string) {
        this.tcpListenAddress = string;
    }

    public int getTcpListenPort() {
        return this.tcpListenPort;
    }

    public void setTcpListenPort(int n) {
        this.tcpListenPort = n;
    }

    private static class SNMPData
    implements Serializable {
        private static final long serialVersionUID = 4541537220945911770L;
        private long engineBoots = 0L;

        private SNMPData() {
        }

        public long getEngineBoots() {
            return this.engineBoots;
        }

        public void setEngineBoots(long l) {
            this.engineBoots = l;
        }
    }
}

