/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.agent.ext.table.SnmpMibTableAdaptor;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.MD5;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.ArrayUtils;

public class MBeanInstanceTableRow
extends SnmpMibTableAdaptor.Row {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String LOCATION_KEY = "Location";
    private static final int SIZE_LIMIT = 512;
    private static String domainName;
    private MBeanServerConnection mbeanServerConnection;
    private ObjectName objectName;
    private Map columnsMetadata;
    private String index;
    private String location;

    public MBeanInstanceTableRow(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Map map) {
        this.mbeanServerConnection = mBeanServerConnection;
        this.objectName = objectName;
        this.columnsMetadata = map;
        this.index = MBeanInstanceTableRow.computeIndex(this.objectName.toString());
        this.location = objectName.getKeyProperty(LOCATION_KEY);
    }

    public boolean isAvailableForContextName(String string) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Context name = " + string);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(MBeanInstanceTableRow.getDomainName())) {
                return true;
            }
            if (this.location != null && this.location.length() > 0) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Location = " + this.location + " for " + this.objectName);
                }
                return this.location.equals(string);
            }
        }
        return true;
    }

    public SnmpValue getValue(SnmpOid snmpOid) throws SnmpValueException {
        String string = snmpOid.getOidInfo().getName();
        final String string2 = (String)this.columnsMetadata.get(string);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Getting attribute " + string2 + " for SNMP Column " + string);
        }
        if (string2.equals("Index")) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Index = " + this.index + " for " + snmpOid);
            }
            return SnmpValue.getInstance((SnmpOid)snmpOid, (String)this.index);
        }
        if (string2.equals("ObjectName")) {
            return SnmpValue.getInstance((SnmpOid)snmpOid, (String)this.objectName.toString());
        }
        Object object = null;
        try {
            object = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MBeanInstanceTableRow.this.mbeanServerConnection.getAttribute(MBeanInstanceTableRow.this.objectName, string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SnmpValueException("Error getting MBean attribute value");
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Got attribute " + string2 + " value " + object);
        }
        if (object == null) {
            object = "";
        } else if (object instanceof Object[]) {
            object = MBeanInstanceTableRow.toString((Object[])object);
        }
        String string3 = object.toString();
        if (string3.length() > 512) {
            string3 = string3.substring(0, 512);
        }
        return SnmpValue.getInstance((SnmpOid)snmpOid, (String)string3);
    }

    private static String toString(Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        ArrayUtils.addAll(arrayList, (Object[])objectArray);
        return arrayList.toString();
    }

    public void setValue(SnmpOid snmpOid, SnmpValue snmpValue) throws SnmpValueException {
        Loggable loggable = SNMPLogger.logCannotModifyMBeanAttributesLoggable();
        String string = loggable.getMessage();
        throw new SnmpValueException(string);
    }

    static String computeIndex(String string) {
        MD5 mD5 = new MD5();
        byte[] byArray = new byte[16];
        mD5.update(string.toString().getBytes());
        mD5.md5final(byArray);
        return "0x" + MD5.dumpBytes((byte[])byArray);
    }

    String getIndex() {
        return this.index;
    }

    static String getDomainName() {
        if (domainName == null) {
            domainName = ManagementService.getRuntimeAccess(KERNEL_ID).getDomainName();
        }
        return domainName;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    String getAttributeName(String string) {
        String string2 = (String)this.columnsMetadata.get(string);
        return string2;
    }
}

