/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import monfox.toolkit.snmp.agent.SnmpMibNode;
import monfox.toolkit.snmp.agent.ext.table.SnmpMibTableAdaptor;
import monfox.toolkit.snmp.metadata.builder.MibApi;
import weblogic.diagnostics.snmp.agent.MBeanServerSubAgentX;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPConstants;
import weblogic.diagnostics.snmp.agent.SNMPUtil;
import weblogic.diagnostics.snmp.agent.monfox.MBeanInstanceTableRow;
import weblogic.diagnostics.snmp.agent.monfox.SNMPSubAgentXImpl;

public class MBeanServerSubAgentXImpl
extends SNMPSubAgentXImpl
implements MBeanServerSubAgentX,
SNMPConstants {
    private Map snmpColumns = new HashMap();

    public MBeanServerSubAgentXImpl(String string, int n, String string2, String string3) throws SNMPAgentToolkitException {
        super(string, n, string2, string3);
    }

    public void addSNMPTableRowForMBeanInstance(MBeanServerConnection mBeanServerConnection, String string, ObjectName objectName) throws SNMPAgentToolkitException {
        SnmpMibTableAdaptor snmpMibTableAdaptor = null;
        try {
            if (!this.snmpTables.containsKey(string)) {
                snmpMibTableAdaptor = this.createSNMPTable(mBeanServerConnection, string, objectName);
                this.snmpTables.put(string, snmpMibTableAdaptor);
            } else {
                snmpMibTableAdaptor = (SnmpMibTableAdaptor)this.snmpTables.get(string);
            }
            Map map = (Map)this.snmpColumns.get(string);
            if (map != null) {
                MBeanInstanceTableRow mBeanInstanceTableRow = new MBeanInstanceTableRow(mBeanServerConnection, objectName, map);
                snmpMibTableAdaptor.addRow((SnmpMibTableAdaptor.Row)mBeanInstanceTableRow);
            }
        }
        catch (Exception exception) {
            throw new SNMPAgentToolkitException((Throwable)exception);
        }
    }

    public void deleteSNMPTableRowForMBeanInstance(String string, ObjectName objectName) throws SNMPAgentToolkitException {
        SnmpMibTableAdaptor snmpMibTableAdaptor = (SnmpMibTableAdaptor)this.snmpTables.get(string);
        if (snmpMibTableAdaptor != null) {
            String string2 = MBeanInstanceTableRow.computeIndex(objectName.toString());
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Deleting custom mbean row for index " + string2);
            }
            try {
                snmpMibTableAdaptor.removeRow(new String[]{string2});
            }
            catch (Exception exception) {
                throw new SNMPAgentToolkitException((Throwable)exception);
            }
        }
    }

    private SnmpMibTableAdaptor createSNMPTable(MBeanServerConnection mBeanServerConnection, String string, ObjectName objectName) throws Exception {
        String string2;
        String string3 = string2 = SNMPUtil.convertTypeNameToSNMPTableName((String)string);
        MibApi.Table table = this.mibApi.createTable(this.moduleName, string2, "Dynamically created table for type " + string);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanServerConnection.getMBeanInfo(objectName).getAttributes();
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)object;
                MBeanAttributeInfo mBeanAttributeInfo2 = (MBeanAttributeInfo)object2;
                return mBeanAttributeInfo.getName().compareTo(mBeanAttributeInfo2.getName());
            }
        };
        Arrays.sort(mBeanAttributeInfoArray, comparator);
        String string4 = string3 + "Index";
        table.addColumn(string4, "SNMPv2-TC.DisplayString", "na", "Index column", true);
        String string5 = string3 + "ObjectName";
        table.addColumn(string5, "SNMPv2-TC.DisplayString", "ro", "ObjectName column", false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string4, "Index");
        hashMap.put(string5, "ObjectName");
        if (mBeanAttributeInfoArray != null) {
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
                String string6 = mBeanAttributeInfo.getName();
                String string7 = mBeanAttributeInfo.getType();
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Discovered attribute " + string6 + " of type " + string7);
                }
                String string8 = string3 + string6;
                String string9 = "SNMPv2-TC.DisplayString";
                table.addColumn(string8, string9, "ro", mBeanAttributeInfo.getDescription(), false);
                hashMap.put(string8, string6);
            }
        }
        table.exportToMetadata();
        this.snmpColumns.put(string, hashMap);
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Adding table name " + string2 + " for type " + string);
        }
        SnmpMibTableAdaptor snmpMibTableAdaptor = new SnmpMibTableAdaptor(this.snmpMetadata, string2);
        snmpMibTableAdaptor.isLazyLoadingEnabled(true);
        this.snmpMib.add((SnmpMibNode)snmpMibTableAdaptor);
        return snmpMibTableAdaptor;
    }
}

