/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.net.InetAddress;
import java.security.AccessController;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import monfox.toolkit.snmp.SnmpIpAddress;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.agent.SnmpAccessControlModel;
import monfox.toolkit.snmp.agent.SnmpAgent;
import monfox.toolkit.snmp.agent.ext.acm.AppAcm;
import monfox.toolkit.snmp.agent.ext.audit.SnmpAuditTrailLogger;
import monfox.toolkit.snmp.agent.ext.table.SnmpMibTableAdaptor;
import monfox.toolkit.snmp.engine.SnmpEngineID;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.engine.TransportProvider;
import monfox.toolkit.snmp.util.ExecManager;
import monfox.toolkit.snmp.v3.usm.ext.UsmUserSecurityExtension;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPSecurityManager;
import weblogic.diagnostics.snmp.agent.SNMPSubAgentX;
import weblogic.diagnostics.snmp.agent.SNMPTransportProvider;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;
import weblogic.diagnostics.snmp.agent.monfox.MBeanInstanceTableRow;
import weblogic.diagnostics.snmp.agent.monfox.MBeanServerSubAgentXImpl;
import weblogic.diagnostics.snmp.agent.monfox.MonfoxExecManager;
import weblogic.diagnostics.snmp.agent.monfox.MonfoxToolkit;
import weblogic.diagnostics.snmp.agent.monfox.NotificationManager;
import weblogic.diagnostics.snmp.agent.monfox.ProxyManager;
import weblogic.diagnostics.snmp.agent.monfox.TargetManager;
import weblogic.diagnostics.snmp.agent.monfox.WLSAccessController;
import weblogic.diagnostics.snmp.agent.monfox.WLSAuditTrailLogger;
import weblogic.diagnostics.snmp.agent.monfox.WLSSecurityExtension;
import weblogic.diagnostics.snmp.agent.monfox.WLSSnmpSecurityManager;
import weblogic.diagnostics.snmp.agent.monfox.WLSTcpTransportProvider;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class MonfoxV3Toolkit
extends MonfoxToolkit
implements SNMPV3AgentToolkit {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private SnmpEngineID snmpEngineId;
    private WLSTcpTransportProvider tcpProvider;
    private SNMPSecurityManager snmpSecurityManager;

    public void initializeSNMPAgentToolkit(String string, String string2) throws SNMPAgentToolkitException {
        try {
            super.initializeSNMPAgentToolkit(string, string2);
            TransportProvider.addTransportProvider((int)2, WLSTcpTransportProvider.class);
        }
        catch (Exception exception) {
            throw new SNMPAgentToolkitException((Throwable)exception);
        }
    }

    public void startSNMPAgent(String string, String string2, int n, String string3, int n2, int n3) throws SNMPAgentToolkitException {
        try {
            this.snmpEngineId = new SnmpEngineID(string, true);
        }
        catch (SnmpValueException snmpValueException) {
            throw new SNMPAgentToolkitException((Throwable)snmpValueException);
        }
        for (int i = n2; i <= n2 + this.maxPortRetryCount; ++i) {
            if (i == 162) continue;
            try {
                InetAddress inetAddress;
                block16: {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("Trying UDP port " + i);
                    }
                    this.snmpAgentListenAddress = string3;
                    this.snmpAgentUDPPort = i;
                    SnmpAgent.V3Config v3Config = new SnmpAgent.V3Config(this.snmpAgentUDPPort, this.snmpEngineId);
                    inetAddress = null;
                    if (this.snmpAgentListenAddress != null && this.snmpAgentListenAddress.length() > 0) {
                        inetAddress = InetAddress.getByName(this.snmpAgentListenAddress);
                        v3Config.setInetAddress(inetAddress);
                    }
                    v3Config.setUsmUserSecurityExtension((UsmUserSecurityExtension)WLSSecurityExtension.getInstance());
                    v3Config.setAccessControlModel((SnmpAccessControlModel)new AppAcm((AppAcm.AccessController)WLSAccessController.getInstance()));
                    v3Config.setAuditTrailLogger((SnmpAuditTrailLogger)WLSAuditTrailLogger.getInstance());
                    this.snmpAgent = new SnmpAgent(this.snmpMib, v3Config);
                    if (inetAddress == null) {
                        try {
                            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
                            ServerURL serverURL = new ServerURL(URLManager.findAdministrationURL(runtimeAccess.getServerName()));
                            inetAddress = InetAddress.getByName(serverURL.getHost());
                        }
                        catch (Exception exception) {
                            if (!DEBUG_LOGGER.isDebugEnabled()) break block16;
                            DEBUG_LOGGER.debug("Error computing agent address", (Throwable)exception);
                        }
                    }
                }
                if (inetAddress != null) {
                    this.snmpAgent.setAgentAddress(new SnmpIpAddress(inetAddress));
                }
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Claimed UDP port " + i);
                }
                SNMPLogger.logStartedSNMPagent((int)n2);
                break;
            }
            catch (SnmpTransportException snmpTransportException) {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("UDP Port seems to be taken" + i);
                }
                this.snmpAgent = null;
                if (i != n2 + this.maxPortRetryCount) continue;
                throw new SNMPAgentToolkitException((Throwable)snmpTransportException);
            }
            catch (Throwable throwable) {
                throw new SNMPAgentToolkitException(throwable);
            }
        }
        try {
            this.snmpAgent.getEngine().setEngineBoots(n3);
            this.snmpAgent.setRequestExecManager((ExecManager)new MonfoxExecManager());
            this.snmpAgent.isCommunityAtContextFormSupported(true);
            this.targetManager = new TargetManager(this.snmpAgent.getTarget());
            this.notificationManager = new NotificationManager(this.snmpMetadata, this.snmpAgent.getNotifier());
            this.proxyManager = new ProxyManager(this.snmpAgent);
            this.tcpProvider = (WLSTcpTransportProvider)TransportProvider.newInstance((int)2, null, (int)0);
            this.snmpAgent.getEngine().addTransportProvider((TransportProvider)this.tcpProvider);
            this.snmpSecurityManager = new WLSSnmpSecurityManager(this.snmpAgent);
        }
        catch (Throwable throwable) {
            throw new SNMPAgentToolkitException(throwable);
        }
    }

    public void stopSNMPAgent() throws SNMPAgentToolkitException {
        if (this.tcpProvider != null) {
            this.snmpAgent.getEngine().removeTransportProvider((TransportProvider)this.tcpProvider);
        }
        super.stopSNMPAgent();
    }

    public void setSecurityParams(int n, int n2, int n3, long l) {
        WLSSecurityExtension wLSSecurityExtension = WLSSecurityExtension.getInstance();
        wLSSecurityExtension.setSecurityLevel(n);
        wLSSecurityExtension.setAuthProtocol(n2);
        wLSSecurityExtension.setPrivProtocol(n3);
        wLSSecurityExtension.setLocalizedKeyCacheInvalidationInterval(l);
        AppAcm appAcm = (AppAcm)this.snmpAgent.getAccessControlModel();
        WLSAccessController wLSAccessController = (WLSAccessController)appAcm.getAccessController();
        wLSAccessController.setSnmpEngineId(this.snmpEngineId);
    }

    public SNMPTransportProvider getTransportProvider(int n) {
        switch (n) {
            case 1: {
                return this.tcpProvider;
            }
        }
        return null;
    }

    public SNMPSecurityManager getSNMPSecurityManager() {
        return this.snmpSecurityManager;
    }

    public void addSNMPTableRowForMBeanInstance(String string, MBeanServerConnection mBeanServerConnection, ObjectName objectName, Map map) throws SNMPAgentToolkitException {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Adding table row " + string + " for " + objectName);
        }
        try {
            SnmpMibTableAdaptor snmpMibTableAdaptor = (SnmpMibTableAdaptor)this.snmpTables.get(string);
            if (snmpMibTableAdaptor != null) {
                MBeanInstanceTableRow mBeanInstanceTableRow = new MBeanInstanceTableRow(mBeanServerConnection, objectName, map);
                snmpMibTableAdaptor.addRow((SnmpMibTableAdaptor.Row)mBeanInstanceTableRow);
            } else if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Did not find SnmpMibTableAdaptor for " + string + " and MBean " + objectName);
            }
        }
        catch (Exception exception) {
            throw new SNMPAgentToolkitException((Throwable)exception);
        }
    }

    public void deleteSNMPTableRowForMBeanInstance(String string, ObjectName objectName) throws SNMPAgentToolkitException {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Deleting row " + string + " for objectName " + objectName);
        }
        try {
            SnmpMibTableAdaptor snmpMibTableAdaptor = (SnmpMibTableAdaptor)this.snmpTables.get(string);
            if (snmpMibTableAdaptor != null) {
                String string2 = MBeanInstanceTableRow.computeIndex(objectName.toString());
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Deleting row for index " + string2);
                }
                snmpMibTableAdaptor.removeRow(new String[]{string2});
            }
        }
        catch (Exception exception) {
            throw new SNMPAgentToolkitException((Throwable)exception);
        }
    }

    public void setCommunityBasedAccessEnabled(boolean bl) throws SNMPAgentToolkitException {
        AppAcm appAcm = (AppAcm)this.snmpAgent.getAccessControlModel();
        WLSAccessController wLSAccessController = (WLSAccessController)appAcm.getAccessController();
        wLSAccessController.setCommunityBasedAccessEnabled(bl);
    }

    public void setSNMPCommunity(String string, String string2) throws SNMPAgentToolkitException {
        AppAcm appAcm = (AppAcm)this.snmpAgent.getAccessControlModel();
        WLSAccessController wLSAccessController = (WLSAccessController)appAcm.getAccessController();
        wLSAccessController.setCommunity(string);
    }

    public SNMPSubAgentX createSNMPSubAgentX(String string, String string2) throws SNMPAgentToolkitException {
        MBeanServerSubAgentXImpl mBeanServerSubAgentXImpl = new MBeanServerSubAgentXImpl(this.masterAgentXHost, this.masterAgentXPort, string, string2);
        this.subAgents.put(string, mBeanServerSubAgentXImpl);
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Created subagent " + string);
        }
        return mBeanServerSubAgentXImpl;
    }
}

