/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.agent.SnmpAgent;
import monfox.toolkit.snmp.agent.SnmpMib;
import monfox.toolkit.snmp.agent.SnmpMibLeaf;
import monfox.toolkit.snmp.agent.SnmpMibNode;
import monfox.toolkit.snmp.agent.SnmpMibTableRow;
import monfox.toolkit.snmp.agent.ext.acm.AppAcm;
import monfox.toolkit.snmp.engine.SnmpEngineID;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.monfox.MBeanInstanceTableRow;
import weblogic.diagnostics.snmp.agent.monfox.WLSSecurityExtension;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeanservers.SecurityUtil;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public class WLSAccessController
implements AppAcm.AccessController {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final WLSAccessController SINGLETON = new WLSAccessController();
    private String community = "";
    private boolean communityBasedAccessEnabled = true;
    private SnmpEngineID snmpEngineId;
    private Set validContextNames = new HashSet();
    private int accessFailureCount;

    public static WLSAccessController getInstance() {
        return SINGLETON;
    }

    private WLSAccessController() {
        if (ManagementService.getRuntimeAccess(KERNEL_ID).isAdminServer()) {
            ServerMBean[] serverMBeanArray = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getServers();
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                this.validContextNames.add(serverMBeanArray[i].getName());
            }
            this.validContextNames.add(ManagementService.getRuntimeAccess(KERNEL_ID).getDomainName());
        }
    }

    public boolean checkAccess(SnmpAgent snmpAgent, String string, int n, int n2, boolean bl, String string2) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLSAccessController: [" + string + "," + n + "," + n2 + "," + bl + "," + string2 + "]");
        }
        if (!this.isAccessAllowed(bl, n, n2, string)) {
            ++this.accessFailureCount;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Access failed");
            }
            return false;
        }
        return true;
    }

    public boolean checkAccess(SnmpAgent snmpAgent, String string, int n, int n2, boolean bl, String string2, SnmpOid snmpOid, String string3, SnmpOid snmpOid2) {
        Object object;
        SnmpMibLeaf snmpMibLeaf;
        SnmpMibTableRow snmpMibTableRow;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLSAccessController: [" + string + "," + n + "," + n2 + "," + bl + "," + string2 + "," + snmpOid + "," + string3 + "," + snmpOid2 + "," + "]");
        }
        if (!this.isAccessAllowed(bl, n, n2, string)) {
            ++this.accessFailureCount;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Access failed");
            }
            return false;
        }
        if (n <= 2 && this.communityBasedAccessEnabled) {
            return true;
        }
        SnmpMib snmpMib = snmpAgent.getMib();
        SnmpMibNode snmpMibNode = snmpMib.get(snmpOid2);
        if (snmpMibNode != null && snmpMibNode instanceof SnmpMibLeaf && (snmpMibTableRow = (snmpMibLeaf = (SnmpMibLeaf)snmpMibNode).getRow()) != null && (object = snmpMibTableRow.getUserObject()) instanceof MBeanInstanceTableRow) {
            boolean bl2;
            MBeanInstanceTableRow mBeanInstanceTableRow = (MBeanInstanceTableRow)((Object)object);
            try {
                String string4 = mBeanInstanceTableRow.getAttributeName(string3);
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Checking access for attribute " + string4);
                }
                bl2 = string4 == null ? false : (string4.equals("Index") || string4.equals("ObjectName") ? true : this.isMBeanAccessAllowed(string, mBeanInstanceTableRow.getObjectName(), string4));
            }
            catch (Exception exception) {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Exception checking MBean access", (Throwable)exception);
                }
                bl2 = false;
            }
            if (!bl2) {
                ++this.accessFailureCount;
            }
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("MBean access check = " + bl2);
            }
            return bl2;
        }
        return true;
    }

    private boolean isMBeanAccessAllowed(String string, final ObjectName objectName, final String string2) throws Exception {
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject authenticatedSubject = principalAuthenticator.impersonateIdentity(string, null);
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    boolean bl = SecurityUtil.isGetAccessAllowed(2, objectName, string2);
                    return new Boolean(bl);
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Returned object is " + object + " for user_name " + string + " object_name " + objectName + "attribute_name " + string2);
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        return false;
    }

    private boolean isAccessAllowed(boolean bl, int n, int n2, String string) {
        int n3;
        String string2;
        if (bl) {
            return false;
        }
        if (n == 3) {
            string2 = WLSSecurityExtension.getInstance().getUserInfo(string, this.snmpEngineId);
            if (string2 == null) {
                return false;
            }
            n3 = this.isAuthSecurityLevel(string2.getSecLevel()) ? 1 : 0;
            boolean bl2 = this.isAuthSecurityLevel(n2);
            if (n3 != 0 && !bl2) {
                return false;
            }
        }
        if (n <= 2 && !this.communityBasedAccessEnabled) {
            return false;
        }
        string2 = string;
        n3 = string.indexOf("@");
        if (n3 > 0) {
            String string3;
            string2 = string.substring(0, n3);
            String string4 = string3 = n3 < string.length() - 1 ? string.substring(n3 + 1) : "";
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Context Name = " + string3);
            }
            String string5 = string3 = string3 == null ? "" : string3;
            if (!this.validContextNames.contains(string3)) {
                String string6 = "Invalid Context Name " + string3;
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug(string6);
                }
                throw new IllegalArgumentException(string6);
            }
        }
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Input community = " + string2);
        }
        return n > 2 || string2.equals(this.community);
    }

    private boolean isAuthSecurityLevel(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    String getCommunity() {
        return this.community;
    }

    void setCommunity(String string) {
        this.community = string;
    }

    boolean isCommunityBasedAccessEnabled() {
        return this.communityBasedAccessEnabled;
    }

    void setCommunityBasedAccessEnabled(boolean bl) {
        this.communityBasedAccessEnabled = bl;
    }

    void setSnmpEngineId(SnmpEngineID snmpEngineID) {
        this.snmpEngineId = snmpEngineID;
    }

    public int getFailedAuthorizationCount() {
        return this.accessFailureCount;
    }
}

