/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.security.AccessController;
import monfox.toolkit.snmp.Snmp;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.agent.ext.audit.SnmpAuditTrailLogger;
import monfox.toolkit.snmp.engine.SnmpPDU;
import monfox.toolkit.snmp.v3.usm.USMUser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.Auditor;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.AuditEvent;
import weblogic.security.spi.AuditSeverity;

public final class WLSAuditTrailLogger
implements SnmpAuditTrailLogger {
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final String SNMP_ERROR_REPORT = "SNMP_ERROR_REPORT";
    private static final String SNMP_ERROR_RESPONSE = "SNMP_ERROR_RESPONSE";
    private static final String SNMP_OBJECT_ACCESS = "SNMP_OBJECT_ACCESS";
    private static final String SNMP_AUTH_OPERATION = "SNMP_AUTH_OPERATION";
    private static final String SNMP_PRIV_OPERATION = "SNMP_PRIV_OPERATION";
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String EVENT_TYPE_ATTR = "EVENT_TYPE";
    private static final String SUBJECT_ATTR = "Subject";
    private static final String SEVERITY_ATTR = "Severity";
    private static final String VARBIND_ATTR = "Variables";
    private static final String VERSION_ATTR = "SnmpV";
    private static final String CRYPT_ATTR = "Crypt-Op";
    private static final String ENCRYPT_OP = "Encrypt";
    private static final String DECRYPT_OP = "Decrypt";
    private static final String PROTOCOL_ATTR = "Protocol";
    private static final String INCOMING_ATTR = "Incoming";
    private static final String MSGTYPE_ATTR = "MsgType";
    private static final String OBJNAME_ATTR = "Object";
    private static final String INSTANCE_ATTR = "Instance";
    private static final String OBJVAL_ATTR = "Value";
    private static final String ERRORSTATUS_ATTR = "Error-Status";
    private static final String ERRORINDEX_ATTR = "Error-Index";
    private int authFailureCount;
    private int privFailureCount;
    private Auditor auditor = null;
    private static WLSAuditTrailLogger singleton;

    private WLSAuditTrailLogger() {
        String string = "weblogicDEFAULT";
        this.auditor = (Auditor)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUDIT);
    }

    public static synchronized WLSAuditTrailLogger getInstance() {
        if (singleton == null) {
            singleton = new WLSAuditTrailLogger();
        }
        return singleton;
    }

    private void logEvent(SnmpBaseAuditEvent snmpBaseAuditEvent) {
        if (this.auditor != null) {
            this.auditor.writeEvent((AuditEvent)snmpBaseAuditEvent);
        }
    }

    private String algToString(int n) {
        switch (n) {
            case 0: {
                return "MD5";
            }
            case 1: {
                return "SHA";
            }
            case 2: {
                return "DES";
            }
            case 4: {
                return "AES128";
            }
            case 5: {
                return "AES192";
            }
            case 6: {
                return "AES256";
            }
        }
        return "Unknown:" + n;
    }

    public void logPrivOperation(String string, int n, int n2, int n3, int n4) {
        if (n4 != 1) {
            ++this.privFailureCount;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("privFailureCount: " + this.privFailureCount + ", [" + string + ", " + Snmp.versionToString((int)n) + ", " + n2 + ", " + USMUser.PrivProtocolToString((int)n3) + "]");
            }
        }
        this.logEvent(new SnmpPrivOperationEvent(string, n, n2, n3, n4));
    }

    public void logAuthOperation(String string, int n, int n2, int n3, int n4) {
        if (n4 != 1) {
            ++this.authFailureCount;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("authFailureCount: " + this.authFailureCount + ", [" + string + ", " + Snmp.versionToString((int)n) + ", " + n2 + ", " + USMUser.AuthProtocolToString((int)n3) + "]");
            }
        }
        this.logEvent(new SnmpAuthOperationEvent(string, n, n2, n3, n4));
    }

    public void logObjectAccess(String string, int n, int n2, String string2, SnmpOid snmpOid, String string3) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("log object access, version: " + Snmp.versionToString((int)n) + ", msg_type: " + SnmpPDU.typeToString((int)n2) + ", [" + string2 + ", " + string3 + "]");
        }
        this.logEvent(new SnmpObjectAccessEvent(string, n, n2, string2, snmpOid, string3));
    }

    public void logErrorResponse(String string, int n, int n2, SnmpVarBindList snmpVarBindList, int n3, int n4) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("log error response, name: " + string + ", version: " + Snmp.versionToString((int)n) + ", msg_type: " + SnmpPDU.typeToString((int)n2) + ", error status: " + Snmp.errorStatusToString((int)n3) + ", error index: " + n4);
        }
        this.logEvent(new SnmpErrorResponseEvent(string, n, n2, snmpVarBindList, n3, n4));
    }

    public void logErrorReport(String string, SnmpVarBindList snmpVarBindList) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("log error report, name: " + string + ", var bindings: " + snmpVarBindList.toString());
        }
        this.logEvent(new SnmpErrorReportAuditEvent(string, snmpVarBindList));
    }

    public int getFailedAuthenticationCount() {
        return this.authFailureCount;
    }

    public int getFailedEncryptionCount() {
        return this.privFailureCount;
    }

    class SnmpErrorReportAuditEvent
    extends SnmpBaseAuditEvent {
        private SnmpVarBindList report_varbinds;

        SnmpErrorReportAuditEvent(String string, SnmpVarBindList snmpVarBindList) {
            super(WLSAuditTrailLogger.SNMP_ERROR_REPORT, AuditSeverity.ERROR, string);
            this.report_varbinds = snmpVarBindList;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.VARBIND_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.report_varbinds != null ? this.report_varbinds.toString() : "null");
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpErrorResponseEvent
    extends SnmpAuditEvent {
        private int msg_type;
        private SnmpVarBindList request_varbinds;
        private int error_status;
        private int error_index;

        SnmpErrorResponseEvent(String string, int n, int n2, SnmpVarBindList snmpVarBindList, int n3, int n4) {
            super(WLSAuditTrailLogger.SNMP_ERROR_RESPONSE, AuditSeverity.ERROR, string, n);
            this.msg_type = n2;
            this.request_varbinds = snmpVarBindList;
            this.error_status = n3;
            this.error_index = n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.MSGTYPE_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.msg_type);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.VARBIND_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.request_varbinds.toString());
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.ERRORSTATUS_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(Snmp.errorStatusToString((int)this.error_status));
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.ERRORINDEX_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.error_index);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpObjectAccessEvent
    extends SnmpAuditEvent {
        private int msg_type;
        private String object_name;
        private SnmpOid instance_or_index;
        private String object_value;

        SnmpObjectAccessEvent(String string, int n, int n2, String string2, SnmpOid snmpOid, String string3) {
            super(WLSAuditTrailLogger.SNMP_OBJECT_ACCESS, AuditSeverity.INFORMATION, string, n);
            this.msg_type = n2;
            this.object_name = string2;
            this.instance_or_index = snmpOid;
            this.object_value = string3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.MSGTYPE_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.msg_type);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.OBJNAME_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.object_name);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.INSTANCE_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.instance_or_index);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.OBJVAL_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.object_value);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpAuthOperationEvent
    extends SnmpAuditEvent {
        private int auth_type;
        private int auth_protocol;
        private int result;

        SnmpAuthOperationEvent(String string, int n, int n2, int n3, int n4) {
            super(WLSAuditTrailLogger.SNMP_AUTH_OPERATION, n4 == 1 ? AuditSeverity.SUCCESS : AuditSeverity.FAILURE, string, n);
            this.auth_type = n2;
            this.auth_protocol = n3;
            this.result = n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.INCOMING_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.auth_type == 1 ? WLSAuditTrailLogger.YES : WLSAuditTrailLogger.NO);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.PROTOCOL_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(WLSAuditTrailLogger.this.algToString(this.auth_protocol));
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpPrivOperationEvent
    extends SnmpAuditEvent {
        private int crypt_type;
        private int priv_protocol;
        private int result;

        SnmpPrivOperationEvent(String string, int n, int n2, int n3, int n4) {
            super(WLSAuditTrailLogger.SNMP_PRIV_OPERATION, n4 == 1 ? AuditSeverity.SUCCESS : AuditSeverity.FAILURE, string, n);
            this.crypt_type = n2;
            this.priv_protocol = n3;
            this.result = n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.CRYPT_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.crypt_type == 2 ? WLSAuditTrailLogger.ENCRYPT_OP : WLSAuditTrailLogger.DECRYPT_OP);
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.PROTOCOL_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(WLSAuditTrailLogger.this.algToString(this.priv_protocol));
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpAuditEvent
    extends SnmpBaseAuditEvent {
        private int snmp_version;

        public SnmpAuditEvent(String string, AuditSeverity auditSeverity, String string2, int n) {
            super(string, auditSeverity, string2);
            this.snmp_version = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            super.writeAttributes(stringBuffer);
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.VERSION_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.snmp_version);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    class SnmpBaseAuditEvent
    implements AuditEvent {
        private String eventType;
        private AuditSeverity severity;
        private String sec_name;

        public SnmpBaseAuditEvent(String string, AuditSeverity auditSeverity, String string2) {
            this.eventType = string;
            this.severity = auditSeverity;
            this.sec_name = string2;
        }

        public String getEventType() {
            return this.eventType;
        }

        public Exception getFailureException() {
            return null;
        }

        public AuditSeverity getSeverity() {
            return this.severity;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            this.writeAttributes(stringBuffer);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        protected void writeAttributes(StringBuffer stringBuffer) {
            stringBuffer.append("<");
            stringBuffer.append(WLSAuditTrailLogger.EVENT_TYPE_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.eventType);
            stringBuffer.append("><");
            stringBuffer.append(WLSAuditTrailLogger.SUBJECT_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.sec_name);
            stringBuffer.append("><");
            stringBuffer.append(WLSAuditTrailLogger.SEVERITY_ATTR);
            stringBuffer.append(" = ");
            stringBuffer.append(this.severity.getSeverityString());
            stringBuffer.append(">");
        }
    }
}

