/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.spi.security.PasswordCredential;
import monfox.toolkit.snmp.engine.SnmpEngineID;
import monfox.toolkit.snmp.v3.usm.ext.UsmUserSecurityExtension;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.monfox.SecurityUtil;
import weblogic.diagnostics.snmp.agent.monfox.SnmpResource;
import weblogic.diagnostics.snmp.agent.monfox.WLSUserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RemoteResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public class WLSSecurityExtension
implements UsmUserSecurityExtension,
TimerListener {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final long DEFAULT_CACHE_FLUSH_PERIOD = 300000L;
    private static WLSSecurityExtension SINGLETON;
    private CredentialManager credentialManager;
    private SnmpResource authResource = SnmpResource.getAuthenticationResource();
    private SnmpResource privResource = SnmpResource.getPrivacyResource();
    private Timer cacheFlushTimer;
    private long cacheFlushPeriod;
    private RemoteResource testResource = new RemoteResource(null, null, null, null, "SNMP_AUTH");
    private ConcurrentHashMap userInfos = new ConcurrentHashMap();
    private int securityLevel = 0;
    private int authProtocol = 0;
    private int privProtocol = 3;

    public static synchronized WLSSecurityExtension getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new WLSSecurityExtension();
        }
        return SINGLETON;
    }

    private WLSSecurityExtension() {
        this.credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        this.setLocalizedKeyCacheInvalidationInterval(300000L);
    }

    private byte[] getPwd(String string, boolean bl) {
        SnmpResource snmpResource = bl ? this.authResource : this.privResource;
        Object[] objectArray = this.credentialManager.getCredentials(KERNEL_ID, string, (Resource)snmpResource, null, "weblogic.UserPassword");
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof PasswordCredential)) continue;
            String string2 = new String(((PasswordCredential)objectArray[i]).getPassword());
            return string2.getBytes();
        }
        return null;
    }

    private boolean isValidUserInfo(WLSUserInfo wLSUserInfo) {
        return this.getMonfoxSecurityLevel() == wLSUserInfo.getSecLevel() && this.getMonfoxAuthProtocol() == wLSUserInfo.getAuthProtocol() && this.getMonfoxPrivProtocol() == wLSUserInfo.getPrivProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLSUserInfo getCachedUserInfo(String string, SnmpEngineID snmpEngineID) {
        WLSUserInfo wLSUserInfo = null;
        ConcurrentHashMap concurrentHashMap = this.userInfos;
        synchronized (concurrentHashMap) {
            HashMap hashMap;
            if (this.userInfos.containsKey(string) && (hashMap = (HashMap)this.userInfos.get(string)) != null && hashMap.containsKey(snmpEngineID)) {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Found cached UserInfo for user " + string + ", engineID: " + snmpEngineID);
                }
                if (!this.isValidUserInfo(wLSUserInfo = (WLSUserInfo)hashMap.get(snmpEngineID))) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("Cached UserInfo for user " + string + ", engineID " + snmpEngineID + " is invalid, removing from cache");
                    }
                    hashMap.remove(snmpEngineID);
                    if (hashMap.size() == 0) {
                        this.userInfos.remove(string);
                    }
                    wLSUserInfo = null;
                }
            }
        }
        return wLSUserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLSUserInfo addUserInfoToCache(String string, SnmpEngineID snmpEngineID) {
        WLSUserInfo wLSUserInfo = null;
        try {
            wLSUserInfo = this.createUserInfo(string, snmpEngineID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        HashMap hashMap = null;
        ConcurrentHashMap concurrentHashMap = this.userInfos;
        synchronized (concurrentHashMap) {
            if (this.userInfos.containsKey(string)) {
                hashMap = (HashMap)this.userInfos.get(string);
            } else {
                hashMap = new HashMap();
                this.userInfos.put(string, hashMap);
            }
            hashMap.put(snmpEngineID, wLSUserInfo);
        }
        return wLSUserInfo;
    }

    public UsmUserSecurityExtension.UserInfo getUserInfo(String string, SnmpEngineID snmpEngineID) {
        WLSUserInfo wLSUserInfo = this.getCachedUserInfo(string, snmpEngineID);
        if (wLSUserInfo == null) {
            wLSUserInfo = this.addUserInfoToCache(string, snmpEngineID);
        }
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Returning UserInfo for " + string + ", engineID + " + snmpEngineID.toString() + ", nonExistentUser=" + wLSUserInfo.isNonExistentUser());
        }
        if (wLSUserInfo.isNonExistentUser()) {
            wLSUserInfo = null;
        }
        return wLSUserInfo;
    }

    private WLSUserInfo createUserInfo(String string, SnmpEngineID snmpEngineID) throws NoSuchAlgorithmException {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Creating UserInfo for " + string);
        }
        byte[] byArray = this.getPwd(string, true);
        byte[] byArray2 = this.getPwd(string, false);
        boolean bl = byArray == null;
        WLSUserInfo wLSUserInfo = new WLSUserInfo(snmpEngineID, string, this.getMonfoxSecurityLevel(), this.getMonfoxAuthProtocol(), this.getMonfoxPrivProtocol(), byArray, byArray2, bl);
        this.clearBuffer(byArray);
        this.clearBuffer(byArray2);
        return wLSUserInfo;
    }

    private void clearBuffer(byte[] byArray) {
        int n = byArray != null ? byArray.length : 0;
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
        }
    }

    int getAuthProtocol() {
        return this.authProtocol;
    }

    void setAuthProtocol(int n) {
        this.authProtocol = n;
    }

    int getPrivProtocol() {
        return this.privProtocol;
    }

    void setPrivProtocol(int n) {
        this.privProtocol = n;
    }

    int getSecurityLevel() {
        return this.securityLevel;
    }

    void setSecurityLevel(int n) {
        this.securityLevel = n;
    }

    private int getMonfoxSecurityLevel() {
        return SecurityUtil.convertSNMPAgentToolkitSecurityLevel((int)this.securityLevel);
    }

    private int getMonfoxAuthProtocol() {
        switch (this.authProtocol) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private int getMonfoxPrivProtocol() {
        switch (this.privProtocol) {
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public synchronized void setLocalizedKeyCacheInvalidationInterval(long l) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLSSecurityExtension: Setting userInfo cache flush period = " + l);
        }
        if (l <= 0L) {
            return;
        }
        if (this.cacheFlushTimer != null) {
            this.cacheFlushTimer.cancel();
        }
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        TimerManager timerManager = timerManagerFactory.getDefaultTimerManager();
        this.cacheFlushTimer = timerManager.scheduleAtFixedRate((TimerListener)this, 0L, l);
        this.cacheFlushPeriod = l;
    }

    public long getLocalizedKeyCacheInvalidationInterval() {
        return this.cacheFlushPeriod;
    }

    public void timerExpired(Timer timer) {
        this.clearUserInfos();
    }

    public void clearUserInfos() {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLSSecurityExtension: Flushing user info cache");
        }
        this.userInfos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLocalizedKeyCache(String string) {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("WLSSecurityExtension: Flushing user info cache for " + string);
        }
        ConcurrentHashMap concurrentHashMap = this.userInfos;
        synchronized (concurrentHashMap) {
            this.userInfos.remove(string);
        }
    }
}

