/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import monfox.toolkit.snmp.agent.SnmpAgent;
import monfox.toolkit.snmp.agent.ext.acm.AppAcm;
import monfox.toolkit.snmp.agent.ext.audit.SnmpAuditTrailLogger;
import weblogic.diagnostics.snmp.agent.SNMPSecurityManager;
import weblogic.diagnostics.snmp.agent.monfox.WLSAccessController;
import weblogic.diagnostics.snmp.agent.monfox.WLSAuditTrailLogger;
import weblogic.diagnostics.snmp.agent.monfox.WLSSecurityExtension;

public class WLSSnmpSecurityManager
implements SNMPSecurityManager {
    private SnmpAgent snmpAgent;

    WLSSnmpSecurityManager(SnmpAgent snmpAgent) {
        this.snmpAgent = snmpAgent;
    }

    public int getFailedAuthenticationCount() {
        int n = 0;
        SnmpAuditTrailLogger snmpAuditTrailLogger = this.snmpAgent.getAuditTrailLogger();
        if (snmpAuditTrailLogger instanceof WLSAuditTrailLogger) {
            n = ((WLSAuditTrailLogger)snmpAuditTrailLogger).getFailedAuthenticationCount();
        }
        return n;
    }

    public int getFailedAuthorizationCount() {
        AppAcm appAcm = (AppAcm)this.snmpAgent.getAccessControlModel();
        WLSAccessController wLSAccessController = (WLSAccessController)appAcm.getAccessController();
        return wLSAccessController.getFailedAuthorizationCount();
    }

    public int getFailedEncryptionCount() {
        int n = 0;
        SnmpAuditTrailLogger snmpAuditTrailLogger = this.snmpAgent.getAuditTrailLogger();
        if (snmpAuditTrailLogger instanceof WLSAuditTrailLogger) {
            n = ((WLSAuditTrailLogger)snmpAuditTrailLogger).getFailedEncryptionCount();
        }
        return n;
    }

    public void invalidateLocalizedKeyCache(String string) {
        WLSSecurityExtension.getInstance().invalidateLocalizedKeyCache(string);
    }
}

