/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import monfox.toolkit.snmp.engine.SnmpBuffer;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.engine.TcpEntity;
import monfox.toolkit.snmp.engine.TransportEntity;
import monfox.toolkit.snmp.engine.TransportProvider;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPTransportProvider;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.muxer.MuxableSocketSNMP;
import weblogic.socket.MuxableSocket;

public class WLSTcpTransportProvider
extends TransportProvider
implements SNMPTransportProvider {
    private boolean isActive = true;
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPToolkit");

    public boolean isPushProvider() {
        return true;
    }

    public void initialize(TransportProvider.Params params) throws SnmpTransportException {
        super.initialize(params);
    }

    public int getTransportType() {
        return 2;
    }

    public void initialize(InetAddress inetAddress, int n) throws SnmpTransportException {
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void shutdown() throws SnmpTransportException {
        this.isActive = false;
    }

    public Object send(Object object, TransportEntity transportEntity) throws SnmpTransportException {
        if (!(transportEntity instanceof WLSTcpEntity)) {
            throw new SnmpTransportException("wrong transport provider type:" + transportEntity);
        }
        WLSTcpEntity wLSTcpEntity = (WLSTcpEntity)transportEntity;
        try {
            SnmpBuffer snmpBuffer;
            MuxableSocket muxableSocket = wLSTcpEntity.getDestinationSocket();
            if (muxableSocket == null) {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Creating outbound SNMP TCP connection to host " + wLSTcpEntity.getAddress().getHostAddress() + " on port " + wLSTcpEntity.getPort());
                }
                muxableSocket = MuxableSocketSNMP.createConnection(wLSTcpEntity.getAddress().getHostAddress(), wLSTcpEntity.getPort());
            }
            if (object instanceof SnmpBuffer) {
                snmpBuffer = (SnmpBuffer)object;
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Writing outgoing SNMP message, length " + snmpBuffer.length);
                }
            } else {
                throw new SnmpTransportException("unknown data class:" + object.getClass().getName());
            }
            OutputStream outputStream = muxableSocket.getSocket().getOutputStream();
            outputStream.write(snmpBuffer.data, snmpBuffer.offset, snmpBuffer.length);
        }
        catch (IOException iOException) {
            SNMPLogger.logTCPProviderSendException((Throwable)iOException);
        }
        return object;
    }

    public TransportEntity receive(SnmpBuffer snmpBuffer, boolean bl) throws SnmpTransportException {
        return null;
    }

    public static void log(String string) {
        System.out.println(new Date(System.currentTimeMillis()).toString() + ": " + string);
    }

    public void pushMessage(MuxableSocket muxableSocket, byte[] byArray) {
        SnmpBuffer snmpBuffer = new SnmpBuffer(byArray);
        WLSTcpEntity wLSTcpEntity = new WLSTcpEntity();
        wLSTcpEntity.setProvider(this);
        wLSTcpEntity.setDestinationSocket(muxableSocket);
        super.pushMessage((TransportEntity)wLSTcpEntity, snmpBuffer);
    }

    public int getType() {
        return 1;
    }

    private class WLSTcpEntity
    extends TcpEntity {
        private MuxableSocket destinationSocket;

        public WLSTcpEntity() {
        }

        public WLSTcpEntity(MuxableSocket muxableSocket) {
            this.destinationSocket = muxableSocket;
        }

        public MuxableSocket getDestinationSocket() {
            return this.destinationSocket;
        }

        public void setDestinationSocket(MuxableSocket muxableSocket) {
            this.destinationSocket = muxableSocket;
        }
    }

    public static class Params
    extends TransportProvider.Params {
        public Params() {
        }

        public Params(String string, int n) throws UnknownHostException {
            super(string == null ? null : InetAddress.getByName(string), n);
        }

        public Params(InetAddress inetAddress, int n) {
            super(inetAddress, n);
        }

        public int getTransportType() {
            return 2;
        }
    }
}

