/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.agent.monfox;

import java.security.NoSuchAlgorithmException;
import monfox.toolkit.snmp.engine.SnmpEngineID;
import monfox.toolkit.snmp.v3.usm.USMUtil;
import monfox.toolkit.snmp.v3.usm.ext.UsmUserSecurityExtension;
import weblogic.diagnostics.debug.DebugLogger;

public class WLSUserInfo
implements UsmUserSecurityExtension.UserInfo {
    private SnmpEngineID engineID;
    private String userName;
    private int secLevel;
    private int authProtocol;
    private int privProtocol;
    private byte[] localizedAuthKey;
    private byte[] localizedPrivKey;
    private boolean nonExistentUser;
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");

    public WLSUserInfo(SnmpEngineID snmpEngineID, String string, int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray3;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Creating WLSUserInfo: user_name=" + string + " sec_level=" + n + " auth_protocol=" + n2 + " priv_protocol=" + n3);
        }
        this.engineID = snmpEngineID;
        this.userName = string;
        this.secLevel = n;
        this.authProtocol = n2;
        this.privProtocol = n3;
        this.nonExistentUser = bl;
        if (byArray != null && byArray.length > 0) {
            byArray3 = USMUtil.generateKey((byte[])byArray, (int)n2);
            this.localizedAuthKey = USMUtil.localizeKey((byte[])byArray3, (byte[])snmpEngineID.toByteArray(), (int)n2);
        }
        if (byArray2 != null && byArray2.length > 0) {
            byArray3 = USMUtil.generateKey((byte[])byArray2, (int)n2);
            this.localizedPrivKey = USMUtil.localizeKey((byte[])byArray3, (byte[])snmpEngineID.toByteArray(), (int)n2);
        }
    }

    public String toString() {
        return this.userName;
    }

    public SnmpEngineID getEngineID() {
        return this.engineID;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getLocalizedAuthKey() {
        return this.localizedAuthKey;
    }

    public byte[] getLocalizedPrivKey() {
        return this.localizedPrivKey;
    }

    public int getAuthProtocol() {
        return this.authProtocol;
    }

    public int getPrivProtocol() {
        return this.privProtocol;
    }

    public int getSecLevel() {
        return this.secLevel;
    }

    public boolean isNonExistentUser() {
        return this.nonExistentUser;
    }
}

