/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.mib;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weblogic.diagnostics.snmp.mib.WLSMibMetadata;
import weblogic.diagnostics.snmp.mib.WLSMibMetadataException;

public class ConfigHelper {
    private static final String ATTR_CHANGE_RUNTIME_MBEANS = "DeploymentTaskRuntime,JTARuntime,JVMRuntime,ServerLifeCycleRuntime,ServerRuntime";
    private static final String ATTRCHANGERUNTIMEMBEANS = "DeploymentTaskRuntime,JTARuntime,JVMRuntime,ServerLifeCycleRuntime,ServerRuntime";
    private static Set allMBeanTypes = null;
    private static Set attrChangeMBeanTypes = null;
    private static boolean initialized = false;

    public static Set getMonitorMBeanTypes() throws WLSMibMetadataException {
        ConfigHelper.ensureInitialized();
        return allMBeanTypes;
    }

    public static Set getAttributeChangeMBeanTypes() throws WLSMibMetadataException {
        ConfigHelper.ensureInitialized();
        return attrChangeMBeanTypes;
    }

    private static void ensureInitialized() throws WLSMibMetadataException {
        if (!initialized) {
            WLSMibMetadata wLSMibMetadata = WLSMibMetadata.loadResource();
            Set set = wLSMibMetadata.wlsTypeNameToSNMPTableName.keySet();
            allMBeanTypes = new HashSet();
            attrChangeMBeanTypes = new HashSet();
            for (Object k : set) {
                String string = k.toString();
                string = string.replaceAll("[a-z]*\\.", "");
                if (!(string = string.substring(0, string.lastIndexOf("MBean"))).endsWith("Runtime")) {
                    attrChangeMBeanTypes.add(string);
                }
                allMBeanTypes.add(string);
            }
            String[] stringArray = "DeploymentTaskRuntime,JTARuntime,JVMRuntime,ServerLifeCycleRuntime,ServerRuntime".split(",");
            attrChangeMBeanTypes.addAll(Arrays.asList(stringArray));
            initialized = true;
        }
    }

    public static void validateMonitorMBeanType(String string) throws IllegalArgumentException {
    }

    public static boolean isValidRuntimeMBeanType(String string) {
        return false;
    }

    public static boolean isValidConfigMBeanType(String string) {
        return false;
    }

    public static void validateAttributeChangeMBeanType(String string) throws IllegalArgumentException {
    }

    public static void main(String[] stringArray) throws WLSMibMetadataException {
        System.out.println("AttributeChangeMBeanTypes=" + ConfigHelper.getAttributeChangeMBeanTypes());
        System.out.println("#####");
        System.out.println("MonitorMBeanTypes=" + ConfigHelper.getMonitorMBeanTypes());
    }
}

