/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.mib;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkit;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPUtil;
import weblogic.diagnostics.snmp.mib.MibConstants;
import weblogic.diagnostics.snmp.mib.WLSMibMetadata;
import weblogic.diagnostics.snmp.mib.WLSMibMetadataBuilder;
import weblogic.diagnostics.snmp.mib.WLSMibTableColumnsMetadata;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.provider.beaninfo.BeanInfoAccess;

public class MibGenerator
implements MibConstants {
    private static final boolean DEBUG = true;
    private static Set supportedPackages = new HashSet();
    private static Set excludedAttributes = new HashSet();
    private static Set ignoredAttributes = new HashSet();
    private static Set supportedClasses = new HashSet();
    private static final DebugLogger logger;
    private static final String ROOT_OID = ".1.3.6.1.4.1.140.625";
    private static final int INCREMENT = 5;
    private static final int DEFAULT_MIB_GEN_PORT = 1160;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String[] stringArray2;
        Object object2;
        if (stringArray.length < 2) {
            MibGenerator.printUsage();
            System.exit(1);
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = 1160;
        if (stringArray.length > 2) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        SNMPUtil.initializeTypeNamePrefixes((String[])SUBSYSTEM_PREFIXES);
        WLSMibMetadata wLSMibMetadata = WLSMibMetadata.loadResource();
        SNMPAgent sNMPAgent = new SNMPAgent();
        sNMPAgent.setUdpListenPort(n2);
        sNMPAgent.initialize();
        SNMPAgentToolkit sNMPAgentToolkit = sNMPAgent.getSNMPAgentToolkit();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String string2 = new String("" + calendar.get(1));
        if (calendar.get(2) + 1 < 10) {
            string2 = string2 + "0";
        }
        string2 = string2 + (calendar.get(2) + 1);
        if (calendar.get(5) < 10) {
            string2 = string2 + "0";
        }
        string2 = string2 + calendar.get(5);
        if (calendar.get(11) < 10) {
            string2 = string2 + "0";
        }
        string2 = string2 + calendar.get(11);
        if (calendar.get(12) < 10) {
            string2 = string2 + "0";
        }
        string2 = string2 + calendar.get(12);
        string2 = string2 + "Z";
        sNMPAgentToolkit.addModuleIdentityInfo(string2, "BEA Systems Inc.", "www.bea.com", "BEA", "BEA-WEBLOGIC-MIB", ROOT_OID, "wls");
        sNMPAgentToolkit.createSNMPMibTables("BEA-WEBLOGIC-MIB");
        BeanInfoAccess beanInfoAccess = ManagementServiceClient.getBeanInfoAccess();
        String[] stringArray3 = beanInfoAccess.getSubtypes(null);
        for (int i = 0; i < stringArray3.length; ++i) {
            Object object3;
            block17: {
                object2 = stringArray3[i];
                if (!((String)object2).endsWith("MBean")) {
                    logger.debug("Not supported " + (String)object2);
                    continue;
                }
                try {
                    stringArray2 = Class.forName((String)object2);
                    object = stringArray2.getPackage().getName();
                    if (!supportedPackages.contains(object)) {
                    }
                    break block17;
                }
                catch (Exception exception) {
                    logger.debug("Type not found", (Throwable)exception);
                }
                continue;
            }
            stringArray2 = beanInfoAccess.getSubtypes((String)object2);
            boolean bl = false;
            if (stringArray2.length > 1) {
                object3 = new ArrayList();
                Collections.addAll(object3, stringArray2);
                logger.debug("Found subtypes " + object3 + " for type " + (String)object2);
                bl = true;
            }
            logger.debug("Found type " + (String)object2);
            object3 = beanInfoAccess.getBeanInfoForInterface(stringArray3[i], false, null);
            Object object4 = object3.getBeanDescriptor().getValue("deprecated");
            if (object4 != null) {
                logger.debug("Deprecated type " + (String)object2 + " " + object4);
                continue;
            }
            Boolean bl2 = (Boolean)object3.getBeanDescriptor().getValue("abstract");
            if (bl2 != null && bl2.booleanValue()) {
                logger.debug("Abstract type " + (String)object2);
                continue;
            }
            Boolean bl3 = (Boolean)object3.getBeanDescriptor().getValue("exclude");
            if (bl3 != null && bl3.booleanValue()) {
                logger.debug("Excluded type " + (String)object2);
                continue;
            }
            String string3 = (String)object3.getBeanDescriptor().getValue("obsolete");
            if (string3 != null && string3.length() > 0) {
                logger.debug("Obsolete type " + (String)object2 + " " + string3);
                continue;
            }
            List list = MibGenerator.getPropertyDescriptorsForSNMP((String)object2, (BeanInfo)object3);
            String string4 = wLSMibMetadata.getSNMPTableName((String)object2);
            if (string4 == null && !bl) {
                logger.debug("Missing type from mib " + (String)object2);
                string4 = MibGenerator.getTableNameForType((String)object2);
                logger.debug("Defining table " + string4);
                String string5 = ".1.3.6.1.4.1.140.625." + n;
                n += 5;
                String string6 = object3.getBeanDescriptor().getShortDescription();
                string6 = SNMPUtil.stripHtmlTags((String)string6);
                logger.debug("Table desc for " + string4 + " = " + string6);
                sNMPAgentToolkit.createSNMPTable("BEA-WEBLOGIC-MIB", string4, string6, string5, list);
                continue;
            }
            MibGenerator.updateAttributesForType(sNMPAgentToolkit, wLSMibMetadata, string4, list);
        }
        String string7 = sNMPAgentToolkit.outputMIBModule("BEA-WEBLOGIC-MIB");
        object2 = new FileOutputStream(string);
        stringArray2 = new OutputStreamWriter((OutputStream)object2);
        object = new BufferedWriter((Writer)stringArray2);
        ((Writer)object).write(string7);
        ((BufferedWriter)object).flush();
        ((BufferedWriter)object).close();
    }

    private static void printUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("java weblogic.diagnostics.snmp.mib.MibGenerator <MIB filename> <Starting index for new tables> [port]");
        System.out.println(stringBuilder.toString());
    }

    private static void updateAttributesForType(SNMPAgentToolkit sNMPAgentToolkit, WLSMibMetadata wLSMibMetadata, String string, List list) throws SNMPAgentToolkitException {
        String string2;
        WLSMibTableColumnsMetadata wLSMibTableColumnsMetadata = wLSMibMetadata.getColumnsMetadataForSNMPTable(string);
        if (wLSMibTableColumnsMetadata == null) {
            logger.debug("No metadata found for table " + string);
            return;
        }
        Map map = wLSMibTableColumnsMetadata.getAttributeColumnMap();
        Map map2 = wLSMibTableColumnsMetadata.getAttributeColumnMap();
        for (Object object : list) {
            Object object2 = ((FeatureDescriptor)object).getName();
            if (map.containsKey(object2)) continue;
            string2 = SNMPUtil.getColumnNameForAttribute((String)string, (String)object2);
            logger.debug("Missing attribute " + (String)object2 + " snmp col name = " + string2);
            if (string2.length() > 64) {
                logger.debug("SNMP Column name " + string2 + " length is larger than 64 characters, looking for an OVERRIDEN name");
                if (WLSMibMetadataBuilder.isColumnNameOverridden(string2)) {
                    string2 = WLSMibMetadataBuilder.getColumnNameOverride(string2);
                } else {
                    System.out.println("Length of SNMP attribute " + string2 + " is greater than 64 characters in violation of SNMP standard. Please add shorter name override to the WLSMibMetadata.OVERRIDES map");
                    System.exit(1);
                }
            }
            String string3 = SNMPUtil.stripHtmlTags((String)((String)((FeatureDescriptor)object).getValue("description")));
            sNMPAgentToolkit.createSNMPColumn(string, string2, ((PropertyDescriptor)object).getPropertyType(), string3);
        }
        HashSet hashSet = new HashSet();
        for (Object object2 : list) {
            string2 = ((FeatureDescriptor)object2).getName();
            hashSet.add(string2);
        }
        for (Object object2 : map.keySet()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Evaluating removal of " + (String)object2 + " from " + string);
            }
            if (hashSet.contains(object2) || ignoredAttributes.contains(object2)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Removing column " + map.get(object2) + " from " + string);
            }
            if (WLSMibMetadataBuilder.isColumnNameOverridden(string2 = (String)map.get(object2))) {
                string2 = WLSMibMetadataBuilder.getColumnNameOverride(string2);
            }
            sNMPAgentToolkit.removeSNMPColumn(string, string2);
        }
        sNMPAgentToolkit.completeTableEdit(string);
    }

    private static String getTableNameForType(String string) {
        return SNMPUtil.convertTypeNameToSNMPTableName((String)string);
    }

    private static List getPropertyDescriptorsForSNMP(String string, BeanInfo beanInfo) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        logger.debug("Discovering properties for " + string);
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (MibGenerator.isClassSupported(clazz)) {
                logger.debug("Found property " + propertyDescriptor.getName());
                Boolean bl = (Boolean)propertyDescriptor.getValue("encrypted");
                if (bl != null && bl.equals(Boolean.TRUE)) {
                    logger.debug("Found encrypted property " + propertyDescriptor.getName());
                    continue;
                }
                bl = (Boolean)propertyDescriptor.getValue("exclude");
                if (bl != null && bl.equals(Boolean.TRUE)) {
                    logger.debug("Found excluded property " + propertyDescriptor.getName());
                    continue;
                }
                Object object = propertyDescriptor.getValue("obsolete");
                if (object != null) {
                    logger.debug("Found obsolete property " + propertyDescriptor.getName() + " for " + string);
                    continue;
                }
                bl = (Boolean)propertyDescriptor.getValue("internal");
                if (bl != null && bl.equals(Boolean.TRUE)) {
                    logger.debug("Found internal property " + propertyDescriptor.getName());
                    continue;
                }
                String string2 = propertyDescriptor.getName();
                if (excludedAttributes.contains(string2)) continue;
                arrayList.add(propertyDescriptor);
                continue;
            }
            logger.debug("Ignoring property " + propertyDescriptor.getName() + " of type " + clazz);
        }
        return arrayList;
    }

    private static boolean isClassSupported(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType() == String.class;
        }
        return supportedClasses.contains(clazz);
    }

    static {
        supportedPackages.add("weblogic.management.configuration");
        supportedPackages.add("weblogic.management.runtime");
        excludedAttributes.add("Notes");
        ignoredAttributes.add("Index");
        ignoredAttributes.add("Parent");
        ignoredAttributes.add("ObjectName");
        supportedClasses.add(Character.class);
        supportedClasses.add(String.class);
        supportedClasses.add(Boolean.class);
        supportedClasses.add(Byte.class);
        supportedClasses.add(Short.class);
        supportedClasses.add(Integer.class);
        supportedClasses.add(Long.class);
        supportedClasses.add(Float.class);
        supportedClasses.add(Double.class);
        supportedClasses.add(Date.class);
        logger = DebugLogger.getDebugLogger((String)"DebugSNMPMib");
    }
}

