/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.mib;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.snmp.mib.MibConstants;
import weblogic.diagnostics.snmp.mib.WLSMibMetadataException;
import weblogic.diagnostics.snmp.mib.WLSMibTableColumnsMetadata;
import weblogic.utils.PlatformConstants;

public class WLSMibMetadata
implements Serializable,
MibConstants {
    private static final long serialVersionUID = -2396017281810551450L;
    Map snmpTableNameToWLSTypeName = new HashMap();
    Map wlsTypeNameToSNMPTableName = new HashMap();
    Map snmpTableNameToColumns = new HashMap();
    Map wlsTypeNameToColumns = new HashMap();

    public static WLSMibMetadata loadResource() throws WLSMibMetadataException {
        InputStream inputStream = WLSMibMetadata.class.getResourceAsStream("WLSMibMetadata.dat");
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Loaded " + object);
            }
            return (WLSMibMetadata)object;
        }
        catch (Exception exception) {
            throw new WLSMibMetadataException(exception);
        }
    }

    public String getSNMPTableName(String string) {
        return (String)this.wlsTypeNameToSNMPTableName.get(string);
    }

    public String getWLSTypeName(String string) {
        return (String)this.snmpTableNameToWLSTypeName.get(string);
    }

    public WLSMibTableColumnsMetadata getColumnsMetadataForSNMPTable(String string) {
        return (WLSMibTableColumnsMetadata)this.snmpTableNameToColumns.get(string);
    }

    public WLSMibTableColumnsMetadata getColumnsMetadataForWLSType(String string) {
        return (WLSMibTableColumnsMetadata)this.wlsTypeNameToColumns.get(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("snmpTableNameToWLSTypeName = " + this.snmpTableNameToWLSTypeName);
        stringBuilder.append(PlatformConstants.EOL);
        stringBuilder.append("wlsTypeNameToSNMPTableName = " + this.wlsTypeNameToSNMPTableName);
        stringBuilder.append(PlatformConstants.EOL);
        stringBuilder.append("snmpTableNameToColumns = " + this.snmpTableNameToColumns);
        stringBuilder.append(PlatformConstants.EOL);
        stringBuilder.append("wlsTypeNameToColumns = " + this.wlsTypeNameToColumns);
        stringBuilder.append(PlatformConstants.EOL);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws WLSMibMetadataException {
        WLSMibMetadata wLSMibMetadata = WLSMibMetadata.loadResource();
        System.out.println("Loaded MIB metadata ...");
        System.out.println(wLSMibMetadata);
    }
}

