/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.mib;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.mib.MibConstants;
import weblogic.diagnostics.snmp.mib.SNMPExtensionProviderBuildPlugin;
import weblogic.diagnostics.snmp.mib.WLSMibMetadata;
import weblogic.diagnostics.snmp.mib.WLSMibMetadataException;
import weblogic.diagnostics.snmp.mib.WLSMibTableColumnsMetadata;
import weblogic.i18n.logging.NonCatalogLogger;

public class WLSMibMetadataBuilder
implements MibConstants {
    private static final NonCatalogLogger LOGGER = new NonCatalogLogger("WLSMibMetadataBuilder");
    private static final int DEFAULT_MIB_METADATA_BUILDER_PORT = 1260;

    public static void main(String[] stringArray) throws SNMPAgentToolkitException, WLSMibMetadataException {
        String string;
        SNMPAgent sNMPAgent = new SNMPAgent();
        int n = stringArray.length;
        if (n > 0) {
            sNMPAgent.setMibBasePath(stringArray[0]);
        }
        if (n > 1) {
            sNMPAgent.setMibModules(stringArray[1]);
        }
        if (n > 2) {
            sNMPAgent.setRootOidNode(stringArray[2]);
        }
        SNMPExtensionProviderBuildPlugin sNMPExtensionProviderBuildPlugin = null;
        if (n > 3) {
            string = stringArray[3];
            try {
                Class<?> clazz = Class.forName(string);
                sNMPExtensionProviderBuildPlugin = (SNMPExtensionProviderBuildPlugin)clazz.newInstance();
            }
            catch (Exception exception) {
                LOGGER.error("Invalid build plugin class: " + string, (Throwable)exception);
            }
        }
        string = "WLSMibMetadata.dat";
        if (n > 4) {
            string = stringArray[4];
        }
        int n2 = 1260;
        if (n > 5) {
            n2 = Integer.parseInt(stringArray[5]);
        }
        if (n2 > 0) {
            sNMPAgent.setUdpListenPort(n2);
        }
        sNMPAgent.initialize();
        Map map = sNMPAgent.getSNMPTablesMetadata();
        WLSMibMetadata wLSMibMetadata = new WLSMibMetadata();
        for (String string2 : map.keySet()) {
            String[] stringArray2 = (String[])map.get(string2);
            WLSMibMetadataBuilder.buildTypeInfo(sNMPExtensionProviderBuildPlugin, wLSMibMetadata, string2, stringArray2);
        }
        try {
            WLSMibMetadataBuilder.saveToDisk(wLSMibMetadata, string);
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Writing to disk " + wLSMibMetadata);
            }
        }
        catch (Throwable throwable) {
            throw new WLSMibMetadataException(throwable);
        }
    }

    private static void buildTypeInfo(SNMPExtensionProviderBuildPlugin sNMPExtensionProviderBuildPlugin, WLSMibMetadata wLSMibMetadata, String string, String[] stringArray) throws WLSMibMetadataException {
        Serializable serializable;
        int n = string.lastIndexOf("Table");
        String string2 = null;
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Processing snmp table " + string);
        }
        String string3 = string.substring(0, n);
        if (Initializer.OUTLIERS.containsKey(string3)) {
            string2 = (String)Initializer.OUTLIERS.get(string3);
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Found WLS type " + string2 + " for " + string);
            }
        } else {
            char c;
            serializable = new ArrayList();
            Collections.addAll(serializable, (Object[])SUBSYSTEM_PREFIXES);
            if (string3.startsWith("wlssnmp")) {
                string3 = string3.substring(3);
            }
            String string4 = WLSMibMetadataBuilder.findSubsystemPrefix((List)((Object)serializable), string3);
            int n2 = string4.length();
            String string5 = string4;
            String string6 = string4.toUpperCase();
            if (string3.length() > n2 && Character.isLowerCase(c = string3.charAt(n2))) {
                string5 = string5 + c;
                char c2 = Character.toUpperCase(c);
                string6 = string6 + c2;
            }
            String string7 = string3.replaceFirst(string5, string6);
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Processed cheese = " + string7);
            }
            if ((string2 = WLSMibMetadataBuilder.getFullyQualifiedClassName(string7 + "MBean")) == null) {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Using build plugin to fine type for " + string);
                }
                string2 = sNMPExtensionProviderBuildPlugin.getFullyQualifiedClassName(string7);
            }
            if (string2 == null) {
                throw new WLSMibMetadataException("Did not find type for " + string);
            }
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Found type " + string2 + " for " + string);
            }
        }
        serializable = WLSMibMetadataBuilder.getColumnsMetadata(string3, stringArray);
        WLSMibMetadataBuilder.validateAttributes(string2, ((WLSMibTableColumnsMetadata)serializable).getAttributeNames());
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Validated WLS type " + string2 + " for " + string);
        }
        wLSMibMetadata.snmpTableNameToWLSTypeName.put(string, string2);
        wLSMibMetadata.wlsTypeNameToSNMPTableName.put(string2, string);
        wLSMibMetadata.snmpTableNameToColumns.put(string, serializable);
        wLSMibMetadata.wlsTypeNameToColumns.put(string2, serializable);
    }

    private static void saveToDisk(WLSMibMetadata wLSMibMetadata, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(wLSMibMetadata);
        LOGGER.notice("Generated MIB metadata to " + string);
    }

    private static void validateAttributes(String string, Iterator iterator) throws IllegalArgumentException {
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Validating type " + string);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Validating attribute " + string + "." + string2);
            }
            Method method = null;
            try {
                method = clazz.getMethod("get" + string2, new Class[0]);
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Found getter " + method.getName() + " on type " + string);
                }
                if (method == null) continue;
                Class<?> clazz2 = method.getReturnType();
                if (!DEBUG_LOGGER.isDebugEnabled()) continue;
                DEBUG_LOGGER.debug("Attribute" + string + "." + string2 + " return type = " + clazz2);
            }
            catch (Exception exception) {
                try {
                    method = clazz.getMethod("is" + string2, new Class[0]);
                    if (!DEBUG_LOGGER.isDebugEnabled()) continue;
                    DEBUG_LOGGER.debug("Found getter " + method.getName() + " on type " + string);
                }
                catch (Exception exception2) {
                    System.err.println("No attribute " + string2 + " defined on " + string);
                }
            }
        }
    }

    private static WLSMibTableColumnsMetadata getColumnsMetadata(String string, String[] stringArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (Initializer.OVERRIDES_REVERSE.containsKey(string2)) {
                string2 = (String)Initializer.OVERRIDES_REVERSE.get(stringArray[i]);
            }
            int n = string.length();
            if (string.startsWith("snmp") && stringArray[i].startsWith("wlssnmp")) {
                n += 3;
            }
            String string3 = string2.substring(n);
            arrayList.add(new String[]{stringArray[i], string3});
            if (!DEBUG_LOGGER.isDebugEnabled()) continue;
            DEBUG_LOGGER.debug("Discovered attribute " + string3 + " for type " + string + " , snmp column name = " + stringArray[i]);
        }
        return new WLSMibTableColumnsMetadata(arrayList);
    }

    private static String getFullyQualifiedClassName(String string) {
        try {
            String string2 = "weblogic.management.runtime." + string;
            Class.forName(string2);
            return string2;
        }
        catch (Exception exception) {
            try {
                String string3 = "weblogic.management.configuration." + string;
                Class.forName(string3);
                return string3;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static String findSubsystemPrefix(List list, String string) {
        String string2 = "";
        for (String string3 : list) {
            if (!string.startsWith(string3)) continue;
            return string3;
        }
        return string2;
    }

    public static boolean isColumnNameOverridden(String string) {
        boolean bl = Initializer.OVERRIDES.containsKey(string);
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("isColumnNameOverriden for column " + string + "::returning " + bl);
        }
        return bl;
    }

    public static String getColumnNameOverride(String string) {
        String string2 = (String)Initializer.OVERRIDES.get(string);
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("getColumnNameOverride() for column " + string + "::returning " + string2);
        }
        return string2;
    }

    private static final class Initializer {
        private static final Map OUTLIERS = new HashMap(){
            {
                this.put("snmpAgent", "weblogic.management.configuration.SNMPAgentMBean");
                this.put("wsReliableDeliveryPolicy", "weblogic.management.configuration.WSReliableDeliveryPolicyMBean");
                this.put("wtctBridgeGlobal", "weblogic.management.configuration.WTCtBridgeGlobalMBean");
                this.put("wtctBridgeRedirect", "weblogic.management.configuration.WTCtBridgeRedirectMBean");
                this.put("jrockitRuntime", "weblogic.management.runtime.JRockitRuntimeMBean");
                this.put("xmlEntitySpecRegistry", "weblogic.management.configuration.XMLEntitySpecRegistryEntryMBean");
                this.put("xmlParserSelectRegistry", "weblogic.management.configuration.XMLParserSelectRegistryEntryMBean");
                this.put("componentRuntime", "weblogic.management.runtime.ComponentRuntimeMBean");
                this.put("commonLog", "weblogic.management.configuration.CommonLogMBean");
            }
        };
        private static final Map OVERRIDES = new HashMap(){
            {
                this.put("connectorConnectionPoolRuntimeConnectionsDestroyedByErrorTotalCount", "connectorConnectionPoolRuntimeConnectionsDestroyedByErrorTotalCt");
                this.put("connectorConnectionPoolRuntimeConnectionsDestroyedByShrinkingTotalCount", "connectorConnectionPoolRuntimeConsDestroyedByShrinkingTotalCount");
                this.put("singleSignOnServicesWantTransportLayerSecurityClientAuthentication", "singleSignOnServicesWantTransportLayerSecurityClientAtn");
                this.put("springTransactionManagerRuntimeGlobalRollbackOnParticipationFailure", "springTransactionManagerRuntimeGlobalRollbkOnParticipationFailure");
                this.put("transactionNameRuntimeTransactionReadOnlyOnePhaseCommittedTotalCount", "txNameRuntimeTxReadOnlyOnePhaseCommittedTotalCount");
                this.put("transactionNameRuntimeTransactionOneResourceOnePhaseCommittedTotalCount", "txNameRuntimeTxOneResourceOnePhaseCommittedTotalCount");
            }
        };
        private static final Map OVERRIDES_REVERSE = new HashMap(){
            {
                for (Map.Entry entry : OVERRIDES.entrySet()) {
                    this.put(entry.getValue(), entry.getKey());
                }
            }
        };

        private Initializer() {
        }
    }
}

