/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.muxer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPTransportProvider;
import weblogic.diagnostics.snmp.agent.SNMPV3Agent;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;
import weblogic.diagnostics.snmp.muxer.ProtocolHandlerSNMP;
import weblogic.diagnostics.snmp.muxer.Utils;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.SocketMuxer;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.work.WorkManager;

public final class MuxableSocketSNMP
extends AbstractMuxableSocket {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugSNMPProtocolTCP");
    static final int[] MSG_LENGTH_MULTIPLIERS = new int[]{1, 256, 65536, 0x1000000};
    private SNMPV3Agent snmpAgent;
    private WorkManager snmpWorkManager;

    MuxableSocketSNMP(Chunk chunk, Socket socket, ServerChannel serverChannel, SNMPV3Agent sNMPV3Agent) throws IOException {
        super(chunk, socket, serverChannel);
        this.snmpAgent = sNMPV3Agent;
        if (this.snmpAgent != null) {
            this.snmpWorkManager = this.snmpAgent.getSnmpWorkManagerInstance();
        }
        if (DEBUG_LOGGER.isDebugEnabled() && this.snmpWorkManager != null) {
            DEBUG_LOGGER.debug("Workmanager instance for SNMP traffic: " + this.snmpWorkManager.getName());
        }
    }

    MuxableSocketSNMP(InetAddress inetAddress, int n, ServerChannel serverChannel) throws IOException {
        super(serverChannel);
        this.connect(inetAddress, n);
    }

    public static MuxableSocketSNMP createConnection(String string, int n) throws IOException {
        ServerChannel serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerSNMP.PROTOCOL_SNMP);
        MuxableSocketSNMP muxableSocketSNMP = new MuxableSocketSNMP(InetAddress.getByName(string), n, serverChannel);
        SocketMuxer.getMuxer().register(muxableSocketSNMP);
        SocketMuxer.getMuxer().read(muxableSocketSNMP);
        return muxableSocketSNMP;
    }

    protected int getHeaderLength() {
        return 9;
    }

    protected int getMessageLength() {
        if (this.msgLength < 0) {
            int n;
            int n2 = 1;
            int n3 = 2;
            if (((n = this.getHeaderByte(n2++)) & 0x80) == 128) {
                int n4 = n & 0x7F;
                n3 += n4;
                n = 0;
                for (int i = 0; i < n4; ++i) {
                    int n5 = MSG_LENGTH_MULTIPLIERS[n4 - i - 1];
                    byte by = this.getHeaderByte(n2++);
                    n += (by & 0xFF) * n5;
                }
            }
            this.msgLength = n3 + n;
            if (DEBUG_LOGGER.isDebugEnabled()) {
                this.debug("getMessageLength", "msgLength == " + this.msgLength);
            }
        }
        return this.msgLength;
    }

    public void dispatch(Chunk chunk) {
        if (this.snmpWorkManager != null) {
            this.snmpWorkManager.schedule((Runnable)new SnmpProtocolReader(chunk));
        }
    }

    public void hasException(Throwable throwable) {
        this.close();
    }

    public void endOfStream() {
        this.close();
    }

    public boolean timeout() {
        this.close();
        return true;
    }

    private void debug(String string, String string2) {
        Utils.debug(DEBUG_LOGGER, "MuxableSocketSNMP", string, string2);
    }

    private class SnmpProtocolReader
    implements Runnable {
        private Chunk dataChunks;

        public SnmpProtocolReader(Chunk chunk) {
            this.dataChunks = chunk;
        }

        public void run() {
            if (DEBUG_LOGGER.isDebugEnabled()) {
                this.debug("run", "processing message");
            }
            try {
                SNMPV3AgentToolkit sNMPV3AgentToolkit;
                SNMPTransportProvider sNMPTransportProvider;
                if (MuxableSocketSNMP.this.snmpAgent != null && MuxableSocketSNMP.this.snmpAgent.isSNMPAgentInitialized() && (sNMPTransportProvider = (sNMPV3AgentToolkit = (SNMPV3AgentToolkit)MuxableSocketSNMP.this.snmpAgent.getSNMPAgentToolkit()).getTransportProvider(1)) != null) {
                    ChunkedInputStream chunkedInputStream = new ChunkedInputStream(this.dataChunks, 0);
                    int n = Chunk.size((Chunk)this.dataChunks);
                    if (n > 0) {
                        byte[] byArray = new byte[n];
                        int n2 = chunkedInputStream.available();
                        for (int i = 0; n2 > 0 && i < n; i += chunkedInputStream.read(byArray, i, n2)) {
                            n2 = chunkedInputStream.available();
                        }
                        if (DEBUG_LOGGER.isDebugEnabled()) {
                            this.debug("run", "pushing message into agent");
                        }
                        sNMPTransportProvider.pushMessage(MuxableSocketSNMP.this, byArray);
                    }
                }
            }
            catch (Throwable throwable) {
                this.debug("run", "Caught exception: " + throwable.getMessage());
                SocketMuxer.getMuxer().deliverHasException(MuxableSocketSNMP.this.getSocketFilter(), throwable);
                MuxableSocketSNMP.this.close();
            }
        }

        private void debug(String string, String string2) {
            if (DEBUG_LOGGER.isDebugEnabled()) {
                Utils.debug(DEBUG_LOGGER, "MuxableSocketSNMP.SnmpProtocolReader:", string, string2);
            }
        }
    }
}

