/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.muxer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPV3Agent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.muxer.InvalidSNMPNetworkChannelException;
import weblogic.diagnostics.snmp.muxer.MuxableSocketSNMP;
import weblogic.diagnostics.snmp.muxer.Utils;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.utils.ArrayUtils;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerSNMP
implements ProtocolHandler,
PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String PROTOCOL_NAME = "snmp";
    static final byte ASN1_SEQUENCE_DEFINITE_LENGTH = 48;
    static final byte BER_ENCODED_INTEGER = 2;
    static final int MULTIBYTE_LENGTH_TAG = 128;
    static final int MULTIBYTE_LENGTH_MASK = 127;
    private static final int SNMP_V1_TAG = 0;
    private static final int SNMP_V2_TAG = 1;
    private static final int SNMP_V3_TAG = 3;
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPProtocolTCP");
    static final int DISCRIMINATION_LENGTH = 9;
    private static final ProtocolHandlerSNMP theOne = new ProtocolHandlerSNMP();
    public static final Protocol PROTOCOL_SNMP = ProtocolManager.createProtocol((byte)17, (String)"snmp", (String)"snmp", (boolean)false, (ProtocolHandler)ProtocolHandlerSNMP.getProtocolHandler());
    protected SNMPV3Agent snmpAgent;
    private boolean usingDedicatedSnmpChannel;
    private static int SNMP_PRIORITY = 0x7FFFFFFE;
    private ServerMBean server = this.getServerRuntimeConfiguration();

    public static ProtocolHandler getProtocolHandler() {
        if (DEBUG.isDebugEnabled()) {
            Utils.debug(DEBUG, "ProtocolHandlerSNMP", "getSNMPProtocolHandler", "");
        }
        return ProtocolHandlerSNMP.getSNMPProtocolHandler();
    }

    public static ProtocolHandlerSNMP getSNMPProtocolHandler() {
        if (DEBUG.isDebugEnabled()) {
            Utils.debug(DEBUG, "ProtocolHandlerSNMP", "getSNMPProtocolHandler", "");
        }
        return theOne;
    }

    private ProtocolHandlerSNMP() {
        this.server.addPropertyChangeListener(this);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Initializing, checking for dedicated SNMP channel.");
        }
        this.usingDedicatedSnmpChannel = this.checkForDedicatedSNMPChannel(this.server.getNetworkAccessPoints());
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = this.server.getNetworkAccessPoints();
        if (networkAccessPointMBeanArray != null) {
            for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
                if (networkAccessPointMBeanArray[i] == null) continue;
                networkAccessPointMBeanArray[i].addPropertyChangeListener(this);
            }
        }
    }

    private ServerMBean getServerRuntimeConfiguration() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        ServerMBean serverMBean = runtimeAccess.getServer();
        return serverMBean;
    }

    public ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.DEFAULT_SNMP_CHANNEL;
    }

    public int getHeaderLength() {
        return 9;
    }

    public int getPriority() {
        return SNMP_PRIORITY;
    }

    public Protocol getProtocol() {
        return PROTOCOL_SNMP;
    }

    public boolean claimSocket(Chunk chunk) {
        int n;
        byte by;
        if (this.snmpAgent == null || !this.snmpAgent.isSNMPAgentInitialized()) {
            return false;
        }
        if (chunk.end < 9) {
            return false;
        }
        byte[] byArray = chunk.buf;
        int n2 = 0;
        if (byArray[n2++] != 48) {
            return false;
        }
        if (((by = byArray[n2++]) & 0x80) == 128) {
            n = by & 0x7F;
            if (n > MuxableSocketSNMP.MSG_LENGTH_MULTIPLIERS.length) {
                if (DEBUG.isDebugEnabled()) {
                    this.debug("claimSocket", "multi-byte length field greater than 4");
                }
                return false;
            }
            n2 += n;
        }
        if (byArray[n2++] != 2) {
            return false;
        }
        if ((byArray[n2] & 0x80) == 128) {
            return false;
        }
        if ((n = byArray[n2++]) > 1) {
            return false;
        }
        byte by2 = byArray[n2++];
        switch (by2) {
            case 0: 
            case 1: 
            case 3: {
                if (DEBUG.isDebugEnabled()) {
                    this.debug("claimSocket", "Valid SNMP packet, version: " + by2);
                }
                return true;
            }
        }
        if (DEBUG.isDebugEnabled()) {
            this.debug("claimSocket", "Invalid SNMP packet version: " + by2);
        }
        return false;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        if (this.usingDedicatedSnmpChannel && serverChannel.getChannelName().startsWith("Default")) {
            String string = SNMPLogger.logUseOfDefaultSnmpChannelDetectedLoggable().getMessage();
            throw new InvalidSNMPNetworkChannelException(string);
        }
        MuxableSocketSNMP muxableSocketSNMP = new MuxableSocketSNMP(chunk, socket, serverChannel, this.snmpAgent);
        return muxableSocketSNMP;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ServerMBean) {
            if (propertyChangeEvent.getPropertyName().equals("NetworkAccessPoints")) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("NetworkAccessPoints changed, processing changes");
                }
                Object[] objectArray = (NetworkAccessPointMBean[])propertyChangeEvent.getOldValue();
                Object[] objectArray2 = (NetworkAccessPointMBean[])propertyChangeEvent.getNewValue();
                ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this);
                this.usingDedicatedSnmpChannel = this.checkForDedicatedSNMPChannel((NetworkAccessPointMBean[])objectArray2);
            }
        } else if (object instanceof NetworkAccessPointMBean) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("NetworkAccessPoints changed, processing changes");
            }
            if (propertyChangeEvent.getPropertyName().equals("Enabled")) {
                this.usingDedicatedSnmpChannel = this.checkForDedicatedSNMPChannel(this.server.getNetworkAccessPoints());
            }
        }
    }

    private boolean checkForDedicatedSNMPChannel(NetworkAccessPointMBean[] networkAccessPointMBeanArray) {
        if (networkAccessPointMBeanArray != null) {
            for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
                NetworkAccessPointMBean networkAccessPointMBean = networkAccessPointMBeanArray[i];
                if (networkAccessPointMBean == null || !networkAccessPointMBean.isEnabled() || !networkAccessPointMBean.getProtocol().equals(PROTOCOL_NAME) || networkAccessPointMBean.getName().startsWith("Default")) continue;
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Found dedicated SNMP channel, channel name: " + networkAccessPointMBean.getName());
                }
                return true;
            }
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Using default channel for SNMP traffic.");
        }
        return false;
    }

    public void setAgent(SNMPV3Agent sNMPV3Agent) {
        this.snmpAgent = sNMPV3Agent;
    }

    public SNMPV3Agent getAgent() {
        return this.snmpAgent;
    }

    private void debug(String string, String string2) {
        Utils.debug(DEBUG, "ProtocolHandlerSNMP", string, string2);
    }

    public void addObject(Object object) {
        NetworkAccessPointMBean networkAccessPointMBean;
        if (object instanceof NetworkAccessPointMBean && (networkAccessPointMBean = (NetworkAccessPointMBean)object).getProtocol().equals(PROTOCOL_NAME)) {
            networkAccessPointMBean.addPropertyChangeListener(this);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Registering protocol handler for property change notifications with NAP named " + networkAccessPointMBean.getName());
            }
        }
    }

    public void removeObject(Object object) {
        NetworkAccessPointMBean networkAccessPointMBean;
        if (object instanceof NetworkAccessPointMBean && (networkAccessPointMBean = (NetworkAccessPointMBean)object).getProtocol().equals(PROTOCOL_NAME)) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("NAP " + networkAccessPointMBean.getName() + " removed, unregistering for property change notifications");
            }
            networkAccessPointMBean.removePropertyChangeListener(this);
        }
    }

    private static final class ChannelInitializer {
        private static final ServerChannel DEFAULT_SNMP_CHANNEL = ServerChannelImpl.createDefaultServerChannel(PROTOCOL_SNMP);

        private ChannelInitializer() {
        }
    }
}

