/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.CounterMonitorListener;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPCounterMonitorMBean;
import weblogic.management.configuration.ServerMBean;

public class CounterMonitorLifecycle
extends JMXMonitorLifecycle {
    public CounterMonitorLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        this.initializeCounterMonitors(sNMPAgentMBean.getSNMPCounterMonitors());
    }

    private void initializeCounterMonitors(SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray) throws Exception {
        if (sNMPCounterMonitorMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPCounterMonitorMBeanArray.length; ++i) {
            SNMPCounterMonitorMBean sNMPCounterMonitorMBean = sNMPCounterMonitorMBeanArray[i];
            CounterMonitorListener counterMonitorListener = null;
            ServerMBean[] serverMBeanArray = sNMPCounterMonitorMBean.getEnabledServers();
            int n = serverMBeanArray == null ? 0 : serverMBeanArray.length;
            boolean bl = sNMPCounterMonitorMBean.getMonitoredMBeanType().endsWith("Runtime");
            if (bl && this.adminServer && n > 0) {
                for (int j = 0; j < n; ++j) {
                    counterMonitorListener = new CounterMonitorListener(this, this.snmpAgent, sNMPCounterMonitorMBean.getMonitoredMBeanName(), sNMPCounterMonitorMBean.getMonitoredMBeanType(), this.serverName, serverMBeanArray[j].getName(), sNMPCounterMonitorMBean.getMonitoredAttributeName(), sNMPCounterMonitorMBean.getThreshold(), sNMPCounterMonitorMBean.getOffset(), sNMPCounterMonitorMBean.getModulus());
                    this.monitorListenerList.add(counterMonitorListener);
                    counterMonitorListener.setName(sNMPCounterMonitorMBean.getName());
                    counterMonitorListener.setPollingIntervalSeconds(sNMPCounterMonitorMBean.getPollingInterval());
                }
                continue;
            }
            counterMonitorListener = new CounterMonitorListener(this, this.snmpAgent, sNMPCounterMonitorMBean.getMonitoredMBeanName(), sNMPCounterMonitorMBean.getMonitoredMBeanType(), this.serverName, null, sNMPCounterMonitorMBean.getMonitoredAttributeName(), sNMPCounterMonitorMBean.getThreshold(), sNMPCounterMonitorMBean.getOffset(), sNMPCounterMonitorMBean.getModulus());
            this.monitorListenerList.add(counterMonitorListener);
            counterMonitorListener.setName(sNMPCounterMonitorMBean.getName());
            counterMonitorListener.setPollingIntervalSeconds(sNMPCounterMonitorMBean.getPollingInterval());
        }
    }

    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        CounterMonitorListener counterMonitorListener = (CounterMonitorListener)jMXMonitorListener;
        try {
            ObjectName objectName2 = this.getMonitorObjectName(objectName, counterMonitorListener, "CounterMonitor");
            if (!this.mbeanServerConnection.isRegistered(objectName2)) {
                ObjectInstance objectInstance = this.mbeanServerConnection.createMBean("javax.management.monitor.CounterMonitor", objectName2);
                objectName2 = objectInstance.getObjectName();
            } else {
                this.mbeanServerConnection.invoke(objectName2, "stop", new Object[0], new String[0]);
            }
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("GranularityPeriod", new Long(counterMonitorListener.getPollingIntervalSeconds() * 1000)));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("ObservedAttribute", counterMonitorListener.getAttributeName()));
            this.mbeanServerConnection.invoke(objectName2, "addObservedObject", new Object[]{objectName}, new String[]{"javax.management.ObjectName"});
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("Notify", Boolean.TRUE));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("DifferenceMode", Boolean.FALSE));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("InitThreshold", this.getNumber(counterMonitorListener.getTypeName(), counterMonitorListener.getAttributeName(), counterMonitorListener.getThreshold())));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("Offset", this.getNumber(counterMonitorListener.getTypeName(), counterMonitorListener.getAttributeName(), counterMonitorListener.getOffset())));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("Modulus", this.getNumber(counterMonitorListener.getTypeName(), counterMonitorListener.getAttributeName(), counterMonitorListener.getModulus())));
            this.registerMonitorListener(objectName2, counterMonitorListener, null);
            this.mbeanServerConnection.invoke(objectName2, "start", new Object[0], new String[0]);
            counterMonitorListener.setMonitor(objectName2);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Registered " + objectName2 + " to observe " + objectName + ":" + counterMonitorListener.getAttributeName());
            }
        }
        catch (Throwable throwable) {
            SNMPLogger.logMonitorCreationError((String)counterMonitorListener.getName(), (String)"SNMPCounterMonitorMBean", (String)objectName.toString(), (Throwable)throwable);
        }
    }
}

