/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.io.Serializable;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.GaugeMonitorListener;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPGaugeMonitorMBean;
import weblogic.management.configuration.ServerMBean;

public class GaugeMonitorLifecycle
extends JMXMonitorLifecycle {
    public GaugeMonitorLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        this.initializeGaugeMonitors(sNMPAgentMBean.getSNMPGaugeMonitors());
    }

    private void initializeGaugeMonitors(SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray) throws Exception {
        if (sNMPGaugeMonitorMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPGaugeMonitorMBeanArray.length; ++i) {
            SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean = sNMPGaugeMonitorMBeanArray[i];
            GaugeMonitorListener gaugeMonitorListener = null;
            ServerMBean[] serverMBeanArray = sNMPGaugeMonitorMBean.getEnabledServers();
            int n = serverMBeanArray == null ? 0 : serverMBeanArray.length;
            boolean bl = sNMPGaugeMonitorMBean.getMonitoredMBeanType().endsWith("Runtime");
            if (bl && this.adminServer && n > 0) {
                for (int j = 0; j < n; ++j) {
                    gaugeMonitorListener = new GaugeMonitorListener(this, this.snmpAgent, sNMPGaugeMonitorMBean.getMonitoredMBeanName(), sNMPGaugeMonitorMBean.getMonitoredMBeanType(), this.serverName, serverMBeanArray[j].getName(), sNMPGaugeMonitorMBean.getMonitoredAttributeName(), sNMPGaugeMonitorMBean.getThresholdLow(), sNMPGaugeMonitorMBean.getThresholdHigh());
                    this.monitorListenerList.add(gaugeMonitorListener);
                    gaugeMonitorListener.setName(sNMPGaugeMonitorMBean.getName());
                    gaugeMonitorListener.setPollingIntervalSeconds(sNMPGaugeMonitorMBean.getPollingInterval());
                }
                continue;
            }
            gaugeMonitorListener = new GaugeMonitorListener(this, this.snmpAgent, sNMPGaugeMonitorMBean.getMonitoredMBeanName(), sNMPGaugeMonitorMBean.getMonitoredMBeanType(), this.serverName, null, sNMPGaugeMonitorMBean.getMonitoredAttributeName(), sNMPGaugeMonitorMBean.getThresholdLow(), sNMPGaugeMonitorMBean.getThresholdHigh());
            this.monitorListenerList.add(gaugeMonitorListener);
            gaugeMonitorListener.setName(sNMPGaugeMonitorMBean.getName());
            gaugeMonitorListener.setPollingIntervalSeconds(sNMPGaugeMonitorMBean.getPollingInterval());
        }
    }

    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        GaugeMonitorListener gaugeMonitorListener = (GaugeMonitorListener)jMXMonitorListener;
        try {
            Serializable serializable;
            ObjectName objectName2 = this.getMonitorObjectName(objectName, gaugeMonitorListener, "GaugeMonitor");
            if (!this.mbeanServerConnection.isRegistered(objectName2)) {
                serializable = this.mbeanServerConnection.createMBean("javax.management.monitor.GaugeMonitor", objectName2);
                objectName2 = serializable.getObjectName();
            } else {
                this.mbeanServerConnection.invoke(objectName2, "stop", new Object[0], new String[0]);
            }
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("GranularityPeriod", new Long(gaugeMonitorListener.getPollingIntervalSeconds() * 1000)));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("ObservedAttribute", gaugeMonitorListener.getAttributeName()));
            this.mbeanServerConnection.invoke(objectName2, "addObservedObject", new Object[]{objectName}, new String[]{"javax.management.ObjectName"});
            serializable = this.getNumber(gaugeMonitorListener.getTypeName(), gaugeMonitorListener.getAttributeName(), gaugeMonitorListener.getHighThreshold());
            Number number = this.getNumber(gaugeMonitorListener.getTypeName(), gaugeMonitorListener.getAttributeName(), gaugeMonitorListener.getLowThreshold());
            this.mbeanServerConnection.invoke(objectName2, "setThresholds", new Object[]{serializable, number}, new String[]{"java.lang.Number", "java.lang.Number"});
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("NotifyHigh", Boolean.TRUE));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("NotifyLow", Boolean.TRUE));
            this.registerMonitorListener(objectName2, gaugeMonitorListener, null);
            this.mbeanServerConnection.invoke(objectName2, "start", new Object[0], new String[0]);
            gaugeMonitorListener.setMonitor(objectName2);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Registered " + objectName2 + " to observe " + objectName + ":" + gaugeMonitorListener.getAttributeName());
            }
        }
        catch (Throwable throwable) {
            SNMPLogger.logMonitorCreationError((String)gaugeMonitorListener.getName(), (String)"SNMPGaugeMonitorMBean", (String)objectName.toString(), (Throwable)throwable);
        }
    }
}

