/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;

public abstract class JMXMonitorLifecycle {
    static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final String LOCATION_KEY = "Location";
    static final String SNMP_DOMAIN = "com.bea.wls.snmp";
    static final String OBJECT_NAME_PREFIX = "com.bea.wls.snmp:";
    private static BeanInfoAccess beanInfoAccess;
    boolean adminServer;
    SNMPAgent snmpAgent;
    String serverName;
    MBeanServerConnection mbeanServerConnection;
    List monitorListenerList = new LinkedList();
    Map monitorListenerRegistry = new HashMap();
    protected boolean deregisterMonitorListener = false;

    public JMXMonitorLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        this.adminServer = bl;
        this.snmpAgent = sNMPAgent;
        this.serverName = string;
        this.mbeanServerConnection = mBeanServerConnection;
    }

    protected ObjectName getMonitorObjectName(ObjectName objectName, JMXMonitorListener jMXMonitorListener, String string) throws MalformedObjectNameException {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        String string2 = objectName.getKeyProperty(LOCATION_KEY);
        String string3 = jMXMonitorListener.getName() + "-" + jMXMonitorListener.getAttributeName();
        if (string2 != null && string2.length() > 0) {
            hashtable.remove(LOCATION_KEY);
            string3 = string3 + "-" + string2;
        }
        hashtable.put(string, string3);
        ObjectName objectName2 = new ObjectName(SNMP_DOMAIN, hashtable);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Creating MBean " + objectName2);
        }
        return objectName2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerMonitorListener(ObjectName objectName, JMXMonitorListener jMXMonitorListener, Object object) throws Exception {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Registering listener: this=" + this + " objectName=" + objectName + " listener=" + jMXMonitorListener + " handback=" + object);
        }
        this.mbeanServerConnection.addNotificationListener(objectName, jMXMonitorListener, (NotificationFilter)jMXMonitorListener, object);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Registered listener succesfully: this=" + this + " objectName=" + objectName + " listener=" + jMXMonitorListener + " handback=" + object);
        }
        LinkedList<JMXMonitorListener> linkedList = null;
        Object object2 = this.monitorListenerRegistry;
        synchronized (object2) {
            linkedList = (LinkedList<JMXMonitorListener>)this.monitorListenerRegistry.get(objectName);
            if (linkedList == null) {
                linkedList = new LinkedList<JMXMonitorListener>();
                this.monitorListenerRegistry.put(objectName, linkedList);
            }
        }
        object2 = linkedList;
        synchronized (object2) {
            linkedList.add(jMXMonitorListener);
        }
    }

    void serverStarted(String string) {
    }

    void serverStopped(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getJMXMonitorListeners() {
        LinkedList linkedList = new LinkedList();
        List list = this.monitorListenerList;
        synchronized (list) {
            linkedList.addAll(this.monitorListenerList);
        }
        return linkedList.iterator();
    }

    abstract void initializeMonitorListenerList(SNMPAgentMBean var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerMonitorListeners(ObjectName objectName) {
        List list = this.monitorListenerList;
        synchronized (list) {
            for (JMXMonitorListener jMXMonitorListener : this.monitorListenerList) {
                ObjectName objectName2 = jMXMonitorListener.getQueryExpression();
                if (objectName2 == null || !objectName2.apply(objectName)) continue;
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Registering JMXMonitor for " + objectName + " as it matches " + jMXMonitorListener.getQueryExpression());
                }
                this.registerMonitor(objectName, jMXMonitorListener);
            }
        }
    }

    abstract void registerMonitor(ObjectName var1, JMXMonitorListener var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterMonitorListeners() {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("De-registering monitor listeners on " + this);
        }
        Map map = this.monitorListenerRegistry;
        synchronized (map) {
            Iterator iterator = this.monitorListenerRegistry.keySet().iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                this.deregisterMonitorListeners(objectName, false);
                iterator.remove();
            }
        }
        this.monitorListenerList.clear();
    }

    void deregisterMonitorListeners(ObjectName objectName) {
        this.deregisterMonitorListeners(objectName, true);
    }

    protected void deregisterMonitorListener(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        block5: {
            if (!this.deregisterMonitorListener) {
                return;
            }
            try {
                if (this.mbeanServerConnection.isRegistered(objectName)) {
                    if (DEBUG.isDebugEnabled()) {
                        DEBUG.debug("Unregistering NotificationListener " + jMXMonitorListener + " on " + objectName);
                    }
                    this.mbeanServerConnection.removeNotificationListener(objectName, jMXMonitorListener);
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG.isDebugEnabled()) break block5;
                DEBUG.debug("Exception deregistering listener", throwable);
            }
        }
    }

    private List getMonitorsForObservedInstance(ObjectName objectName) {
        ArrayList arrayList = new ArrayList();
        for (Object k : this.monitorListenerRegistry.keySet()) {
            List list = (List)this.monitorListenerRegistry.get(k);
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (!bl && iterator.hasNext()) {
                JMXMonitorListener jMXMonitorListener = (JMXMonitorListener)iterator.next();
                ObjectName objectName2 = jMXMonitorListener.getQueryExpression();
                if (jMXMonitorListener.getMonitor() == null || objectName2 == null || !objectName2.apply(objectName)) continue;
                bl = true;
            }
            if (!bl) continue;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Monitor " + k + " observes an attribute on " + objectName);
            }
            arrayList.add(k);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterMonitorListeners(ObjectName objectName, boolean bl) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("deregisterMonitorListeners " + objectName);
        }
        List list = null;
        List list2 = null;
        Object object = this.monitorListenerRegistry;
        synchronized (object) {
            list = (List)this.monitorListenerRegistry.get(objectName);
            if (list == null) {
                list2 = this.getMonitorsForObservedInstance(objectName);
            }
        }
        if (list == null) {
            if (list2 != null) {
                for (ObjectName objectName2 : list2) {
                    this.deregisterMonitorListeners(objectName2, bl);
                }
            }
            return;
        }
        object = list;
        synchronized (object) {
            for (JMXMonitorListener jMXMonitorListener : list) {
                ObjectName objectName3;
                block22: {
                    this.deregisterMonitorListener(objectName, jMXMonitorListener);
                    objectName3 = jMXMonitorListener.getMonitor();
                    if (objectName3 == null) continue;
                    try {
                        if (this.mbeanServerConnection.isRegistered(objectName3)) {
                            this.mbeanServerConnection.invoke(objectName3, "stop", new Object[0], new String[0]);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG.isDebugEnabled()) break block22;
                        DEBUG.debug("Exception stopping monitor", throwable);
                    }
                }
                try {
                    if (!this.mbeanServerConnection.isRegistered(objectName3)) continue;
                    if (DEBUG.isDebugEnabled()) {
                        DEBUG.debug("Unregistering NotificationListener " + jMXMonitorListener + " for " + objectName3);
                    }
                    this.mbeanServerConnection.removeNotificationListener(objectName3, jMXMonitorListener);
                    this.mbeanServerConnection.unregisterMBean(objectName3);
                }
                catch (Throwable throwable) {
                    if (!DEBUG.isDebugEnabled()) continue;
                    DEBUG.debug("Exception deregistering listener", throwable);
                }
            }
        }
        if (bl) {
            object = this.monitorListenerRegistry;
            synchronized (object) {
                this.monitorListenerRegistry.remove(objectName);
            }
        }
    }

    private void removeObservedInstances(ObjectName objectName) {
        block3: {
            try {
                ObjectName[] objectNameArray = (ObjectName[])this.mbeanServerConnection.invoke(objectName, "getObservedObjects", new Object[]{objectName}, new String[]{"javax.management.ObjectName"});
                int n = objectNameArray != null ? objectNameArray.length : 0;
                for (int i = 0; i < n; ++i) {
                    this.mbeanServerConnection.invoke(objectName, "removeObservedObject", new Object[]{objectNameArray[i]}, new String[]{"javax.management.ObjectName"});
                }
                this.mbeanServerConnection.setAttribute(objectName, new Attribute("ObservedAttribute", null));
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block3;
                DEBUG.debug("Exception while removing observed instance", (Throwable)exception);
            }
        }
    }

    protected Number getNumber(String string, String string2, int n) throws IllegalArgumentException {
        try {
            PropertyDescriptor propertyDescriptor = JMXMonitorLifecycle.getPropertyDescriptor(string, string2);
            Class<Object> clazz = propertyDescriptor.getPropertyType();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Class = " + clazz + " for " + string + "." + string2);
            }
            clazz = clazz == Double.TYPE ? Double.class : (clazz == Float.TYPE ? Float.class : (clazz == Long.TYPE ? Long.class : Integer.class));
            Method method = clazz.getMethod("valueOf", String.class);
            return (Number)method.invoke(null, "" + n);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(String string, String string2) {
        BeanInfo beanInfo = JMXMonitorLifecycle.getBeanInfo(string);
        if (beanInfo == null) {
            throw new IllegalArgumentException();
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null) {
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string3 = propertyDescriptor.getName();
                if (string3 == null || !string3.equals(string2)) continue;
                return propertyDescriptor;
            }
        }
        throw new IllegalArgumentException();
    }

    private static BeanInfo getBeanInfo(String string) {
        String string2;
        String string3;
        BeanInfo beanInfo;
        if (beanInfoAccess == null) {
            beanInfoAccess = ManagementService.getBeanInfoAccess();
        }
        if ((beanInfo = beanInfoAccess.getBeanInfoForInterface(string, true, string3 = VersionInfo.theOne().getReleaseVersion())) == null && string.indexOf(".") == -1) {
            string2 = "weblogic.management.configuration." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface(string2, true, string3);
        }
        if (beanInfo == null && string.indexOf(".") == -1) {
            string2 = "weblogic.management.runtime." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface(string2, true, string3);
        }
        return beanInfo;
    }
}

