/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.Date;
import java.util.LinkedList;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.monitor.MonitorNotification;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.SNMPRuntimeStats;

public abstract class JMXMonitorListener
implements NotificationFilter,
NotificationListener {
    private static final String LOCATION_KEY = "Location";
    protected static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    protected static final String TRAP_TIME = "trapTime";
    protected static final String TRAP_SERVER_NAME = "trapServerName";
    protected static final String TRAP_MONITOR_TYPE = "trapMonitorType";
    protected static final String TRAP_MBEAN_NAME = "trapMBeanName";
    protected static final String TRAP_MBEAN_TYPE = "trapMBeanType";
    protected static final String TRAP_MONITOR_THRESHOLD = "trapMonitorThreshold";
    protected static final String TRAP_ATTR_NAME = "trapAttributeName";
    protected static final String TRAP_MONITOR_VALUE = "trapMonitorValue";
    protected static final String WLS_MONITOR_NOTIFICATION = "wlsMonitorNotification";
    protected transient SNMPAgent snmpAgent;
    protected transient ObjectName monitor = null;
    protected transient JMXMonitorLifecycle monitorLifecycle;
    protected transient SNMPRuntimeStats snmpStats;
    protected String serverName;
    protected String mbeanName;
    protected String typeName;
    protected ObjectName queryExpression;
    protected String attributeName;
    protected int pollingIntervalSeconds;
    protected String name;

    public JMXMonitorListener(JMXMonitorLifecycle jMXMonitorLifecycle, SNMPAgent sNMPAgent) {
        this.monitorLifecycle = jMXMonitorLifecycle;
        this.snmpAgent = sNMPAgent;
    }

    public JMXMonitorListener(JMXMonitorLifecycle jMXMonitorLifecycle, SNMPAgent sNMPAgent, String string, String string2, String string3, String string4, String string5) throws MalformedObjectNameException {
        this(jMXMonitorLifecycle, sNMPAgent);
        this.serverName = string3;
        this.mbeanName = string;
        this.typeName = string2;
        this.attributeName = string5;
        String string6 = "com.bea:Type=" + this.typeName;
        if (this.mbeanName != null && this.mbeanName.length() > 0) {
            string6 = string6 + ",Name=" + this.mbeanName;
        }
        if (string4 != null && string4.length() > 0) {
            string6 = string6 + ",Location=" + string4;
        }
        string6 = string6 + ",*";
        this.queryExpression = new ObjectName(string6);
    }

    public ObjectName getQueryExpression() {
        return this.queryExpression;
    }

    int getPollingIntervalSeconds() {
        return this.pollingIntervalSeconds;
    }

    void setPollingIntervalSeconds(int n) {
        this.pollingIntervalSeconds = n;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    ObjectName getMonitor() {
        return this.monitor;
    }

    void setMonitor(ObjectName objectName) {
        this.monitor = objectName;
    }

    public void handleNotification(Notification notification, Object object) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Got notification from MonitorMBean " + notification);
        }
        if (notification instanceof MonitorNotification) {
            String string;
            ObjectName objectName;
            MonitorNotification monitorNotification = (MonitorNotification)notification;
            ObjectName objectName2 = monitorNotification.getObservedObject();
            String string2 = this.serverName;
            if (objectName2 instanceof ObjectName) {
                objectName = objectName2;
                if (this.mbeanName == null || this.mbeanName.trim().length() == 0) {
                    this.mbeanName = objectName.toString();
                }
                if ((string = objectName.getKeyProperty(LOCATION_KEY)) != null && string.length() > 0) {
                    string2 = string;
                }
            }
            objectName = this.snmpAgent.getSNMPAgentToolkit().getSNMPNotificationManager();
            string = this.snmpAgent.getNotifyGroup();
            LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
            linkedList.add(new Object[]{TRAP_TIME, new Date().toString()});
            linkedList.add(new Object[]{TRAP_SERVER_NAME, string2});
            linkedList.add(new Object[]{TRAP_MONITOR_TYPE, monitorNotification.getType()});
            if (null != monitorNotification.getTrigger()) {
                linkedList.add(new Object[]{TRAP_MONITOR_THRESHOLD, monitorNotification.getTrigger().toString()});
            } else {
                linkedList.add(new Object[]{TRAP_MONITOR_THRESHOLD, "null"});
            }
            if (null != monitorNotification.getDerivedGauge()) {
                linkedList.add(new Object[]{TRAP_MONITOR_VALUE, monitorNotification.getDerivedGauge().toString()});
            } else {
                linkedList.add(new Object[]{TRAP_MONITOR_VALUE, "null"});
            }
            linkedList.add(new Object[]{TRAP_MBEAN_NAME, objectName2 != null ? ((Object)objectName2).toString() : this.mbeanName});
            linkedList.add(new Object[]{TRAP_MBEAN_TYPE, this.typeName});
            linkedList.add(new Object[]{TRAP_ATTR_NAME, this.attributeName});
            try {
                objectName.sendNotification(string, WLS_MONITOR_NOTIFICATION, linkedList);
                this.updateMonitorTrapCount();
            }
            catch (SNMPAgentToolkitException sNMPAgentToolkitException) {
                SNMPLogger.logMonitorNotificationError((String)this.serverName, (String)this.typeName, (String)this.mbeanName, (Throwable)sNMPAgentToolkitException);
            }
        }
    }

    abstract void updateMonitorTrapCount();

    JMXMonitorLifecycle getMonitorLifecycle() {
        return this.monitorLifecycle;
    }

    SNMPRuntimeStats getSNMPRuntimeStats() {
        return this.snmpStats;
    }

    void setSNMPRuntimeStats(SNMPRuntimeStats sNMPRuntimeStats) {
        this.snmpStats = sNMPRuntimeStats;
    }

    String getTypeName() {
        return this.typeName;
    }

    String getServerName() {
        return this.serverName;
    }
}

