/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.LogFilterListener;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPLogFilterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;

public class LogFilterLifecycle
extends JMXMonitorLifecycle {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private Map logFilters = new HashMap();

    public LogFilterLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        this.initializeLogFilterListeners(sNMPAgentMBean.getSNMPLogFilters());
    }

    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverStarted(String string) {
        Map map = this.logFilters;
        synchronized (map) {
            List list = (List)this.logFilters.get(string);
            if (list == null) {
                return;
            }
            for (SNMPLogFilterMBean sNMPLogFilterMBean : list) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Adding filter " + sNMPLogFilterMBean.getName() + " for server " + string);
                }
                try {
                    this.addLogBroadcasterRuntimeListener(string, sNMPLogFilterMBean);
                }
                catch (Throwable throwable) {
                    SNMPLogger.logTrapLogAddNotifError((String)sNMPLogFilterMBean.getName(), (Throwable)throwable);
                }
            }
        }
    }

    private void initializeLogFilterListeners(SNMPLogFilterMBean[] sNMPLogFilterMBeanArray) throws Exception {
        if (sNMPLogFilterMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPLogFilterMBeanArray.length; ++i) {
            SNMPLogFilterMBean sNMPLogFilterMBean = sNMPLogFilterMBeanArray[i];
            if (this.adminServer) {
                this.initializeAdminServerLogFilterListeners(sNMPLogFilterMBean);
                continue;
            }
            this.initializeManagedServerLogFilterListeners(sNMPLogFilterMBean);
        }
    }

    private void initializeManagedServerLogFilterListeners(SNMPLogFilterMBean sNMPLogFilterMBean) throws Exception {
        ObjectName objectName = (ObjectName)this.mbeanServerConnection.getAttribute(new ObjectName(RuntimeServiceMBean.OBJECT_NAME), "ServerRuntime");
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Found " + objectName);
        }
        String string = (String)this.mbeanServerConnection.getAttribute(objectName, "Name");
        this.addLogFilter(string, sNMPLogFilterMBean);
        this.addLogBroadcasterRuntimeListener(objectName, sNMPLogFilterMBean);
    }

    private void initializeAdminServerLogFilterListeners(SNMPLogFilterMBean sNMPLogFilterMBean) throws Exception {
        ConfigurationMBean configurationMBean;
        SNMPAgentMBean sNMPAgentMBean;
        ServerMBean[] serverMBeanArray = sNMPLogFilterMBean.getEnabledServers();
        if ((serverMBeanArray == null || serverMBeanArray.length == 0) && (sNMPAgentMBean = (SNMPAgentMBean)sNMPLogFilterMBean.getParent()) != null) {
            configurationMBean = null;
            configurationMBean = (DomainMBean)sNMPAgentMBean.getParent();
            if (configurationMBean != null) {
                serverMBeanArray = configurationMBean.getServers();
            }
        }
        if (serverMBeanArray == null) {
            return;
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            configurationMBean = serverMBeanArray[i];
            String string = configurationMBean.getName();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Looking up ServerRuntime for " + string);
            }
            this.addLogFilter(string, sNMPLogFilterMBean);
            this.addLogBroadcasterRuntimeListener(string, sNMPLogFilterMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogFilter(String string, SNMPLogFilterMBean sNMPLogFilterMBean) {
        Map map = this.logFilters;
        synchronized (map) {
            LinkedList<SNMPLogFilterMBean> linkedList = (LinkedList<SNMPLogFilterMBean>)this.logFilters.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<SNMPLogFilterMBean>();
                this.logFilters.put(string, linkedList);
            }
            linkedList.add(sNMPLogFilterMBean);
        }
    }

    private void addLogBroadcasterRuntimeListener(String string, SNMPLogFilterMBean sNMPLogFilterMBean) throws Exception {
        ObjectName objectName = (ObjectName)this.mbeanServerConnection.invoke(new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME), "lookupServerRuntime", new Object[]{string}, new String[]{"java.lang.String"});
        if (objectName != null) {
            this.addLogBroadcasterRuntimeListener(objectName, sNMPLogFilterMBean);
        }
    }

    private void addLogBroadcasterRuntimeListener(ObjectName objectName, SNMPLogFilterMBean sNMPLogFilterMBean) throws Exception {
        Object object;
        ObjectName objectName2 = (ObjectName)this.mbeanServerConnection.getAttribute(objectName, "LogBroadcasterRuntime");
        if (this.monitorListenerRegistry.containsKey(objectName2)) {
            object = (List)this.monitorListenerRegistry.get(objectName2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                LogFilterListener logFilterListener;
                Object e = iterator.next();
                if (e == null || !(e instanceof LogFilterListener) || !(logFilterListener = (LogFilterListener)e).getName().equals(sNMPLogFilterMBean.getName())) continue;
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Not adding log broadcaster listener as it is already registered for filter " + sNMPLogFilterMBean.getName());
                }
                return;
            }
        }
        object = new LogFilterListener(this, this.snmpAgent, sNMPLogFilterMBean.getName(), sNMPLogFilterMBean.getSeverityLevel(), sNMPLogFilterMBean.getSubsystemNames(), sNMPLogFilterMBean.getUserIds(), sNMPLogFilterMBean.getMessageIds(), sNMPLogFilterMBean.getMessageSubstring());
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Registering log filter listener " + sNMPLogFilterMBean.getName() + "for " + objectName2);
        }
        this.monitorListenerList.add(object);
        this.registerMonitorListener(objectName2, (JMXMonitorListener)object, null);
    }

    protected void deregisterMonitorListener(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        block3: {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Deregistering log filter listener " + jMXMonitorListener);
            }
            try {
                this.mbeanServerConnection.removeNotificationListener(objectName, jMXMonitorListener);
            }
            catch (Throwable throwable) {
                if (!DEBUG.isDebugEnabled()) break block3;
                DEBUG.debug("Exception deregistering listener " + jMXMonitorListener + " from " + objectName);
            }
        }
    }
}

