/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.Notification;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPNotificationManager;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.i18n.logging.SeverityI18N;
import weblogic.management.logging.WebLogicLogNotification;

public class LogFilterListener
extends JMXMonitorListener {
    private String name;
    private int severity;
    private Set allowedSubsystems = new HashSet();
    private Set allowedUserIds = new HashSet();
    private Set allowedMsgIds = new HashSet();
    private String messageSubString = "";

    public LogFilterListener(JMXMonitorLifecycle jMXMonitorLifecycle, SNMPAgent sNMPAgent, String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3) {
        super(jMXMonitorLifecycle, sNMPAgent);
        this.name = string;
        this.severity = SeverityI18N.severityStringToNum((String)string2);
        if (stringArray != null) {
            Collections.addAll(this.allowedSubsystems, stringArray);
        }
        if (stringArray2 != null) {
            Collections.addAll(this.allowedUserIds, stringArray2);
        }
        if (stringArray3 != null) {
            Collections.addAll(this.allowedMsgIds, stringArray3);
        }
        if (string3 != null) {
            this.messageSubString = string3;
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof WebLogicLogNotification) {
            String string;
            WebLogicLogNotification webLogicLogNotification = (WebLogicLogNotification)notification;
            if (webLogicLogNotification.getSeverity() > this.severity) {
                return false;
            }
            if (!this.allowedSubsystems.isEmpty() && !this.allowedSubsystems.contains(string = webLogicLogNotification.getSubsystem())) {
                return false;
            }
            if (!this.allowedUserIds.isEmpty() && !this.allowedUserIds.contains(string = webLogicLogNotification.getUserId())) {
                return false;
            }
            if (!this.allowedMsgIds.isEmpty() && !this.allowedMsgIds.contains(string = webLogicLogNotification.getMessageIdString())) {
                return false;
            }
            return this.messageSubString == null || this.messageSubString.length() <= 0 || (string = webLogicLogNotification.getMessage()).contains(this.messageSubString);
        }
        return false;
    }

    public void handleNotification(Notification notification, Object object) {
        block5: {
            WebLogicLogNotification webLogicLogNotification = (WebLogicLogNotification)notification;
            SNMPNotificationManager sNMPNotificationManager = this.snmpAgent.getSNMPAgentToolkit().getSNMPNotificationManager();
            if (sNMPNotificationManager == null) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Null notification manager, agent deactivated.");
                }
                return;
            }
            LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
            String string = new Date().toString();
            linkedList.add(new Object[]{"trapTime", string});
            linkedList.add(new Object[]{"trapServerName", webLogicLogNotification.getServername()});
            linkedList.add(new Object[]{"trapMachineName", webLogicLogNotification.getMachineName()});
            linkedList.add(new Object[]{"trapLogThreadId", webLogicLogNotification.getThreadId()});
            linkedList.add(new Object[]{"trapLogTransactionId", webLogicLogNotification.getTransactionId()});
            linkedList.add(new Object[]{"trapLogUserId", webLogicLogNotification.getUserId()});
            linkedList.add(new Object[]{"trapLogSubsystem", webLogicLogNotification.getSubsystem()});
            linkedList.add(new Object[]{"trapLogMsgId", webLogicLogNotification.getId()});
            String string2 = SeverityI18N.severityNumToString((int)webLogicLogNotification.getSeverity());
            linkedList.add(new Object[]{"trapLogSeverity", string2});
            linkedList.add(new Object[]{"trapLogMessage", webLogicLogNotification.getMessage()});
            try {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Sending log message trap");
                }
                sNMPNotificationManager.sendNotification(this.snmpAgent.getNotifyGroup(), "wlsLogNotification", linkedList);
                this.updateMonitorTrapCount();
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block5;
                DEBUG.debug("Exception sending log message trap", (Throwable)exception);
            }
        }
    }

    void updateMonitorTrapCount() {
        if (this.snmpStats != null) {
            this.snmpStats.incrementLogMessageTrapCount();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Updated log message count to " + this.snmpStats.getLogMessageTrapCount());
            }
        }
    }

    String getName() {
        return this.name;
    }
}

