/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.LinkedList;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.MBeanAttributeChangeListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBean;
import weblogic.management.configuration.ServerMBean;

public class MBeanAttributeChangeLifecycle
extends JMXMonitorLifecycle {
    public MBeanAttributeChangeLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
        this.deregisterMonitorListener = true;
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        this.initializeMBeanAttributeChangeListeners(sNMPAgentMBean.getSNMPAttributeChanges());
    }

    private void initializeMBeanAttributeChangeListeners(SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray) throws Exception {
        if (sNMPAttributeChangeMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPAttributeChangeMBeanArray.length; ++i) {
            SNMPAttributeChangeMBean sNMPAttributeChangeMBean = sNMPAttributeChangeMBeanArray[i];
            MBeanAttributeChangeListener mBeanAttributeChangeListener = null;
            ServerMBean[] serverMBeanArray = sNMPAttributeChangeMBean.getEnabledServers();
            int n = serverMBeanArray == null ? 0 : serverMBeanArray.length;
            boolean bl = sNMPAttributeChangeMBean.getAttributeMBeanType().endsWith("Runtime");
            if (bl & this.adminServer && n > 0) {
                for (int j = 0; j < n; ++j) {
                    mBeanAttributeChangeListener = new MBeanAttributeChangeListener(this, this.snmpAgent, sNMPAttributeChangeMBean.getAttributeMBeanName(), sNMPAttributeChangeMBean.getAttributeMBeanType(), this.serverName, serverMBeanArray[j].getName(), sNMPAttributeChangeMBean.getAttributeName());
                    this.monitorListenerList.add(mBeanAttributeChangeListener);
                    mBeanAttributeChangeListener.setName(sNMPAttributeChangeMBean.getName());
                }
                continue;
            }
            mBeanAttributeChangeListener = new MBeanAttributeChangeListener(this, this.snmpAgent, sNMPAttributeChangeMBean.getAttributeMBeanName(), sNMPAttributeChangeMBean.getAttributeMBeanType(), this.serverName, this.adminServer ? this.serverName : null, sNMPAttributeChangeMBean.getAttributeName());
            this.monitorListenerList.add(mBeanAttributeChangeListener);
            mBeanAttributeChangeListener.setName(sNMPAttributeChangeMBean.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        MBeanAttributeChangeListener mBeanAttributeChangeListener = (MBeanAttributeChangeListener)jMXMonitorListener;
        LinkedList<MBeanAttributeChangeListener> linkedList = null;
        Object object = this.monitorListenerRegistry;
        synchronized (object) {
            linkedList = (LinkedList<MBeanAttributeChangeListener>)this.monitorListenerRegistry.get(objectName);
            if (linkedList == null) {
                linkedList = new LinkedList<MBeanAttributeChangeListener>();
                this.monitorListenerRegistry.put(objectName, linkedList);
            }
        }
        try {
            this.mbeanServerConnection.addNotificationListener(objectName, mBeanAttributeChangeListener, (NotificationFilter)mBeanAttributeChangeListener, null);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Registered attribute change listener " + mBeanAttributeChangeListener + " for " + objectName + ":" + mBeanAttributeChangeListener.getAttributeName());
            }
            object = linkedList;
            synchronized (object) {
                linkedList.add(mBeanAttributeChangeListener);
            }
        }
        catch (Throwable throwable) {
            SNMPLogger.logAttrChangeCreationError((String)mBeanAttributeChangeListener.getName(), (String)mBeanAttributeChangeListener.getTypeName(), (String)mBeanAttributeChangeListener.getServerName(), (Throwable)throwable);
        }
    }
}

