/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.Date;
import java.util.LinkedList;
import javax.management.AttributeChangeNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPNotificationManager;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;

public class MBeanAttributeChangeListener
extends JMXMonitorListener {
    private static final String ATTR_CHANGE_TRAP = "wlsAttributeChange";
    private static final String TRAP_ATTR_TYPE = "trapAttributeType";
    private static final String TRAP_ATTR_CHANGE_TYPE = "trapAttributeChangeType";
    private static final String TRAP_ATTR_OLD_VALUE = "trapAttributeOldVal";
    private static final String TRAP_ATTR_NEW_VALUE = "trapAttributeNewVal";

    public MBeanAttributeChangeListener(JMXMonitorLifecycle jMXMonitorLifecycle, SNMPAgent sNMPAgent, String string, String string2, String string3, String string4, String string5) throws MalformedObjectNameException {
        super(jMXMonitorLifecycle, sNMPAgent, string, string2, string3, string4, string5);
    }

    public void handleNotification(Notification notification, Object object) {
        Object[] objectArray;
        AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Got attribute change notification " + attributeChangeNotification + " from " + attributeChangeNotification.getSource());
        }
        Object object2 = attributeChangeNotification.getOldValue();
        Object object3 = attributeChangeNotification.getNewValue();
        SNMPNotificationManager sNMPNotificationManager = this.snmpAgent.getSNMPAgentToolkit().getSNMPNotificationManager();
        String string = this.snmpAgent.getNotifyGroup();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        String string2 = attributeChangeNotification.getAttributeType();
        String string3 = "UPDATE";
        boolean bl = false;
        if (attributeChangeNotification.getNewValue() != null) {
            bl = attributeChangeNotification.getNewValue().getClass().isArray();
        }
        if (attributeChangeNotification.getOldValue() != null) {
            boolean bl2 = bl = bl || attributeChangeNotification.getOldValue().getClass().isArray();
        }
        if (bl) {
            int n;
            objectArray = (Object[])attributeChangeNotification.getOldValue();
            Object[] objectArray2 = (Object[])attributeChangeNotification.getNewValue();
            int n2 = objectArray == null ? 0 : objectArray.length;
            int n3 = n = objectArray2 == null ? 0 : objectArray2.length;
            if (n2 > n) {
                string3 = "REMOVE";
            } else if (n2 < n) {
                string3 = "ADD";
            }
            object2 = this.toString(objectArray);
            object3 = this.toString(objectArray2);
        }
        if ((objectArray = attributeChangeNotification.getSource()) == null) {
            objectArray = "";
        }
        if (objectArray instanceof ObjectName) {
            objectArray = ((ObjectName)objectArray).getCanonicalName();
        }
        linkedList.add(new Object[]{"trapTime", new Date().toString()});
        linkedList.add(new Object[]{"trapServerName", this.serverName});
        linkedList.add(new Object[]{"trapMBeanName", objectArray.toString()});
        linkedList.add(new Object[]{"trapMBeanType", this.typeName});
        linkedList.add(new Object[]{"trapAttributeName", this.attributeName});
        linkedList.add(new Object[]{TRAP_ATTR_TYPE, string2});
        linkedList.add(new Object[]{TRAP_ATTR_CHANGE_TYPE, string3});
        linkedList.add(new Object[]{TRAP_ATTR_OLD_VALUE, "" + object2});
        linkedList.add(new Object[]{TRAP_ATTR_NEW_VALUE, "" + object3});
        try {
            sNMPNotificationManager.sendNotification(string, ATTR_CHANGE_TRAP, linkedList);
            this.updateMonitorTrapCount();
        }
        catch (SNMPAgentToolkitException sNMPAgentToolkitException) {
            SNMPLogger.logMonitorNotificationError((String)this.serverName, (String)this.typeName, (String)this.mbeanName, (Throwable)sNMPAgentToolkitException);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        AttributeChangeNotification attributeChangeNotification;
        if (notification instanceof AttributeChangeNotification && (attributeChangeNotification = (AttributeChangeNotification)notification).getAttributeName().equals(this.attributeName)) {
            return true;
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Filtering notification " + notification);
        }
        return false;
    }

    void updateMonitorTrapCount() {
        if (this.snmpStats != null) {
            this.snmpStats.incrementAttributeChangeTrapCount();
        }
    }

    private String toString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (objectArray != null) {
            for (Object object : objectArray) {
                stringBuilder.append("[");
                stringBuilder.append(object != null ? object.toString() : "");
                stringBuilder.append("]");
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

