/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.MBeanServerSubAgentX;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.mib.WLSMibMetadata;
import weblogic.diagnostics.snmp.mib.WLSMibTableColumnsMetadata;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.SNMPAgentDeploymentHandler;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.mbeanservers.internal.utils.typing.MBeanCategorizer;
import weblogic.management.mbeanservers.internal.utils.typing.MBeanCategorizerPlugins;
import weblogic.management.mbeanservers.internal.utils.typing.MBeanTypeUtil;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRegHandler
implements MBeanTypeUtil.RegHandler {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final String LOCATION_KEY = "Location";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String domainName;
    private boolean adminServer;
    private String serverName;
    private SNMPAgentMBean snmpAgentConfig;
    private MBeanServerConnection mbeanServerConnection;
    private MBeanTypeUtil mbeanTypeUtil = null;
    private SNMPAgent snmpAgent;
    private MBeanServerSubAgentX customMBeansSubAgent;
    private List<WLSMibMetadata> wlsMibMetadataList = null;
    private List jmxMonitorLifecycleList;
    private Map objectNameTypes = new HashMap();

    public MBeanRegHandler(String string, boolean bl, String string2, SNMPAgentMBean sNMPAgentMBean, MBeanServerConnection mBeanServerConnection, SNMPAgent sNMPAgent, MBeanServerSubAgentX mBeanServerSubAgentX, List<WLSMibMetadata> list, List list2) {
        this.domainName = string;
        this.adminServer = bl;
        this.serverName = string2;
        this.snmpAgentConfig = sNMPAgentMBean;
        this.snmpAgent = sNMPAgent;
        this.customMBeansSubAgent = mBeanServerSubAgentX;
        this.mbeanServerConnection = mBeanServerConnection;
        this.wlsMibMetadataList = list;
        this.jmxMonitorLifecycleList = list2;
    }

    @Override
    public void newInstance(String string, String string2, String string3) throws MalformedObjectNameException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Invoked newInstance(" + string + ", " + string2 + ", " + string3 + ")");
        }
        if (this.objectNameTypes.containsKey(string2)) {
            return;
        }
        if (this.isAgentUnavailable()) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Agent not available for MBean registration");
            }
            return;
        }
        final ObjectName objectName = new ObjectName(string2);
        boolean bl = string3.equals("WLS-MBean");
        if (bl) {
            String string4;
            block16: {
                boolean bl2;
                if (!(!this.adminServer || (bl2 = string.startsWith("weblogic.management.runtime")) || (string4 = objectName.getKeyProperty(LOCATION_KEY)) != null && string4.equals(this.serverName))) {
                    if (DEBUG.isDebugEnabled()) {
                        DEBUG.debug("Rejecting " + string2);
                    }
                    return;
                }
                try {
                    SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            MBeanRegHandler.this.registerMonitorListeners(objectName);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!DEBUG.isDebugEnabled()) break block16;
                    DEBUG.debug("Exception registering monitors", (Throwable)privilegedActionException);
                }
            }
            WLSMibMetadata wLSMibMetadata = this.findWLSMibMetadata(string);
            if (wLSMibMetadata == null) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Type not defined in existing metadatas " + string);
                }
                return;
            }
            string4 = wLSMibMetadata.getSNMPTableName(string);
            WLSMibTableColumnsMetadata wLSMibTableColumnsMetadata = wLSMibMetadata.getColumnsMetadataForSNMPTable(string4);
            SNMPV3AgentToolkit sNMPV3AgentToolkit = (SNMPV3AgentToolkit)this.snmpAgent.getSNMPAgentToolkit();
            try {
                Map map = wLSMibTableColumnsMetadata.getColumnAttributeMap();
                sNMPV3AgentToolkit.addSNMPTableRowForMBeanInstance(string4, this.mbeanServerConnection, objectName, map);
                this.objectNameTypes.put(string2, string);
            }
            catch (Throwable throwable) {
                SNMPLogger.logErrorAddingRowForMBeanInstance((String)string, (String)string2, (Throwable)throwable);
                return;
            }
        }
        try {
            if (this.snmpAgentConfig.isSNMPAccessForUserMBeansEnabled() && this.customMBeansSubAgent != null) {
                this.customMBeansSubAgent.addSNMPTableRowForMBeanInstance(this.mbeanServerConnection, string, objectName);
                this.objectNameTypes.put(string2, string);
                return;
            }
        }
        catch (Throwable throwable) {
            SNMPLogger.logErrorAddingRowForMBeanInstance((String)string, (String)string2, (Throwable)throwable);
        }
    }

    private boolean isAgentUnavailable() {
        SNMPAgentDeploymentHandler sNMPAgentDeploymentHandler = SNMPAgentDeploymentHandler.getInstance();
        return this.snmpAgent == null || !this.snmpAgent.isSNMPAgentInitialized() || sNMPAgentDeploymentHandler.isAgentStopping() || sNMPAgentDeploymentHandler.isAgentStopped();
    }

    void initializeMBeanServerRegistration() throws Exception {
        MBeanCategorizer.Impl impl = new MBeanCategorizer.Impl(new MBeanCategorizer.Plugin[]{new MBeanCategorizerPlugins.WLSPlugin(), new MBeanCategorizerPlugins.NonWLSPlugin()});
        this.mbeanTypeUtil = new MBeanTypeUtil(this.mbeanServerConnection, impl);
        this.mbeanTypeUtil.addRegistrationHandler(this);
    }

    @Override
    public void instanceDeleted(String string) {
        ObjectName objectName;
        WLSMibMetadata wLSMibMetadata;
        String string2;
        block15: {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Invoked instanceDeleted(" + string + ")");
            }
            if (this.isAgentUnavailable()) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Agent not available for MBean unregistration");
                }
                return;
            }
            string2 = (String)this.objectNameTypes.get(string);
            if (string2 == null) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Type name not available for " + string);
                }
                return;
            }
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Type name for " + string + " = " + string2);
            }
            if ((wLSMibMetadata = this.findWLSMibMetadata(string2)) == null) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Type not defined in existing metadatas " + string2);
                }
                try {
                    if (this.customMBeansSubAgent != null) {
                        this.customMBeansSubAgent.deleteSNMPTableRowForMBeanInstance(string2, new ObjectName(string));
                    }
                }
                catch (Throwable throwable) {
                    SNMPLogger.logErrorDeletingRowForMBeanInstance((String)string, (Throwable)throwable);
                }
                return;
            }
            objectName = null;
            try {
                objectName = new ObjectName(string);
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block15;
                DEBUG.debug("Bad ObjectName in callback ", (Throwable)exception);
                return;
            }
        }
        SNMPV3AgentToolkit sNMPV3AgentToolkit = (SNMPV3AgentToolkit)this.snmpAgent.getSNMPAgentToolkit();
        try {
            String string3 = wLSMibMetadata.getSNMPTableName(string2);
            sNMPV3AgentToolkit.deleteSNMPTableRowForMBeanInstance(string3, objectName);
            this.objectNameTypes.remove(string);
            final ObjectName objectName2 = objectName;
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MBeanRegHandler.this.deregisterMonitorListeners(objectName2);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            SNMPLogger.logErrorDeletingRowForMBeanInstance((String)string, (Throwable)throwable);
        }
    }

    private boolean containsLocationKey(ObjectName objectName) {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        return hashtable.containsKey(LOCATION_KEY);
    }

    private void registerMonitorListeners(ObjectName objectName) {
        for (JMXMonitorLifecycle jMXMonitorLifecycle : this.jmxMonitorLifecycleList) {
            jMXMonitorLifecycle.registerMonitorListeners(objectName);
        }
    }

    private void deregisterMonitorListeners(ObjectName objectName) {
        for (JMXMonitorLifecycle jMXMonitorLifecycle : this.jmxMonitorLifecycleList) {
            jMXMonitorLifecycle.deregisterMonitorListeners(objectName);
        }
    }

    void deregister() {
        try {
            this.mbeanTypeUtil.removeRegistrationHandler(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private WLSMibMetadata findWLSMibMetadata(String string) {
        for (WLSMibMetadata wLSMibMetadata : this.wlsMibMetadataList) {
            String string2 = wLSMibMetadata.getSNMPTableName(string);
            if (string2 == null) continue;
            return wLSMibMetadata;
        }
        return null;
    }
}

