/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.MBeanServerSubAgentX;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPLocalAgentTrapSender;
import weblogic.diagnostics.snmp.agent.SNMPProxyManager;
import weblogic.diagnostics.snmp.agent.SNMPTrapDestination;
import weblogic.diagnostics.snmp.agent.SNMPTrapSender;
import weblogic.diagnostics.snmp.agent.SNMPTrapUtil;
import weblogic.diagnostics.snmp.agent.SNMPV3Agent;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.mib.SNMPExtensionProvider;
import weblogic.diagnostics.snmp.mib.SNMPExtensionProviderHelper;
import weblogic.diagnostics.snmp.mib.WLSMibMetadata;
import weblogic.diagnostics.snmp.mib.WLSMibMetadataException;
import weblogic.diagnostics.snmp.muxer.ProtocolHandlerSNMP;
import weblogic.diagnostics.snmp.server.CounterMonitorLifecycle;
import weblogic.diagnostics.snmp.server.GaugeMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.LogFilterLifecycle;
import weblogic.diagnostics.snmp.server.MBeanAttributeChangeLifecycle;
import weblogic.diagnostics.snmp.server.MBeanRegHandler;
import weblogic.diagnostics.snmp.server.SNMPAdminServerTrapSender;
import weblogic.diagnostics.snmp.server.SNMPAgentRuntime;
import weblogic.diagnostics.snmp.server.SNMPRuntimeStats;
import weblogic.diagnostics.snmp.server.ServerStateLifecycle;
import weblogic.diagnostics.snmp.server.StringMonitorLifecycle;
import weblogic.jndi.Environment;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.SNMPAgentDeploymentMBean;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBean;
import weblogic.management.configuration.SNMPCounterMonitorMBean;
import weblogic.management.configuration.SNMPGaugeMonitorMBean;
import weblogic.management.configuration.SNMPLogFilterMBean;
import weblogic.management.configuration.SNMPProxyMBean;
import weblogic.management.configuration.SNMPStringMonitorMBean;
import weblogic.management.configuration.SNMPTrapDestinationMBean;
import weblogic.management.configuration.SNMPValidator;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class SNMPAgentDeploymentHandler
implements DeploymentHandler,
BeanUpdateListener {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String SNMP_DATA_FILE = "snmp/snmp.dat";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static final String DEFAULT_MASTER_AGENTX_HOST = "localhost";
    private static final int DEFAULT_MASTER_AGENTX_PORT = 705;
    static final String CUSTOM_MBEANS_SUB_AGENT_ID = "1.2.3.4.5.6";
    private static final String CUSTOM_MBEANS_MODULE_OID = "1.3.6.1.4.1.140.625.50";
    private static final String PROTOCOL = "wlx";
    private static final String JNDI = "/jndi/";
    private static final String RUNTIME_URI = "weblogic.management.mbeanservers.runtime";
    private static final String DOMAIN_RUNTIME_URI = "weblogic.management.mbeanservers.domainruntime";
    static final int AGENT_STOPPED = 0;
    static final int AGENT_STOPPING = 1;
    static final int AGENT_STARTING = 2;
    static final int AGENT_RUNNING = 3;
    private static final SNMPAgentDeploymentHandler SINGLETON = new SNMPAgentDeploymentHandler();
    private boolean snmpServiceStarted = false;
    private SNMPAgentMBean snmpAgentConfig;
    private SNMPAgentDeploymentMBean targettedAgentConfig;
    private SNMPAgentMBean domainAgentConfig;
    private SNMPV3Agent snmpAgent;
    private List<WLSMibMetadata> wlsMibMetadataList = new ArrayList<WLSMibMetadata>();
    private MBeanServerConnection mbeanServerConnection;
    private MBeanRegHandler regHandler = null;
    private boolean adminServer;
    private String serverName;
    private String domainName;
    private int serverCount;
    private String listenAddress;
    private int tcpListenPort;
    private List jmxMonitorLifecycleList = new LinkedList();
    private MBeanServerSubAgentX customMBeansSubAgent;
    private int agentState = 0;
    private SNMPRuntimeStats snmpRuntimeStats = new SNMPRuntimeStats();
    private List<SNMPExtensionProvider> snmpExtensionProviders = new ArrayList<SNMPExtensionProvider>();

    public static SNMPAgentDeploymentHandler getInstance() {
        return SINGLETON;
    }

    private SNMPAgentDeploymentHandler() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        this.adminServer = runtimeAccess.isAdminServer();
        this.serverName = runtimeAccess.getServerName();
        this.domainName = runtimeAccess.getDomainName();
        ServerMBean serverMBean = runtimeAccess.getServer();
        this.listenAddress = serverMBean.getListenAddress();
        this.tcpListenPort = serverMBean.getListenPort();
        this.serverCount = runtimeAccess.getDomain().getServers().length;
    }

    public boolean isAgentRunning() {
        return this.agentState == 3;
    }

    public boolean isAgentStarting() {
        return this.agentState == 2;
    }

    public boolean isAgentStopping() {
        return this.agentState == 1;
    }

    public boolean isAgentStopped() {
        return this.agentState == 0;
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof SNMPAgentDeploymentMBean) {
            SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean = (SNMPAgentDeploymentMBean)deploymentMBean;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Preparing SNMPAgentDeploymentMBean " + sNMPAgentDeploymentMBean.getName());
            }
        }
    }

    private String getSNMPDataFileName() {
        return DomainDir.getPathRelativeServersDataDir((String)this.serverName, (String)SNMP_DATA_FILE);
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof SNMPAgentDeploymentMBean) {
            SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean = (SNMPAgentDeploymentMBean)deploymentMBean;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Activating SNMPAgentDeploymentMBean " + sNMPAgentDeploymentMBean.getName());
            }
            try {
                this.stopSNMPAgent();
                this.setTargettedAgentConfig(sNMPAgentDeploymentMBean);
                this.activateSNMPAgent();
                this.registerBeanUpdateListener(sNMPAgentDeploymentMBean);
            }
            catch (Throwable throwable) {
                block7: {
                    if (DEBUG.isDebugEnabled()) {
                        DEBUG.debug("Caught exception during startup, shutting down agent", throwable);
                    }
                    SNMPLogger.logAgentInitFailed();
                    try {
                        this.stopSNMPAgent();
                    }
                    catch (Throwable throwable2) {
                        if (!DEBUG.isDebugEnabled()) break block7;
                        DEBUG.debug("Exception occurred shutting down agent", throwable2);
                    }
                }
                throw new DeploymentException(throwable);
            }
        }
    }

    public synchronized void activateSNMPAgent() throws Exception {
        try {
            this.initializeSNMPAgentConfig();
            if (this.snmpServiceStarted) {
                this.startSNMPAgent();
            }
        }
        catch (Exception exception) {
            SNMPLogger.logSNMPServiceFailure((Throwable)exception);
        }
    }

    private void initializeJMXMonitorLifecycleList() {
        this.jmxMonitorLifecycleList = new LinkedList();
        ServerStateLifecycle serverStateLifecycle = new ServerStateLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection);
        this.jmxMonitorLifecycleList.add(serverStateLifecycle);
        this.jmxMonitorLifecycleList.add(new MBeanAttributeChangeLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection));
        this.jmxMonitorLifecycleList.add(new GaugeMonitorLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection));
        this.jmxMonitorLifecycleList.add(new CounterMonitorLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection));
        this.jmxMonitorLifecycleList.add(new StringMonitorLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection));
        LogFilterLifecycle logFilterLifecycle = new LogFilterLifecycle(this.adminServer, this.serverName, this.snmpAgent, this.mbeanServerConnection);
        this.jmxMonitorLifecycleList.add(logFilterLifecycle);
        serverStateLifecycle.setLogFilterLifecycle(logFilterLifecycle);
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        try {
            if (deploymentMBean instanceof SNMPAgentDeploymentMBean) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Deactivating SNMPAgentDeploymentMBean " + deploymentMBean.getName());
                }
                SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean = (SNMPAgentDeploymentMBean)deploymentMBean;
                this.stopSNMPAgent();
                this.setTargettedAgentConfig(null);
                this.deregisterBeanUpdateListener(sNMPAgentDeploymentMBean);
            }
        }
        catch (Exception exception) {
            throw new UndeploymentException(exception);
        }
    }

    private synchronized void stopSNMPAgent() throws Exception {
        if (this.snmpAgent != null && this.snmpServiceStarted) {
            this.setAgentState(1);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Stopping SNMP Agent...");
            }
            if (this.regHandler != null) {
                this.regHandler.deregister();
                this.regHandler = null;
            }
            this.deregisterMonitorListeners();
            ProtocolHandlerSNMP.getSNMPProtocolHandler().setAgent(null);
            if (this.customMBeansSubAgent != null) {
                this.customMBeansSubAgent.deleteAllSNMPTableRows();
                this.customMBeansSubAgent.shutdown();
            }
            this.snmpAgent.getSNMPAgentToolkit().stopSNMPAgent();
            this.snmpRuntimeStats.setRunning(false);
            this.snmpRuntimeStats.setSNMPAgentName(null);
            this.snmpRuntimeStats.setSNMPAgentToolkit(null);
            this.snmpAgentConfig = null;
            this.snmpAgent = null;
            this.customMBeansSubAgent = null;
            this.jmxMonitorLifecycleList = null;
            this.wlsMibMetadataList.clear();
            if (!this.adminServer) {
                SNMPTrapUtil.getInstance().setSNMPTrapSender((SNMPTrapSender)new SNMPAdminServerTrapSender());
            } else {
                SNMPTrapUtil.getInstance().setSNMPTrapSender(null);
            }
            this.setAgentState(0);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("SNMP Agent stopped");
            }
            SNMPLogger.logAgentShutdownComplete();
        }
    }

    private void deregisterBeanUpdateListener(SNMPAgentMBean sNMPAgentMBean) {
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray;
        SNMPProxyMBean[] sNMPProxyMBeanArray;
        SNMPLogFilterMBean[] sNMPLogFilterMBeanArray;
        SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray;
        SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray;
        SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray;
        sNMPAgentMBean.removeBeanUpdateListener(this);
        SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = sNMPAgentMBean.getSNMPAttributeChanges();
        if (sNMPAttributeChangeMBeanArray != null) {
            for (int i = 0; i < sNMPAttributeChangeMBeanArray.length; ++i) {
                sNMPAttributeChangeMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPCounterMonitorMBeanArray = sNMPAgentMBean.getSNMPCounterMonitors()) != null) {
            for (int i = 0; i < sNMPCounterMonitorMBeanArray.length; ++i) {
                sNMPCounterMonitorMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPGaugeMonitorMBeanArray = sNMPAgentMBean.getSNMPGaugeMonitors()) != null) {
            for (int i = 0; i < sNMPGaugeMonitorMBeanArray.length; ++i) {
                sNMPGaugeMonitorMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPStringMonitorMBeanArray = sNMPAgentMBean.getSNMPStringMonitors()) != null) {
            for (int i = 0; i < sNMPStringMonitorMBeanArray.length; ++i) {
                sNMPStringMonitorMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPLogFilterMBeanArray = sNMPAgentMBean.getSNMPLogFilters()) != null) {
            for (int i = 0; i < sNMPLogFilterMBeanArray.length; ++i) {
                sNMPLogFilterMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPProxyMBeanArray = sNMPAgentMBean.getSNMPProxies()) != null) {
            for (int i = 0; i < sNMPProxyMBeanArray.length; ++i) {
                sNMPProxyMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
        if ((sNMPTrapDestinationMBeanArray = sNMPAgentMBean.getSNMPTrapDestinations()) != null) {
            for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
                sNMPTrapDestinationMBeanArray[i].removeBeanUpdateListener(this);
            }
        }
    }

    private void deregisterMonitorListeners() {
        for (JMXMonitorLifecycle jMXMonitorLifecycle : this.jmxMonitorLifecycleList) {
            jMXMonitorLifecycle.deregisterMonitorListeners();
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (deploymentMBean instanceof SNMPAgentDeploymentMBean) {
            SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean = (SNMPAgentDeploymentMBean)deploymentMBean;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Unpreparing SNMPAgentDeploymentMBean " + sNMPAgentDeploymentMBean.getName());
            }
        }
    }

    boolean isSNMPServiceStarted() {
        return this.snmpServiceStarted;
    }

    synchronized void setSNMPServiceStarted(boolean bl) {
        this.snmpServiceStarted = bl;
    }

    SNMPAgentMBean getSNMPAgentConfig() {
        return this.snmpAgentConfig;
    }

    private synchronized void initializeSNMPAgentConfig() {
        this.snmpAgentConfig = this.targettedAgentConfig == null || !this.targettedAgentConfig.isEnabled() ? this.domainAgentConfig : this.targettedAgentConfig;
        if (DEBUG.isDebugEnabled()) {
            String string = this.snmpAgentConfig == null ? "" : this.snmpAgentConfig.getName();
            DEBUG.debug("Using snmp agent " + string);
        }
    }

    private synchronized void startSNMPAgent() throws Exception {
        Object object;
        if (this.snmpAgentConfig == null) {
            return;
        }
        if (!this.snmpAgentConfig.isEnabled() || this.getAgentState() == 3) {
            return;
        }
        this.setAgentState(2);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Starting SNMPAgent");
        }
        SNMPLogger.logAgentInitializing();
        this.snmpAgent = new SNMPV3Agent();
        this.snmpAgent.setMaxPortRetryCount(this.serverCount);
        this.snmpAgent.setEngineId(this.snmpAgentConfig.getSNMPEngineId());
        this.snmpAgent.setCommunity(this.snmpAgentConfig.getCommunityPrefix());
        this.snmpAgent.setTcpListenAddress(this.listenAddress);
        this.snmpAgent.setTcpListenPort(this.tcpListenPort);
        this.snmpAgent.setUdpListenAddress(this.listenAddress);
        this.snmpAgent.setUdpListenPort(this.snmpAgentConfig.getSNMPPort());
        this.snmpAgent.setSNMPTrapVersion(this.snmpAgentConfig.getSNMPTrapVersion());
        this.snmpAgent.setAutomaticTrapsEnabled(this.snmpAgentConfig.isSendAutomaticTrapsEnabled());
        this.snmpAgent.setInformEnabled(this.snmpAgentConfig.isInformEnabled());
        this.snmpAgent.setInformRetryCount(this.snmpAgentConfig.getMaxInformRetryCount());
        this.snmpAgent.setInformTimeout(this.snmpAgentConfig.getInformRetryInterval());
        this.snmpAgent.setCommunityBasedAccessEnabled(this.snmpAgentConfig.isCommunityBasedAccessEnabled());
        this.snmpAgent.setSecurityLevel(SNMPValidator.getSecurityLevel(this.snmpAgentConfig));
        this.snmpAgent.setAuthProtocol(this.getAuthProtocol());
        this.snmpAgent.setPrivProtocol(this.getPrivProtocol());
        this.snmpAgent.setLocalizedKeyCacheInvalidationInterval(this.snmpAgentConfig.getLocalizedKeyCacheInvalidationInterval());
        this.snmpAgent.setSNMPDataFileName(this.getSNMPDataFileName());
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this.snmpAgentConfig.getSNMPTrapDestinations();
        this.configureTrapDestinations(sNMPTrapDestinationMBeanArray);
        this.wlsMibMetadataList.add(WLSMibMetadata.loadResource());
        try {
            this.discoverSNMPAgentExtensionProviders();
        }
        catch (Exception exception) {
            SNMPLogger.logSNMPExtensionProviderError((Throwable)exception);
        }
        this.snmpAgent.initialize();
        try {
            object = this.snmpAgentConfig.getSNMPProxies();
            this.configureSNMPProxies((SNMPProxyMBean[])object);
        }
        catch (Throwable throwable) {
            SNMPLogger.logUnableToProxy((Throwable)throwable);
        }
        SNMPTrapUtil.getInstance().setSNMPTrapSender((SNMPTrapSender)new SNMPLocalAgentTrapSender((SNMPAgent)this.snmpAgent));
        this.initializeMBeanServerConnection();
        try {
            object = DEFAULT_MASTER_AGENTX_HOST;
            if (this.listenAddress != null && this.listenAddress.length() > 0) {
                object = this.listenAddress;
            }
            this.snmpAgent.initializeMasterAgentX((String)object, this.snmpAgentConfig.getMasterAgentXPort());
            if (this.snmpAgentConfig.isSNMPAccessForUserMBeansEnabled()) {
                this.customMBeansSubAgent = (MBeanServerSubAgentX)this.snmpAgent.createSubAgentX(CUSTOM_MBEANS_SUB_AGENT_ID, CUSTOM_MBEANS_MODULE_OID);
                this.customMBeansSubAgent.createMIBModule("CUSTOM-MBEANS-MIB", "customMBeansMib", "MIB for custom MBeans registered in WLS RuntimeMBeanServer", "BEA Systems Inc.", "dev2dev@bea.com");
            }
        }
        catch (SNMPAgentToolkitException sNMPAgentToolkitException) {
            SNMPLogger.logSNMPAgentXInitializationFailure((Throwable)sNMPAgentToolkitException);
        }
        this.initializeJMXMonitorLifecycleList();
        this.initializerJMXMonitorLifecycles(this.snmpAgentConfig);
        this.initializeSNMPAgentRuntime();
        this.regHandler = new MBeanRegHandler(this.domainName, this.adminServer, this.serverName, this.snmpAgentConfig, this.mbeanServerConnection, this.snmpAgent, this.customMBeansSubAgent, this.wlsMibMetadataList, this.jmxMonitorLifecycleList);
        this.regHandler.initializeMBeanServerRegistration();
        ProtocolHandlerSNMP.getSNMPProtocolHandler().setAgent(this.snmpAgent);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Started SNMPAgent");
        }
        this.setAgentState(3);
        SNMPLogger.logAgentInitComplete();
    }

    private void discoverSNMPAgentExtensionProviders() throws WLSMibMetadataException {
        Serializable serializable;
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet.add(this.snmpAgent.getMibBasePath());
        hashSet2.add(this.snmpAgent.getMibModules());
        this.snmpExtensionProviders = SNMPExtensionProviderHelper.discoverSNMPAgentExtensionProviders();
        for (SNMPExtensionProvider object22 : this.snmpExtensionProviders) {
            object = object22.getBasePath();
            String string = object22.getMibModules();
            if (object != null) {
                hashSet.add(object);
            }
            if (string != null) {
                hashSet2.add(string);
            }
            if ((serializable = object22.getMibMetaData()) == null) continue;
            this.wlsMibMetadataList.add((WLSMibMetadata)serializable);
        }
        HashSet hashSet3 = new HashSet();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : hashSet) {
            if (hashSet3.contains(string)) continue;
            stringBuilder.append(string);
            stringBuilder.append(";");
            hashSet3.add(string);
        }
        object = stringBuilder.toString();
        DebugLogger debugLogger = SNMPExtensionProviderHelper.DEBUG_LOGGER;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("MIB base paths = " + (String)object);
        }
        this.snmpAgent.setMibBasePath((String)object);
        hashSet3.clear();
        serializable = new StringBuilder();
        for (String string : hashSet2) {
            if (hashSet3.contains(string)) continue;
            ((StringBuilder)serializable).append(string);
            ((StringBuilder)serializable).append(":");
            hashSet3.add(string);
        }
        String string = ((StringBuilder)serializable).toString();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("MIB module names = " + (String)string);
        }
        this.snmpAgent.setMibModules(string);
    }

    private void configureSNMPProxies(SNMPProxyMBean[] sNMPProxyMBeanArray) throws SNMPAgentToolkitException {
        if (sNMPProxyMBeanArray == null) {
            return;
        }
        SNMPProxyManager sNMPProxyManager = this.snmpAgent.getSNMPAgentToolkit().getSNMPProxyManager();
        for (int i = 0; i < sNMPProxyMBeanArray.length; ++i) {
            SNMPProxyMBean sNMPProxyMBean = sNMPProxyMBeanArray[i];
            String string = sNMPProxyMBean.getName();
            int n = sNMPProxyMBean.getPort();
            String string2 = "";
            String string3 = sNMPProxyMBean.getOidRoot();
            String string4 = sNMPProxyMBean.getCommunity();
            if (string4 == null || string4.length() == 0 || string4.equals("na")) {
                string4 = "public";
            }
            String string5 = sNMPProxyMBean.getSecurityName();
            int n2 = this.getSecurityLevelValue(sNMPProxyMBean.getSecurityLevel());
            long l = sNMPProxyMBean.getTimeout();
            sNMPProxyManager.addProxyAgent(string, string2, n, string3, string4, string5, n2, l);
        }
    }

    private int getSecurityLevelValue(String string) {
        if (string != null) {
            if (string.equals("noAuthNoPriv")) {
                return 0;
            }
            if (string.equals("authNoPriv")) {
                return 1;
            }
            if (string.equals("authPriv")) {
                return 3;
            }
        }
        return 0;
    }

    private void registerBeanUpdateListener(SNMPAgentMBean sNMPAgentMBean) {
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray;
        SNMPProxyMBean[] sNMPProxyMBeanArray;
        SNMPLogFilterMBean[] sNMPLogFilterMBeanArray;
        SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray;
        SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray;
        SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray;
        sNMPAgentMBean.addBeanUpdateListener(this);
        SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = sNMPAgentMBean.getSNMPAttributeChanges();
        if (sNMPAttributeChangeMBeanArray != null) {
            for (int i = 0; i < sNMPAttributeChangeMBeanArray.length; ++i) {
                sNMPAttributeChangeMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPCounterMonitorMBeanArray = sNMPAgentMBean.getSNMPCounterMonitors()) != null) {
            for (int i = 0; i < sNMPCounterMonitorMBeanArray.length; ++i) {
                sNMPCounterMonitorMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPGaugeMonitorMBeanArray = sNMPAgentMBean.getSNMPGaugeMonitors()) != null) {
            for (int i = 0; i < sNMPGaugeMonitorMBeanArray.length; ++i) {
                sNMPGaugeMonitorMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPStringMonitorMBeanArray = sNMPAgentMBean.getSNMPStringMonitors()) != null) {
            for (int i = 0; i < sNMPStringMonitorMBeanArray.length; ++i) {
                sNMPStringMonitorMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPLogFilterMBeanArray = sNMPAgentMBean.getSNMPLogFilters()) != null) {
            for (int i = 0; i < sNMPLogFilterMBeanArray.length; ++i) {
                sNMPLogFilterMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPProxyMBeanArray = sNMPAgentMBean.getSNMPProxies()) != null) {
            for (int i = 0; i < sNMPProxyMBeanArray.length; ++i) {
                sNMPProxyMBeanArray[i].addBeanUpdateListener(this);
            }
        }
        if ((sNMPTrapDestinationMBeanArray = sNMPAgentMBean.getSNMPTrapDestinations()) != null) {
            for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
                sNMPTrapDestinationMBeanArray[i].addBeanUpdateListener(this);
            }
        }
    }

    private void initializeSNMPAgentRuntime() throws ManagementException {
        SNMPV3AgentToolkit sNMPV3AgentToolkit = (SNMPV3AgentToolkit)this.snmpAgent.getSNMPAgentToolkit();
        if (this.snmpRuntimeStats == null) {
            this.snmpRuntimeStats = new SNMPRuntimeStats(sNMPV3AgentToolkit);
        } else {
            this.snmpRuntimeStats.setSNMPAgentToolkit(sNMPV3AgentToolkit);
        }
        this.snmpRuntimeStats.setRunning(true);
        this.snmpRuntimeStats.setSNMPAgentName(this.snmpAgentConfig == null ? null : this.snmpAgentConfig.getName());
        for (JMXMonitorLifecycle jMXMonitorLifecycle : this.jmxMonitorLifecycleList) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Got JMXMonitorLifecycle " + jMXMonitorLifecycle.getClass().getName());
            }
            Iterator iterator = jMXMonitorLifecycle.getJMXMonitorListeners();
            while (iterator.hasNext()) {
                JMXMonitorListener jMXMonitorListener = (JMXMonitorListener)iterator.next();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Setting SNMP stats " + jMXMonitorListener.getClass().getName());
                }
                jMXMonitorListener.setSNMPRuntimeStats(this.snmpRuntimeStats);
            }
        }
        this.ensureSNMPAgentRuntimeInitialized();
    }

    synchronized void ensureSNMPAgentRuntimeInitialized() throws ManagementException {
        DomainRuntimeMBean domainRuntimeMBean;
        SNMPAgentRuntime sNMPAgentRuntime = null;
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServerRuntime();
        if (serverRuntimeMBean.getSNMPAgentRuntime() == null) {
            sNMPAgentRuntime = new SNMPAgentRuntime(serverRuntimeMBean, this.snmpRuntimeStats);
            serverRuntimeMBean.setSNMPAgentRuntime(sNMPAgentRuntime);
        }
        if (this.adminServer && (domainRuntimeMBean = ManagementService.getDomainAccess(KERNEL_ID).getDomainRuntime()).getSNMPAgentRuntime() == null) {
            sNMPAgentRuntime = new SNMPAgentRuntime(domainRuntimeMBean, this.snmpRuntimeStats);
            domainRuntimeMBean.setSNMPAgentRuntime(sNMPAgentRuntime);
        }
    }

    private void initializerJMXMonitorLifecycles(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        for (JMXMonitorLifecycle jMXMonitorLifecycle : this.jmxMonitorLifecycleList) {
            jMXMonitorLifecycle.initializeMonitorListenerList(sNMPAgentMBean);
        }
    }

    private int getAuthProtocol() {
        if (this.snmpAgentConfig == null) {
            return 0;
        }
        String string = this.snmpAgentConfig.getAuthenticationProtocol();
        if (string.equals("MD5")) {
            return 0;
        }
        if (string.equals("SHA")) {
            return 1;
        }
        return 0;
    }

    private int getPrivProtocol() {
        if (this.snmpAgentConfig == null) {
            return 2;
        }
        String string = this.snmpAgentConfig.getPrivacyProtocol();
        if (string.equals("DES")) {
            return 2;
        }
        if (string.equals("AES_128")) {
            return 3;
        }
        return 2;
    }

    private void configureTrapDestinations(SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray) {
        if (sNMPTrapDestinationMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
            SNMPTrapDestinationMBean sNMPTrapDestinationMBean = sNMPTrapDestinationMBeanArray[i];
            SNMPTrapDestination sNMPTrapDestination = this.snmpAgent.createSNMPTrapDestination(sNMPTrapDestinationMBean.getName());
            sNMPTrapDestination.setCommunity(sNMPTrapDestinationMBean.getCommunity());
            sNMPTrapDestination.setHost(sNMPTrapDestinationMBean.getHost());
            sNMPTrapDestination.setPort(sNMPTrapDestinationMBean.getPort());
            sNMPTrapDestination.setSecurityName(sNMPTrapDestinationMBean.getSecurityName());
            sNMPTrapDestination.setSecurityLevel(this.getSecurityLevelValue(sNMPTrapDestinationMBean.getSecurityLevel()));
        }
    }

    private void initializeMBeanServerConnection() throws Exception {
        String string = this.adminServer ? DOMAIN_RUNTIME_URI : RUNTIME_URI;
        this.mbeanServerConnection = SNMPAgentDeploymentHandler.getConnection(string);
    }

    private static MBeanServerConnection getConnection(String string) throws Exception {
        JMXServiceURL jMXServiceURL = new JMXServiceURL(PROTOCOL, null, 0, JNDI + string);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        hashtable.put("weblogic.context", SNMPAgentDeploymentHandler.getContext());
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
        return jMXConnector.getMBeanServerConnection();
    }

    private static Context getContext() throws Exception {
        Environment environment = new Environment();
        return environment.getInitialContext();
    }

    SNMPV3Agent getSNMPAgent() {
        return this.snmpAgent;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Activating update");
        }
        SNMPAgentDeploymentHandler sNMPAgentDeploymentHandler = this;
        synchronized (sNMPAgentDeploymentHandler) {
            block6: {
                try {
                    this.stopSNMPAgent();
                    this.activateSNMPAgent();
                }
                catch (Exception exception) {
                    if (!DEBUG.isDebugEnabled()) break block6;
                    DEBUG.debug("Error updating SNMPAgent", (Throwable)exception);
                }
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    SNMPAgentMBean getDomainAgentConfig() {
        return this.domainAgentConfig;
    }

    void setDomainAgentConfig(SNMPAgentMBean sNMPAgentMBean) {
        this.domainAgentConfig = sNMPAgentMBean;
        this.registerBeanUpdateListener(sNMPAgentMBean);
    }

    SNMPAgentMBean getTargettedAgentConfig() {
        return this.targettedAgentConfig;
    }

    void setTargettedAgentConfig(SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean) {
        this.targettedAgentConfig = sNMPAgentDeploymentMBean;
    }

    synchronized int getAgentState() {
        return this.agentState;
    }

    private synchronized void setAgentState(int n) {
        this.agentState = n;
    }
}

