/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.server.SNMPRuntimeStats;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SNMPAgentRuntimeMBean;

public class SNMPAgentRuntime
extends RuntimeMBeanDelegate
implements SNMPAgentRuntimeMBean {
    private SNMPRuntimeStats snmpRuntimeStats;
    private String snmpAgentName;

    public SNMPAgentRuntime(RuntimeMBean runtimeMBean, SNMPRuntimeStats sNMPRuntimeStats) throws ManagementException {
        super(runtimeMBean.getName(), runtimeMBean);
        this.snmpRuntimeStats = sNMPRuntimeStats;
    }

    public long getAttributeChangeTrapCount() {
        return this.snmpRuntimeStats.getAttributeChangeTrapCount();
    }

    public long getCounterMonitorTrapCount() {
        return this.snmpRuntimeStats.getCounterMonitorTrapCount();
    }

    public long getGaugeMonitorTrapCount() {
        return this.snmpRuntimeStats.getGaugeMonitorTrapCount();
    }

    public long getLogMessageTrapCount() {
        return this.snmpRuntimeStats.getLogMessageTrapCount();
    }

    public long getMonitorTrapCount() {
        return this.snmpRuntimeStats.getMonitorTrapCount();
    }

    public boolean isRunning() {
        return this.snmpRuntimeStats.isRunning();
    }

    public long getStringMonitorTrapCount() {
        return this.snmpRuntimeStats.getStringMonitorTrapCount();
    }

    public long getServerStartTrapCount() {
        return this.snmpRuntimeStats.getServerStartTrapCount();
    }

    public long getServerStopTrapCount() {
        return this.snmpRuntimeStats.getServerStopTrapCount();
    }

    public String getSNMPAgentListenAddress() {
        return this.snmpRuntimeStats.getSNMPAgentListenAddress();
    }

    public int getUDPListenPort() {
        return this.snmpRuntimeStats.getSNMPAgentUDPPort();
    }

    public String getMasterAgentXListenAddress() {
        return this.snmpRuntimeStats.getMasterAgentXListenAddress();
    }

    public int getMasterAgentXPort() {
        return this.snmpRuntimeStats.getMasterAgentXPort();
    }

    public String outputCustomMBeansMIBModule() throws ManagementException {
        try {
            return this.snmpRuntimeStats.getCustomMBeansSubAgentMIB();
        }
        catch (SNMPAgentToolkitException sNMPAgentToolkitException) {
            ManagementException managementException = new ManagementException(sNMPAgentToolkitException.getMessage());
            managementException.setStackTrace(sNMPAgentToolkitException.getStackTrace());
            throw managementException;
        }
    }

    public int getFailedAuthenticationCount() {
        return this.snmpRuntimeStats.getFailedAuthenticationCount();
    }

    public int getFailedAuthorizationCount() {
        return this.snmpRuntimeStats.getFailedAuthorizationCount();
    }

    public int getFailedEncryptionCount() {
        return this.snmpRuntimeStats.getFailedEncryptionCount();
    }

    public void invalidateLocalizedKeyCache(String string) {
        this.snmpRuntimeStats.invalidateLocalizedKeyCache(string);
    }

    SNMPRuntimeStats getSNMPRuntimeStats() {
        return this.snmpRuntimeStats;
    }

    void setSNMPRuntimeStats(SNMPRuntimeStats sNMPRuntimeStats) {
        this.snmpRuntimeStats = sNMPRuntimeStats;
    }

    public String getSNMPAgentName() {
        return this.snmpRuntimeStats.getSNMPAgentName();
    }
}

