/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.agent.SNMPSecurityManager;
import weblogic.diagnostics.snmp.agent.SNMPSubAgentX;
import weblogic.diagnostics.snmp.agent.SNMPV3AgentToolkit;

class SNMPRuntimeStats {
    private boolean running;
    private long attributeChangeTrapCount;
    private long monitorTrapCount;
    private long counterMonitorTrapCount;
    private long gaugeMonitorTrapCount;
    private long stringMonitorTrapCount;
    private long logMessageTrapCount;
    private long serverStartTrapCount;
    private long serverStopTrapCount;
    private int failedAuthenticationCount;
    private int failedAuthorizationCount;
    private int failedEncryptionCount;
    private String snmpAgentName;
    private SNMPV3AgentToolkit snmpAgentToolkit;

    SNMPRuntimeStats() {
    }

    SNMPRuntimeStats(SNMPV3AgentToolkit sNMPV3AgentToolkit) {
        this.snmpAgentToolkit = sNMPV3AgentToolkit;
    }

    public long getAttributeChangeTrapCount() {
        return this.attributeChangeTrapCount;
    }

    public long getCounterMonitorTrapCount() {
        return this.counterMonitorTrapCount;
    }

    public long getGaugeMonitorTrapCount() {
        return this.gaugeMonitorTrapCount;
    }

    public long getLogMessageTrapCount() {
        return this.logMessageTrapCount;
    }

    public long getMonitorTrapCount() {
        return this.monitorTrapCount;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getServerStartTrapCount() {
        return this.serverStartTrapCount;
    }

    public long getServerStopTrapCount() {
        return this.serverStopTrapCount;
    }

    public long getStringMonitorTrapCount() {
        return this.stringMonitorTrapCount;
    }

    void setRunning(boolean bl) {
        this.running = bl;
    }

    synchronized void incrementAttributeChangeTrapCount() {
        ++this.attributeChangeTrapCount;
        ++this.monitorTrapCount;
    }

    synchronized void incrementCounterMonitorTrapCount() {
        ++this.counterMonitorTrapCount;
        ++this.monitorTrapCount;
    }

    synchronized void incrementGaugeMonitorTrapCount() {
        ++this.gaugeMonitorTrapCount;
        ++this.monitorTrapCount;
    }

    synchronized void incrementStringMonitorTrapCount() {
        ++this.stringMonitorTrapCount;
        ++this.monitorTrapCount;
    }

    synchronized void incrementLogMessageTrapCount() {
        ++this.logMessageTrapCount;
        ++this.monitorTrapCount;
    }

    synchronized void incrementServerStartTrapCount() {
        ++this.serverStartTrapCount;
    }

    synchronized void incrementServerStopTrapCount() {
        ++this.serverStopTrapCount;
    }

    String getSNMPAgentListenAddress() {
        if (this.snmpAgentToolkit == null) {
            return "";
        }
        return this.snmpAgentToolkit.getSNMPAgentListenAddress();
    }

    int getSNMPAgentUDPPort() {
        if (this.snmpAgentToolkit == null) {
            return -1;
        }
        return this.snmpAgentToolkit.getSNMPAgentUDPPort();
    }

    String getMasterAgentXListenAddress() {
        if (this.snmpAgentToolkit == null) {
            return "";
        }
        return this.snmpAgentToolkit.getMasterAgentXListenAddress();
    }

    int getMasterAgentXPort() {
        if (this.snmpAgentToolkit == null) {
            return -1;
        }
        return this.snmpAgentToolkit.getMasterAgentXPort();
    }

    String getCustomMBeansSubAgentMIB() throws SNMPAgentToolkitException {
        if (this.snmpAgentToolkit == null) {
            return "";
        }
        SNMPSubAgentX sNMPSubAgentX = this.snmpAgentToolkit.findSNMPSubAgentX("1.2.3.4.5.6");
        if (sNMPSubAgentX != null) {
            return sNMPSubAgentX.outputMIBModule();
        }
        return "";
    }

    public int getFailedAuthenticationCount() {
        int n;
        if (this.snmpAgentToolkit == null) {
            return this.failedAuthenticationCount;
        }
        SNMPSecurityManager sNMPSecurityManager = this.snmpAgentToolkit.getSNMPSecurityManager();
        int n2 = n = sNMPSecurityManager != null ? sNMPSecurityManager.getFailedAuthenticationCount() : 0;
        if (n > this.failedAuthenticationCount) {
            this.failedAuthenticationCount = n;
        }
        return this.failedAuthenticationCount;
    }

    public int getFailedAuthorizationCount() {
        int n;
        if (this.snmpAgentToolkit == null) {
            return this.failedAuthorizationCount;
        }
        SNMPSecurityManager sNMPSecurityManager = this.snmpAgentToolkit.getSNMPSecurityManager();
        int n2 = n = sNMPSecurityManager != null ? sNMPSecurityManager.getFailedAuthorizationCount() : 0;
        if (n > this.failedAuthorizationCount) {
            this.failedAuthorizationCount = n;
        }
        return this.failedAuthorizationCount;
    }

    public int getFailedEncryptionCount() {
        int n;
        if (this.snmpAgentToolkit == null) {
            return this.failedEncryptionCount;
        }
        SNMPSecurityManager sNMPSecurityManager = this.snmpAgentToolkit.getSNMPSecurityManager();
        int n2 = n = sNMPSecurityManager != null ? sNMPSecurityManager.getFailedEncryptionCount() : 0;
        if (n > this.failedEncryptionCount) {
            this.failedEncryptionCount = n;
        }
        return this.failedEncryptionCount;
    }

    public void invalidateLocalizedKeyCache(String string) {
        if (this.snmpAgentToolkit == null) {
            return;
        }
        SNMPSecurityManager sNMPSecurityManager = this.snmpAgentToolkit.getSNMPSecurityManager();
        if (sNMPSecurityManager != null) {
            sNMPSecurityManager.invalidateLocalizedKeyCache(string);
        }
    }

    public SNMPV3AgentToolkit getSNMPAgentToolkit() {
        return this.snmpAgentToolkit;
    }

    public void setSNMPAgentToolkit(SNMPV3AgentToolkit sNMPV3AgentToolkit) {
        this.snmpAgentToolkit = sNMPV3AgentToolkit;
    }

    public String getSNMPAgentName() {
        return this.snmpAgentName;
    }

    public void setSNMPAgentName(String string) {
        this.snmpAgentName = string;
    }
}

