/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPTrapSender;
import weblogic.diagnostics.snmp.agent.SNMPTrapUtil;
import weblogic.diagnostics.snmp.agent.SNMPV3Agent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.SNMPAdminServerTrapSender;
import weblogic.diagnostics.snmp.server.SNMPAgentDeploymentHandler;
import weblogic.diagnostics.snmp.server.ServerStateTrapUtil;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class SNMPService
extends AbstractServerService {
    static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private String serverName;

    public void start() throws ServiceFailureException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Starting SNMP Service");
        }
        SNMPAgentDeploymentHandler sNMPAgentDeploymentHandler = SNMPAgentDeploymentHandler.getInstance();
        boolean bl = false;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        bl = runtimeAccess.isAdminServer();
        this.serverName = runtimeAccess.getServerName();
        if (bl) {
            SNMPAgentMBean sNMPAgentMBean = domainMBean.getSNMPAgent();
            sNMPAgentDeploymentHandler.setDomainAgentConfig(sNMPAgentMBean);
        } else {
            SNMPTrapUtil.getInstance().setSNMPTrapSender((SNMPTrapSender)new SNMPAdminServerTrapSender());
        }
        try {
            sNMPAgentDeploymentHandler.setSNMPServiceStarted(true);
            sNMPAgentDeploymentHandler.activateSNMPAgent();
            sNMPAgentDeploymentHandler.ensureSNMPAgentRuntimeInitialized();
        }
        catch (Exception exception) {
            SNMPLogger.logSNMPServiceFailure((Throwable)exception);
        }
    }

    public void stop() throws ServiceFailureException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Stopping SNMPService");
        }
        SNMPAgentDeploymentHandler sNMPAgentDeploymentHandler = SNMPAgentDeploymentHandler.getInstance();
        try {
            SNMPV3Agent sNMPV3Agent = sNMPAgentDeploymentHandler.getSNMPAgent();
            if (sNMPV3Agent != null) {
                ServerStateTrapUtil.sendServerLifecycleNotification(sNMPV3Agent, this.serverName, "wlsServerShutDown");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sNMPAgentDeploymentHandler.setSNMPServiceStarted(false);
    }

    public void halt() throws ServiceFailureException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Halting SNMPService");
        }
        this.stop();
    }
}

