/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.LogFilterLifecycle;
import weblogic.diagnostics.snmp.server.ServerStateListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;

public class ServerStateLifecycle
extends JMXMonitorLifecycle {
    private LogFilterLifecycle logFilterLifecycle;

    public ServerStateLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
        this.deregisterMonitorListener = true;
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        if (this.adminServer) {
            this.initializeAdminServerLifecycleListeners();
        } else {
            this.initializeManagedServerRuntimeListener();
        }
    }

    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
    }

    private void initializeAdminServerLifecycleListeners() throws Exception {
        ObjectName objectName = (ObjectName)this.mbeanServerConnection.getAttribute(new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME), "DomainRuntime");
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Found " + objectName);
        }
        ObjectName[] objectNameArray = (ObjectName[])this.mbeanServerConnection.getAttribute(objectName, "ServerLifeCycleRuntimes");
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Found " + objectName2);
            }
            String string = (String)this.mbeanServerConnection.getAttribute(objectName2, "Name");
            ServerStateListener serverStateListener = new ServerStateListener(this, string, this.snmpAgent);
            this.monitorListenerList.add(serverStateListener);
            this.registerMonitorListener(objectName2, serverStateListener, null);
        }
    }

    private void initializeManagedServerRuntimeListener() throws Exception {
        ObjectName objectName = (ObjectName)this.mbeanServerConnection.getAttribute(new ObjectName(RuntimeServiceMBean.OBJECT_NAME), "ServerRuntime");
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Found " + objectName);
        }
        String string = (String)this.mbeanServerConnection.getAttribute(objectName, "Name");
        ServerStateListener serverStateListener = new ServerStateListener(this, string, this.snmpAgent);
        this.monitorListenerList.add(serverStateListener);
        this.registerMonitorListener(objectName, serverStateListener, null);
    }

    public void setLogFilterLifecycle(LogFilterLifecycle logFilterLifecycle) {
        this.logFilterLifecycle = logFilterLifecycle;
    }

    void serverStarted(String string) {
        if (this.logFilterLifecycle != null) {
            this.logFilterLifecycle.serverStarted(string);
        }
    }

    void serverStopped(String string) {
        if (this.logFilterLifecycle != null) {
            this.logFilterLifecycle.serverStopped(string);
        }
    }
}

